/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResourceBundleEditorFileListener
implements VirtualFileListener {
    private static final Logger LOG = Logger.getInstance(ResourceBundleEditorFileListener.class);
    private static final Update FORCE_UPDATE = new Update("FORCE_UPDATE"){

        public void run() {
            throw new IllegalStateException();
        }
    };
    private final ResourceBundleEditor myEditor;
    private final MyVfsEventsProcessor myEventsProcessor;
    private final Project myProject;

    ResourceBundleEditorFileListener(ResourceBundleEditor editor) {
        this.myEditor = editor;
        this.myEventsProcessor = new MyVfsEventsProcessor();
        this.myProject = this.myEditor.getResourceBundle().getProject();
    }

    public void flush() {
        FileDocumentManager.getInstance().saveAllDocuments();
        this.myEventsProcessor.flush();
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            ResourceBundleEditorFileListener.$$$reportNull$$$0(0);
        }
        this.myEventsProcessor.queue(event, EventType.FILE_CREATED);
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            ResourceBundleEditorFileListener.$$$reportNull$$$0(1);
        }
        this.myEventsProcessor.queue(event, EventType.FILE_DELETED);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            ResourceBundleEditorFileListener.$$$reportNull$$$0(2);
        }
        this.myEventsProcessor.queue((VirtualFileEvent)event, EventType.PROPERTY_CHANGED);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            ResourceBundleEditorFileListener.$$$reportNull$$$0(3);
        }
        this.myEventsProcessor.queue(event, EventType.CONTENT_CHANGED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/lang/properties/editor/ResourceBundleEditorFileListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCreated";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDeleted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "contentsChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EventWithType {
        @NotNull
        private final EventType myType;
        @NotNull
        private final VirtualFile myFile;
        private final String myPropertyName;
        private final Object myPropertyNewValue;

        private EventWithType(@NotNull EventType type, @NotNull VirtualFileEvent event) {
            if (type == null) {
                EventWithType.$$$reportNull$$$0(0);
            }
            if (event == null) {
                EventWithType.$$$reportNull$$$0(1);
            }
            this.myType = type;
            this.myFile = event.getFile();
            if (type == EventType.PROPERTY_CHANGED) {
                this.myPropertyName = ((VirtualFilePropertyEvent)event).getPropertyName();
                this.myPropertyNewValue = ((VirtualFilePropertyEvent)event).getNewValue();
            } else {
                this.myPropertyName = null;
                this.myPropertyNewValue = null;
            }
        }

        @NotNull
        public EventType getType() {
            EventType eventType = this.myType;
            if (eventType == null) {
                EventWithType.$$$reportNull$$$0(2);
            }
            return eventType;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                EventWithType.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        @NotNull
        public String getPropertyName() {
            LOG.assertTrue(this.myType == EventType.PROPERTY_CHANGED, (Object)("Unexpected event type: " + (Object)((Object)this.myType)));
            String string = (String)ObjectUtils.notNull((Object)this.myPropertyName);
            if (string == null) {
                EventWithType.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public Object getPropertyNewValue() {
            LOG.assertTrue(this.myType == EventType.PROPERTY_CHANGED, (Object)("Unexpected event type: " + (Object)((Object)this.myType)));
            Object object = ObjectUtils.notNull((Object)this.myPropertyNewValue);
            if (object == null) {
                EventWithType.$$$reportNull$$$0(5);
            }
            return object;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventWithType type = (EventWithType)o;
            if (this.myType != type.myType) {
                return false;
            }
            if (!this.myFile.equals(type.myFile)) {
                return false;
            }
            if (!Objects.equals(this.myPropertyName, type.myPropertyName)) {
                return false;
            }
            return Objects.equals(this.myPropertyNewValue, type.myPropertyNewValue);
        }

        public int hashCode() {
            int result = this.myType.hashCode();
            result = 31 * result + this.myFile.hashCode();
            result = 31 * result + (this.myPropertyName != null ? this.myPropertyName.hashCode() : 0);
            result = 31 * result + (this.myPropertyNewValue != null ? this.myPropertyNewValue.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/properties/editor/ResourceBundleEditorFileListener$EventWithType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/properties/editor/ResourceBundleEditorFileListener$EventWithType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPropertyName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPropertyNewValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum EventType {
        FILE_CREATED,
        FILE_DELETED,
        CONTENT_CHANGED,
        PROPERTY_CHANGED;

    }

    private class SetViewerPropertyRunnable
    implements Runnable {
        private final List<VirtualFile> myFiles = new ArrayList<VirtualFile>();
        private final List<Boolean> myIsViewer = new ArrayList<Boolean>();

        private SetViewerPropertyRunnable() {
        }

        public void addFile(VirtualFile virtualFile, boolean isViewer) {
            this.myFiles.add(virtualFile);
            this.myIsViewer.add(isViewer);
        }

        @Override
        public void run() {
            for (int i = 0; i < this.myFiles.size(); ++i) {
                VirtualFile file = this.myFiles.get(i);
                Boolean viewer = this.myIsViewer.get(i);
                EditorEx editor = ResourceBundleEditorFileListener.this.myEditor.getTranslationEditors().get(file);
                if (editor == null) continue;
                editor.setViewer(viewer.booleanValue());
            }
        }
    }

    private class MyVfsEventsProcessor {
        private final AtomicReference<Set<EventWithType>> myEventQueue = new AtomicReference<Set>(ContainerUtil.newConcurrentSet());
        private final MergingUpdateQueue myUpdateQueue = new MergingUpdateQueue("rbe.vfs.listener.queue", 200, true, ResourceBundleEditorFileListener.access$100(ResourceBundleEditorFileListener.this).getComponent(), (Disposable)ResourceBundleEditorFileListener.access$100(ResourceBundleEditorFileListener.this), ResourceBundleEditorFileListener.access$100(ResourceBundleEditorFileListener.this).getComponent(), false){

            protected void execute(@NotNull Update[] updates) {
                if (updates == null) {
                    1.$$$reportNull$$$0(0);
                }
                ReadTask task = new ReadTask(){
                    final Set<EventWithType> myEvents;
                    {
                        this.myEvents = MyVfsEventsProcessor.this.myEventQueue.getAndSet(ContainerUtil.newConcurrentSet());
                    }

                    @Nullable
                    public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                        if (indicator == null) {
                            MyVfsEventsProcessor.1.$$$reportNull$$$0(0);
                        }
                        if (!ResourceBundleEditorFileListener.this.myEditor.isValid()) {
                            return null;
                        }
                        Runnable toDo = null;
                        NotNullLazyValue<Set<VirtualFile>> resourceBundleAsSet = new NotNullLazyValue<Set<VirtualFile>>(){

                            @NotNull
                            protected Set<VirtualFile> compute() {
                                Set<VirtualFile> set = ResourceBundleEditorFileListener.this.myEditor.getResourceBundle().getPropertiesFiles().stream().map(PropertiesFile::getVirtualFile).collect(Collectors.toSet());
                                if (set == null) {
                                    MyVfsEventsProcessor.1.$$$reportNull$$$0(0);
                                }
                                return set;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditorFileListener$MyVfsEventsProcessor$1$1$1", "compute"));
                            }
                        };
                        for (EventWithType e : this.myEvents) {
                            if (e.getType() == EventType.FILE_DELETED || e.getType() == EventType.PROPERTY_CHANGED && e.getPropertyName().equals("name")) {
                                if (ResourceBundleEditorFileListener.this.myEditor.getTranslationEditors().containsKey(e.getFile())) {
                                    int validFilesCount = 0;
                                    ResourceBundle bundle = ResourceBundleEditorFileListener.this.myEditor.getResourceBundle();
                                    if (bundle.isValid()) {
                                        for (PropertiesFile file : bundle.getPropertiesFiles()) {
                                            if (file.getContainingFile().isValid()) {
                                                ++validFilesCount;
                                            }
                                            if (validFilesCount != 2) continue;
                                            break;
                                        }
                                    }
                                    if (validFilesCount > 1) {
                                        toDo = ResourceBundleEditorFileListener.this.myEditor::recreateEditorsPanel;
                                        break;
                                    }
                                    toDo = () -> {
                                        FileEditorManagerEx fileEditorManager = (FileEditorManagerEx)FileEditorManager.getInstance((Project)ResourceBundleEditorFileListener.this.myProject);
                                        VirtualFile file = fileEditorManager.getFile((FileEditor)ResourceBundleEditorFileListener.this.myEditor);
                                        if (file != null) {
                                            fileEditorManager.closeFile(file);
                                        }
                                    };
                                    break;
                                }
                                if (!((Set)resourceBundleAsSet.getValue()).contains(e.getFile())) continue;
                                toDo = ResourceBundleEditorFileListener.this.myEditor::recreateEditorsPanel;
                                break;
                            }
                            if (e.getType() == EventType.FILE_CREATED) {
                                if (!((Set)resourceBundleAsSet.getValue()).contains(e.getFile())) continue;
                                toDo = ResourceBundleEditorFileListener.this.myEditor::recreateEditorsPanel;
                                break;
                            }
                            if (e.getType() == EventType.PROPERTY_CHANGED && e.getPropertyName().equals("writable")) {
                                if (!ResourceBundleEditorFileListener.this.myEditor.getTranslationEditors().containsKey(e.getFile())) continue;
                                if (toDo == null) {
                                    toDo = new SetViewerPropertyRunnable();
                                }
                                if (toDo instanceof SetViewerPropertyRunnable) {
                                    ((SetViewerPropertyRunnable)toDo).addFile(e.getFile(), (Boolean)e.getPropertyNewValue() == false);
                                    continue;
                                }
                                toDo = ResourceBundleEditorFileListener.this.myEditor::recreateEditorsPanel;
                                break;
                            }
                            if (!ResourceBundleEditorFileListener.this.myEditor.getTranslationEditors().containsKey(e.getFile())) continue;
                            if (toDo instanceof SetViewerPropertyRunnable) {
                                toDo = ResourceBundleEditorFileListener.this.myEditor::recreateEditorsPanel;
                                break;
                            }
                            if (toDo != null) continue;
                            toDo = () -> ResourceBundleEditorFileListener.this.myEditor.updateEditorsFromProperties(true);
                        }
                        if (toDo == null) {
                            return null;
                        }
                        Runnable toDoCopy = toDo;
                        return new ReadTask.Continuation(() -> {
                            if (ResourceBundleEditorFileListener.this.myEditor.isValid()) {
                                toDoCopy.run();
                            }
                        }, ModalityState.NON_MODAL);
                    }

                    public void onCanceled(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            MyVfsEventsProcessor.1.$$$reportNull$$$0(1);
                        }
                        MyVfsEventsProcessor.this.myEventQueue.updateAndGet(s -> {
                            s.addAll(this.myEvents);
                            return s;
                        });
                        MyVfsEventsProcessor.this.myUpdateQueue.queue(FORCE_UPDATE);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "indicator";
                        objectArray2[1] = "com/intellij/lang/properties/editor/ResourceBundleEditorFileListener$MyVfsEventsProcessor$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "performInReadAction";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onCanceled";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)task);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updates", "com/intellij/lang/properties/editor/ResourceBundleEditorFileListener$MyVfsEventsProcessor$1", "execute"));
            }
        };

        private MyVfsEventsProcessor() {
        }

        public void queue(VirtualFileEvent event, EventType type) {
            this.myEventQueue.updateAndGet(s -> {
                s.add(new EventWithType(type, event));
                return s;
            });
            this.myUpdateQueue.queue(FORCE_UPDATE);
        }

        public void flush() {
            this.myUpdateQueue.flush();
        }
    }
}

