/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertiesFileType
extends LanguageFileType {
    public static final LanguageFileType INSTANCE = new PropertiesFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "properties";
    @NonNls
    public static final String DOT_DEFAULT_EXTENSION = ".properties";

    private PropertiesFileType() {
        super((Language)PropertiesLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        if ("Properties" == null) {
            PropertiesFileType.$$$reportNull$$$0(0);
        }
        return "Properties";
    }

    @NotNull
    public String getDescription() {
        String string = PropertiesBundle.message("properties.files.file.type.description", new Object[0]);
        if (string == null) {
            PropertiesFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        if (DEFAULT_EXTENSION == null) {
            PropertiesFileType.$$$reportNull$$$0(2);
        }
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Properties;
    }

    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        Charset charset;
        if (file == null) {
            PropertiesFileType.$$$reportNull$$$0(3);
        }
        if (content == null) {
            PropertiesFileType.$$$reportNull$$$0(4);
        }
        LoadTextUtil.DetectResult guessed = LoadTextUtil.guessFromContent((VirtualFile)file, (byte[])content);
        Charset charset2 = charset = guessed.hardCodedCharset == null ? EncodingRegistry.getInstance().getDefaultCharsetForPropertiesFiles(file) : guessed.hardCodedCharset;
        if (charset == null) {
            charset = CharsetToolkit.getDefaultSystemCharset();
        }
        if (EncodingRegistry.getInstance().isNative2Ascii(file)) {
            charset = Native2AsciiCharset.wrap((Charset)charset);
        }
        return charset.name();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/PropertiesFileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExtension";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/PropertiesFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

