/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.context.WorkingContextManager;
import com.intellij.tasks.impl.TaskManagerImpl;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskCheckinHandlerFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(final @NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        if (panel == null) {
            TaskCheckinHandlerFactory.$$$reportNull$$$0(0);
        }
        if (commitContext == null) {
            TaskCheckinHandlerFactory.$$$reportNull$$$0(1);
        }
        CheckinHandler checkinHandler = new CheckinHandler(){

            public void checkinSuccessful() {
                String message = panel.getCommitMessage();
                Project project = panel.getProject();
                TaskManagerImpl manager = (TaskManagerImpl)TaskManager.getManager((Project)project);
                if (manager.getState().saveContextOnCommit) {
                    Task task = TaskCheckinHandlerFactory.findTaskInRepositories(message, (TaskManager)manager);
                    if (task == null) {
                        task = manager.createLocalTask(message);
                    }
                    LocalTask localTask = manager.addTask(task);
                    localTask.setUpdated(new Date());
                    ApplicationManager.getApplication().invokeLater(() -> WorkingContextManager.getInstance((Project)project).saveContext((Task)localTask), project.getDisposed());
                }
            }
        };
        if (checkinHandler == null) {
            TaskCheckinHandlerFactory.$$$reportNull$$$0(2);
        }
        return checkinHandler;
    }

    @Nullable
    private static Task findTaskInRepositories(String message, TaskManager manager) {
        TaskRepository[] repositories;
        for (TaskRepository repository : repositories = manager.getAllRepositories()) {
            String id = repository.extractId(message);
            if (id == null) continue;
            LocalTask localTask = manager.findTask(id);
            if (localTask != null) {
                return localTask;
            }
            try {
                Task task = repository.findTask(id);
                if (task == null) continue;
                return task;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/impl/TaskCheckinHandlerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/impl/TaskCheckinHandlerFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

