/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.util;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.language.EditorConfigLanguage;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.language.psi.reference.EditorConfigVirtualFileDescriptor;
import org.editorconfig.language.services.EditorConfigFileHierarchyService;
import org.editorconfig.language.services.EditorConfigServiceLoaded;
import org.editorconfig.language.services.EditorConfigServiceLoading;
import org.editorconfig.language.services.EditorConfigServiceResult;
import org.editorconfig.language.util.EditorConfigGlobUtilsKt;
import org.editorconfig.language.util.EditorConfigVfsUtil;
import org.editorconfig.language.util.core.EditorConfigPsiTreeUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0004J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0015\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0082\u0010J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tJ\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\b2\u0006\u0010\u001c\u001a\u00020\u001bJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\b2\u0006\u0010\u001c\u001a\u00020\u001bJ&\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\r2\b\u0010\n\u001a\u0004\u0018\u0001H\u001fH\u0086\b\u00a2\u0006\u0002\u0010 J\"\u0010!\u001a\u0002H\u001f\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\b\u00a2\u0006\u0002\u0010\"J6\u0010#\u001a\u00020$\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u00062\u0006\u0010\u0005\u001a\u0002H\u001f2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u00020$0&H\u0086\b\u00a2\u0006\u0002\u0010'J6\u0010(\u001a\u00020$\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u00062\u0006\u0010\u0005\u001a\u0002H\u001f2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u00020$0&H\u0086\b\u00a2\u0006\u0002\u0010'J%\u0010)\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020$0&H\u0086\bJ\u0013\u0010+\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0010J*\u0010,\u001a\u0004\u0018\u0001H\u001f\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u0006*\u00020\u00062\b\b\u0002\u0010-\u001a\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010.J\u0019\u0010/\u001a\u00020\u0004\"\n\b\u0000\u0010\u001f\u0018\u0001*\u00020\u0006*\u00020\u0006H\u0086\b\u00a8\u00060"}, d2={"Lorg/editorconfig/language/util/EditorConfigPsiTreeUtil;", "", "()V", "containsErrors", "", "element", "Lcom/intellij/psi/PsiElement;", "findAllChildrenFiles", "", "Lorg/editorconfig/language/psi/EditorConfigPsiFile;", "file", "honorRoot", "findAllParentsFiles", "Lcom/intellij/psi/PsiFile;", "findIdentifierUnderCaret", "editor", "Lcom/intellij/openapi/editor/Editor;", "findNextEditorConfigFile", "directory", "Lcom/intellij/psi/PsiDirectory;", "findOneParentFile", "findParentFilesUsingIndex", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findRemovableRange", "Lkotlin/ranges/IntRange;", "findShadowedSections", "Lorg/editorconfig/language/psi/EditorConfigSection;", "section", "findShadowingSections", "getOriginalFile", "T", "(Lcom/intellij/psi/PsiFile;)Lcom/intellij/psi/PsiFile;", "getRequiredParent", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "iterateTypedSiblingsBackward", "", "action", "Lkotlin/Function1;", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)V", "iterateTypedSiblingsForward", "iterateVisibleChildren", "acceptor", "nextVisibleSibling", "getParentOfType", "strict", "(Lcom/intellij/psi/PsiElement;Z)Lcom/intellij/psi/PsiElement;", "hasParentOfType", "intellij.editorconfig"})
public final class EditorConfigPsiTreeUtil {
    public static final EditorConfigPsiTreeUtil INSTANCE;

    private final <T extends PsiElement> T getParentOfType(@NotNull PsiElement $receiver, boolean strict) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)PsiTreeUtil.getParentOfType((PsiElement)$receiver, PsiElement.class, (boolean)strict);
    }

    static /* synthetic */ PsiElement getParentOfType$default(EditorConfigPsiTreeUtil this_, PsiElement $receiver, boolean strict, int n, Object object) {
        if ((n & 1) != 0) {
            strict = false;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return PsiTreeUtil.getParentOfType((PsiElement)$receiver, PsiElement.class, (boolean)strict);
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends PsiElement> boolean hasParentOfType(@NotNull PsiElement $receiver) {
        void $receiver$iv;
        PsiElement psiElement = $receiver;
        EditorConfigPsiTreeUtil this_$iv = this;
        boolean strict$iv = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, PsiElement.class, (boolean)strict$iv) != null;
    }

    private final <T extends PsiElement> T getRequiredParent(PsiElement element) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)element, PsiElement.class, (boolean)false);
        if (psiElement == null) {
            throw (Throwable)new IllegalStateException();
        }
        return (T)psiElement;
    }

    public final boolean containsErrors(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)element).traverse().filter(PsiErrorElement.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"SyntaxTraverser.psiTrave\u2026ErrorElement::class.java)");
        return jBIterable.isNotEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EditorConfigSection> findShadowingSections(@NotNull EditorConfigSection section) {
        void $receiver$iv$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)section, (String)"section");
        List result2 = CollectionsKt.mutableListOf((Object[])new EditorConfigSection[]{section});
        EditorConfigPsiTreeUtil this_$iv = this;
        PsiElement psiElement = ((PsiElement)section).getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element.parent");
        PsiElement[] psiElementArray = psiElement.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"element.parent.children");
        Object $receiver$iv$iv = psiElementArray;
        PsiElement[] psiElementArray2 = $receiver$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        Iterator $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
        for (void element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
            EditorConfigSection editorConfigSection;
            void element$iv$iv$iv = element$iv$iv$iv$iv;
            void it$iv = element$iv$iv$iv;
            Object v2 = it$iv;
            if (!(v2 instanceof EditorConfigSection)) {
                v2 = null;
            }
            if ((EditorConfigSection)v2 == null) continue;
            EditorConfigSection it$iv$iv$iv = editorConfigSection;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        boolean yielding$iv$iv = false;
        ArrayList list$iv$iv = new ArrayList();
        $receiver$iv$iv$iv$iv = $receiver$iv$iv.iterator();
        while ($receiver$iv$iv$iv$iv.hasNext()) {
            Object item$iv$iv = $receiver$iv$iv$iv$iv.next();
            if (yielding$iv$iv) {
                list$iv$iv.add(item$iv$iv);
                continue;
            }
            PsiElement it$iv = (PsiElement)item$iv$iv;
            if (Intrinsics.areEqual((Object)((PsiElement)section), (Object)it$iv) ^ true) continue;
            list$iv$iv.add(item$iv$iv);
            yielding$iv$iv = true;
        }
        $receiver$iv$iv = CollectionsKt.drop((Iterable)list$iv$iv, (int)1);
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            EditorConfigSection it = (EditorConfigSection)element$iv$iv;
            EditorConfigHeader editorConfigHeader = section.getHeader();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorConfigHeader, (String)"section.header");
            EditorConfigHeader editorConfigHeader2 = it.getHeader();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorConfigHeader2, (String)"it.header");
            if (!EditorConfigGlobUtilsKt.isSubcaseOf(editorConfigHeader, editorConfigHeader2)) continue;
            result2.add(it);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EditorConfigSection> findShadowedSections(@NotNull EditorConfigSection section) {
        Object item$iv$iv;
        PsiElement it$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv$iv$iv;
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)section, (String)"section");
        List result2 = CollectionsKt.mutableListOf((Object[])new EditorConfigSection[]{section});
        EditorConfigPsiTreeUtil this_$iv = this;
        PsiElement psiElement = ((PsiElement)section).getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element.parent");
        PsiElement[] psiElementArray = psiElement.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"element.parent.children");
        Object object = $receiver$iv$iv = psiElementArray;
        Object destination$iv$iv$iv = new ArrayList();
        for (void element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv) {
            EditorConfigSection editorConfigSection;
            void element$iv$iv$iv = element$iv$iv$iv$iv;
            void it$iv2 = element$iv$iv$iv;
            Object v2 = it$iv2;
            if (!(v2 instanceof EditorConfigSection)) {
                v2 = null;
            }
            if ((EditorConfigSection)v2 == null) continue;
            EditorConfigSection it$iv$iv$iv = editorConfigSection;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $receiver$iv$iv = (List)destination$iv$iv$iv;
        ArrayList list$iv$iv = new ArrayList();
        destination$iv$iv$iv = $receiver$iv$iv.iterator();
        while (destination$iv$iv$iv.hasNext() && Intrinsics.areEqual((Object)((PsiElement)section), (Object)(it$iv = (PsiElement)(item$iv$iv = destination$iv$iv$iv.next()))) ^ true) {
            list$iv$iv.add(item$iv$iv);
        }
        $receiver$iv$iv = CollectionsKt.reversed((Iterable)list$iv$iv);
        object = $receiver$iv$iv.iterator();
        while (object.hasNext()) {
            Object element$iv$iv = object.next();
            EditorConfigSection it = (EditorConfigSection)element$iv$iv;
            EditorConfigHeader editorConfigHeader = it.getHeader();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorConfigHeader, (String)"it.header");
            EditorConfigHeader editorConfigHeader2 = section.getHeader();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorConfigHeader2, (String)"section.header");
            if (!EditorConfigGlobUtilsKt.isSubcaseOf(editorConfigHeader, editorConfigHeader2)) continue;
            result2.add(it);
        }
        CollectionsKt.reverse((List)result2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends PsiElement> void iterateTypedSiblingsForward(T element, Function1<? super T, Unit> action) {
        void $receiver$iv$iv;
        PsiElement psiElement = element.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element.parent");
        PsiElement[] psiElementArray = psiElement.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"element.parent.children");
        Object $receiver$iv = psiElementArray;
        PsiElement[] psiElementArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        Iterator $receiver$iv$iv$iv = $receiver$iv$iv;
        void var8_9 = $receiver$iv$iv$iv;
        int n = ((void)var8_9).length;
        for (int i = 0; i < n; ++i) {
            PsiElement psiElement2;
            void element$iv$iv$iv;
            void element$iv$iv;
            void it = element$iv$iv = (element$iv$iv$iv = var8_9[i]);
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            if ((PsiElement)it == null) continue;
            PsiElement it$iv$iv = psiElement2;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        boolean yielding$iv = false;
        ArrayList list$iv = new ArrayList();
        $receiver$iv$iv$iv = $receiver$iv.iterator();
        while ($receiver$iv$iv$iv.hasNext()) {
            Object item$iv = $receiver$iv$iv$iv.next();
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            PsiElement it = (PsiElement)item$iv;
            if (Intrinsics.areEqual(element, (Object)it) ^ true) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        $receiver$iv = CollectionsKt.drop((Iterable)list$iv, (int)1);
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            action.invoke(element$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends PsiElement> void iterateTypedSiblingsBackward(T element, Function1<? super T, Unit> action) {
        Object item$iv;
        PsiElement it;
        void $receiver$iv$iv;
        void $receiver$iv$iv$iv;
        Object $receiver$iv;
        PsiElement psiElement = element.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element.parent");
        PsiElement[] psiElementArray = psiElement.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"element.parent.children");
        Object object = $receiver$iv = psiElementArray;
        Object destination$iv$iv = new ArrayList();
        void var8_7 = $receiver$iv$iv$iv = $receiver$iv$iv;
        int n = ((void)var8_7).length;
        for (int i = 0; i < n; ++i) {
            PsiElement psiElement2;
            void element$iv$iv$iv;
            void element$iv$iv;
            void it2 = element$iv$iv = (element$iv$iv$iv = var8_7[i]);
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            if ((PsiElement)it2 == null) continue;
            PsiElement it$iv$iv = psiElement2;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        ArrayList list$iv = new ArrayList();
        destination$iv$iv = $receiver$iv.iterator();
        while (destination$iv$iv.hasNext() && Intrinsics.areEqual(element, (Object)(it = (PsiElement)(item$iv = destination$iv$iv.next()))) ^ true) {
            list$iv.add(item$iv);
        }
        $receiver$iv = CollectionsKt.reversed((Iterable)list$iv);
        object = $receiver$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            action.invoke(element$iv);
        }
    }

    @NotNull
    public final IntRange findRemovableRange(@NotNull PsiElement element) {
        IntRange intRange;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        IntRange intRange2 = EditorConfigPsiTreeUtilCore.INSTANCE.findRemovableRangeBackward(element);
        if (intRange2 == null) {
            intRange2 = intRange = EditorConfigPsiTreeUtilCore.INSTANCE.findRemovableRangeForward(element);
        }
        if (intRange2 == null) {
            TextRange textRange = element.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.textRange");
            int n = textRange.getStartOffset();
            TextRange textRange2 = element.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"element.textRange");
            intRange = RangesKt.until((int)n, (int)textRange2.getEndOffset());
        }
        return intRange;
    }

    @NotNull
    public final List<EditorConfigPsiFile> findAllParentsFiles(@NotNull PsiFile file) {
        List<EditorConfigPsiFile> list;
        EditorConfigServiceResult serviceResult;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        EditorConfigPsiTreeUtil this_$iv = this;
        PsiFile psiFile = EditorConfigPsiTreeUtilCore.INSTANCE.getOriginalFile(file, Reflection.getOrCreateKotlinClass(PsiFile.class));
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile virtualFile = psiFile;
        if (EditorConfigRegistry.shouldStopAtProjectRoot()) {
            return this.findParentFilesUsingIndex(file, (VirtualFile)virtualFile);
        }
        Project project = file.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
        EditorConfigFileHierarchyService service = EditorConfigFileHierarchyService.Companion.getInstance(project);
        EditorConfigServiceResult editorConfigServiceResult = serviceResult = service.getParentEditorConfigFiles((VirtualFile)virtualFile);
        if (editorConfigServiceResult instanceof EditorConfigServiceLoaded) {
            list = ((EditorConfigServiceLoaded)serviceResult).getList();
        } else if (editorConfigServiceResult instanceof EditorConfigServiceLoading) {
            list = this.findParentFilesUsingIndex(file, (VirtualFile)virtualFile);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @Nullable
    public final PsiElement findIdentifierUnderCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        int n;
        int n2;
        int previousIndex;
        PsiElement previousElement;
        PsiElement psiElement;
        IElementType iElementType;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int caretOffset = caretModel.getOffset();
        FileViewProvider fileViewProvider = file.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"file.viewProvider");
        FileViewProvider viewProvider = fileViewProvider;
        PsiElement psiUnderCaret = viewProvider.findElementAt(caretOffset, (Language)EditorConfigLanguage.INSTANCE);
        PsiElement psiElement2 = psiUnderCaret;
        IElementType iElementType2 = psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : (iElementType = null);
        Object object = Intrinsics.areEqual((Object)iElementType, (Object)EditorConfigElementTypes.IDENTIFIER) ? psiUnderCaret : (iElementType == null || Intrinsics.areEqual((Object)iElementType, (Object)TokenType.WHITE_SPACE) || Intrinsics.areEqual((Object)iElementType, (Object)EditorConfigElementTypes.DOT) ? (Intrinsics.areEqual((Object)((psiElement = (previousElement = viewProvider.findElementAt(previousIndex = Math.max(n2 = 0, n = caretOffset - 1)))) != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)EditorConfigElementTypes.IDENTIFIER) ^ true ? null : previousElement) : null);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorConfigPsiFile> findParentFilesUsingIndex(PsiFile file, VirtualFile virtualFile) {
        int n;
        PsiManager manager;
        Sequence sortedParentFiles2;
        block4: {
            void $receiver$iv;
            EditorConfigVirtualFileDescriptor currentFileDescriptor = new EditorConfigVirtualFileDescriptor(virtualFile);
            Project project = file.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            Project project2 = project;
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)EditorConfigVfsUtil.INSTANCE.getEditorConfigFiles(project2)), (Function1)((Function1)new Function1<VirtualFile, Boolean>(currentFileDescriptor){

                public final boolean invoke(@NotNull VirtualFile p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return ((EditorConfigVirtualFileDescriptor)this.receiver).isChildOf(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(EditorConfigVirtualFileDescriptor.class);
                }

                public final String getName() {
                    return "isChildOf";
                }

                public final String getSignature() {
                    return "isChildOf(Lcom/intellij/openapi/vfs/VirtualFile;)Z";
                }
            }));
            EditorConfigVirtualFileDescriptor editorConfigVirtualFileDescriptor = currentFileDescriptor;
            void var8_8 = $receiver$iv;
            Comparator comparator = new Comparator<T>(editorConfigVirtualFileDescriptor){
                final /* synthetic */ EditorConfigVirtualFileDescriptor receiver$0$inlined;
                {
                    this.receiver$0$inlined = editorConfigVirtualFileDescriptor;
                }

                public final int compare(T a, T b) {
                    VirtualFile p1 = (VirtualFile)a;
                    Comparable comparable = Integer.valueOf(this.receiver$0$inlined.distanceToParent(p1));
                    p1 = (VirtualFile)b;
                    Comparable comparable2 = comparable;
                    Integer n = this.receiver$0$inlined.distanceToParent(p1);
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            sortedParentFiles2 = SequencesKt.sortedWith((Sequence)var8_8, (Comparator)comparator);
            PsiManager psiManager = PsiManager.getInstance((Project)project2);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
            manager = psiManager;
            Sequence $receiver$iv2 = sortedParentFiles2;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv2) {
                EditorConfigPsiFile psiFile;
                if (index$iv < 0) {
                    throw (Throwable)new ArithmeticException("Index overflow has happened.");
                }
                VirtualFile it = (VirtualFile)item$iv;
                PsiFile psiFile2 = manager.findFile(it);
                if (!(psiFile2 instanceof EditorConfigPsiFile)) {
                    psiFile2 = null;
                }
                EditorConfigPsiFile editorConfigPsiFile = psiFile = (EditorConfigPsiFile)psiFile2;
                boolean bl = editorConfigPsiFile != null ? editorConfigPsiFile.getHasValidRootDeclaration() : false;
                if (bl) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = -1;
        }
        int firstRoot = n;
        Sequence actualParentFiles = firstRoot < 0 ? sortedParentFiles2 : SequencesKt.take((Sequence)sortedParentFiles2, (int)(firstRoot + 1));
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)actualParentFiles, (Function1)((Function1)new Function1<VirtualFile, EditorConfigPsiFile>(manager){
            final /* synthetic */ PsiManager $manager;

            @Nullable
            public final EditorConfigPsiFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                PsiFile psiFile = this.$manager.findFile(it);
                if (!(psiFile instanceof EditorConfigPsiFile)) {
                    psiFile = null;
                }
                return (EditorConfigPsiFile)psiFile;
            }
            {
                this.$manager = psiManager;
                super(1);
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EditorConfigPsiFile> findAllChildrenFiles(@NotNull EditorConfigPsiFile file, boolean honorRoot) {
        EditorConfigPsiFile it;
        void $receiver$iv$iv;
        Map $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)file), (String)"file");
        EditorConfigPsiTreeUtil this_$iv = this;
        EditorConfigPsiFile editorConfigPsiFile = (EditorConfigPsiFile)EditorConfigPsiTreeUtilCore.INSTANCE.getOriginalFile((PsiFile)file, Reflection.getOrCreateKotlinClass(EditorConfigPsiFile.class));
        if (editorConfigPsiFile == null || (editorConfigPsiFile = editorConfigPsiFile.getVirtualFile()) == null) {
            return CollectionsKt.emptyList();
        }
        EditorConfigPsiFile virtualFile = editorConfigPsiFile;
        Project project = file.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
        Project project2 = project;
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
        PsiManager manager = psiManager;
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)EditorConfigVfsUtil.INSTANCE.getEditorConfigFiles(project2)), (Function1)((Function1)new Function1<VirtualFile, Boolean>(new EditorConfigVirtualFileDescriptor((VirtualFile)virtualFile)){

            public final boolean invoke(@NotNull VirtualFile p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((EditorConfigVirtualFileDescriptor)this.receiver).isStrictParentOf(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(EditorConfigVirtualFileDescriptor.class);
            }

            public final String getName() {
                return "isStrictParentOf";
            }

            public final String getSignature() {
                return "isStrictParentOf(Lcom/intellij/openapi/vfs/VirtualFile;)Z";
            }
        }));
        void var8_7 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            VirtualFile virtualFile2 = (VirtualFile)element$iv$iv;
            Map map = destination$iv$iv;
            PsiFile psiFile = manager.findFile((VirtualFile)it);
            if (!(psiFile instanceof EditorConfigPsiFile)) {
                psiFile = null;
            }
            EditorConfigPsiFile editorConfigPsiFile2 = (EditorConfigPsiFile)psiFile;
            map.put(editorConfigPsiFile2, element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        Map result$iv = new LinkedHashMap();
        destination$iv$iv = $receiver$iv;
        for (Map.Entry entry$iv : destination$iv$iv.entrySet()) {
            it = (EditorConfigPsiFile)((Object)entry$iv.getKey());
            if (!(it != null)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map childFiles2 = result$iv;
        if (honorRoot) {
            return CollectionsKt.filterNotNull((Iterable)childFiles2.keySet());
        }
        $receiver$iv = childFiles2;
        result$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        Iterator iterator = $receiver$iv$iv;
        Iterator iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            Map.Entry element$iv$iv;
            block12: {
                Map.Entry $$_$_virtualChildFile;
                Map.Entry $i$f$filterKeys = $$_$_virtualChildFile = (element$iv$iv = iterator2.next());
                VirtualFile virtualChildFile = (VirtualFile)$i$f$filterKeys.getValue();
                Map $receiver$iv2 = childFiles2;
                if ($receiver$iv2.isEmpty()) {
                    bl = true;
                } else {
                    Map map = $receiver$iv2;
                    Iterator iterator3 = map.entrySet().iterator();
                    while (iterator3.hasNext()) {
                        boolean bl2;
                        Map.Entry element$iv;
                        Map.Entry $otherChildFile_virtualOtherChildFile;
                        Map.Entry entry = $otherChildFile_virtualOtherChildFile = (element$iv = iterator3.next());
                        EditorConfigPsiFile otherChildFile = (EditorConfigPsiFile)((Object)entry.getKey());
                        entry = $otherChildFile_virtualOtherChildFile;
                        VirtualFile virtualOtherChildFile = (VirtualFile)entry.getValue();
                        if (!VfsUtil.isAncestor((VirtualFile)virtualOtherChildFile, (VirtualFile)virtualChildFile, (boolean)false)) {
                            bl2 = true;
                        } else {
                            EditorConfigPsiFile editorConfigPsiFile3 = otherChildFile;
                            if (editorConfigPsiFile3 == null) {
                                Intrinsics.throwNpe();
                            }
                            bl2 = !editorConfigPsiFile3.getHasValidRootDeclaration();
                        }
                        if (bl2) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.filterNotNull((Iterable)destination$iv$iv.keySet());
    }

    @NotNull
    public static /* synthetic */ List findAllChildrenFiles$default(EditorConfigPsiTreeUtil editorConfigPsiTreeUtil, EditorConfigPsiFile editorConfigPsiFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return editorConfigPsiTreeUtil.findAllChildrenFiles(editorConfigPsiFile, bl);
    }

    @Nullable
    public final EditorConfigPsiFile findOneParentFile(@NotNull EditorConfigPsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)file), (String)"file");
        if (file.getHasValidRootDeclaration()) {
            return null;
        }
        PsiDirectory psiDirectory = file.getParent();
        return this.findNextEditorConfigFile((PsiDirectory)(psiDirectory != null ? psiDirectory.getParentDirectory() : null));
    }

    private final EditorConfigPsiFile findNextEditorConfigFile(PsiDirectory directory) {
        EditorConfigPsiFile editorConfigPsiFile;
        while (true) {
            EditorConfigPsiFile result2;
            PsiFile psiFile;
            PsiFile psiFile2;
            block4: {
                PsiFile[] $receiver$iv;
                if (directory == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)directory.getFiles(), (String)"directory.files");
                for (PsiFile element$iv : $receiver$iv) {
                    PsiFile it = element$iv;
                    if (!(it instanceof EditorConfigPsiFile)) continue;
                    psiFile2 = element$iv;
                    break block4;
                }
                psiFile2 = psiFile = null;
            }
            if (!(psiFile2 instanceof EditorConfigPsiFile)) {
                psiFile = null;
            }
            editorConfigPsiFile = result2 = (EditorConfigPsiFile)psiFile;
            if (editorConfigPsiFile != null) break;
            directory = directory.getParentDirectory();
        }
        return editorConfigPsiFile;
    }

    @Nullable
    public final PsiElement findIdentifierUnderCaret(@Nullable PsiElement element) {
        FileEditorManagerImpl fileEditorManagerImpl;
        if (element == null) {
            return null;
        }
        Project project = element.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
        Project project2 = project;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
        if (!(fileEditorManager instanceof FileEditorManagerImpl)) {
            fileEditorManager = null;
        }
        if ((fileEditorManagerImpl = (FileEditorManagerImpl)fileEditorManager) == null || (fileEditorManagerImpl = fileEditorManagerImpl.getSelectedTextEditor(true)) == null) {
            return null;
        }
        FileEditorManagerImpl editor = fileEditorManagerImpl;
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        return this.findIdentifierUnderCaret((Editor)editor, file);
    }

    @Nullable
    public final PsiElement nextVisibleSibling(@NotNull PsiElement element) {
        while (true) {
            PsiElement next;
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (element.getNextSibling() == null) {
                return null;
            }
            if (!(next instanceof PsiWhiteSpace)) {
                return next;
            }
            element = next;
        }
    }

    public final void iterateVisibleChildren(@NotNull PsiElement element, @NotNull Function1<? super PsiElement, Unit> acceptor) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(acceptor, (String)"acceptor");
        PsiElement child = element.getFirstChild();
        while (child != null) {
            acceptor.invoke((Object)child);
            child = this.nextVisibleSibling(child);
        }
    }

    private final <T extends PsiFile> T getOriginalFile(T file) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return EditorConfigPsiTreeUtilCore.INSTANCE.getOriginalFile(file, Reflection.getOrCreateKotlinClass(PsiFile.class));
    }

    private EditorConfigPsiTreeUtil() {
    }

    static {
        EditorConfigPsiTreeUtil editorConfigPsiTreeUtil;
        INSTANCE = editorConfigPsiTreeUtil = new EditorConfigPsiTreeUtil();
    }
}

