/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.actions.CreateLauncherScriptAction;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CustomizeLauncherScriptStep
extends AbstractCustomizeWizardStep {
    private final JCheckBox myCreateScriptCheckBox = new JCheckBox(ActionsBundle.message((String)"action.CreateLauncherScript.description", (Object[])new Object[0]));
    private final JTextField myScriptPathTextField = new JTextField();

    public static boolean isAvailable() {
        return System.getProperty("idea.skip.launcher.script.step") == null && CreateLauncherScriptAction.isAvailable();
    }

    public CustomizeLauncherScriptStep() {
        this.setLayout(new BorderLayout());
        this.myCreateScriptCheckBox.setOpaque(false);
        this.myCreateScriptCheckBox.setSelected(false);
        this.myCreateScriptCheckBox.addChangeListener(e -> this.myScriptPathTextField.setEnabled(this.myCreateScriptCheckBox.isSelected()));
        this.myScriptPathTextField.setEnabled(false);
        this.myScriptPathTextField.setText(CreateLauncherScriptAction.defaultScriptPath());
        JPanel content = new JPanel(CustomizeLauncherScriptStep.createSmallBorderLayout());
        content.setBorder(CustomizeLauncherScriptStep.createSmallEmptyBorder());
        JPanel controls = new JPanel(new GridBagLayout());
        controls.setOpaque(false);
        GridBag gbc = new GridBag().setDefaultAnchor(17).setDefaultFill(2).setDefaultWeightX(1.0);
        controls.add((Component)this.myCreateScriptCheckBox, gbc.nextLine());
        gbc.nextLine();
        gbc.insets.top = UIUtil.PANEL_REGULAR_INSETS.top;
        gbc.insets.left = UIUtil.PANEL_REGULAR_INSETS.left;
        controls.add((Component)new JLabel("Please specify the path where the script should be created:"), gbc);
        controls.add((Component)this.myScriptPathTextField, gbc.nextLine());
        content.add((Component)controls, "North");
        this.add((Component)content, "Center");
    }

    @Override
    public boolean beforeOkAction() {
        if (this.myCreateScriptCheckBox.isSelected()) {
            try {
                CreateLauncherScriptAction.createLauncherScript(this.myScriptPathTextField.getText());
            }
            catch (Exception e) {
                Messages.showErrorDialog((String)ExceptionUtil.getNonEmptyMessage((Throwable)e, (String)"Internal error"), (String)"Launcher Script Creation Failed");
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getTitle() {
        return "Launcher Script";
    }

    @Override
    protected String getHTMLHeader() {
        return "<html><body><h2>Create Launcher Script</h2></body></html>";
    }

    @Override
    protected String getHTMLFooter() {
        return "Launcher script can be created later via Tools | Create Command-Line Launcher...";
    }
}

