/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.execution.Executor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.runAnything.RunAnythingManager;
import com.intellij.ide.actions.runAnything.RunAnythingRunConfigurationProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingCommandExecutionProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingRecentCommandProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingRecentProjectProvider;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.FontUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RunAnythingAction
extends AnAction
implements CustomComponentAction,
DumbAware {
    public static final String RUN_ANYTHING_ACTION_ID = "RunAnything";
    public static final DataKey<Executor> EXECUTOR_KEY = DataKey.create((String)"EXECUTOR_KEY");
    public static final AtomicBoolean SHIFT_IS_PRESSED = new AtomicBoolean(false);
    public static final AtomicBoolean ALT_IS_PRESSED = new AtomicBoolean(false);
    static final String RUN_ANYTHING = "RunAnything";
    private boolean myIsDoubleCtrlRegistered;
    private static final NotNullLazyValue<Boolean> IS_ACTION_ENABLED = new NotNullLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            Boolean bl = Arrays.stream(RunAnythingProvider.EP_NAME.getExtensions()).anyMatch(provider -> !(provider instanceof RunAnythingRunConfigurationProvider) && !(provider instanceof RunAnythingRecentProjectProvider) && !(provider instanceof RunAnythingRecentCommandProvider) && !(provider instanceof RunAnythingCommandExecutionProvider));
            if (bl == null) {
                1.$$$reportNull$$$0(0);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/runAnything/RunAnythingAction$1", "compute"));
        }
    };

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunAnythingAction.$$$reportNull$$$0(0);
        }
        if (Registry.is((String)"ide.suppress.double.click.handler") && e.getInputEvent() instanceof KeyEvent && ((KeyEvent)e.getInputEvent()).getKeyCode() == 17) {
            return;
        }
        if (e.getProject() != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("RunAnything");
            RunAnythingManager runAnythingManager = RunAnythingManager.getInstance(e.getProject());
            IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
            String text = GotoActionBase.getInitialTextForNavigation((Editor)e.getData(CommonDataKeys.EDITOR));
            runAnythingManager.show(text, e);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunAnythingAction.$$$reportNull$$$0(1);
        }
        if (KeymapUtil.getActiveKeymapShortcuts((String)"RunAnything").getShortcuts().length == 0) {
            if (!this.myIsDoubleCtrlRegistered) {
                ModifierKeyDoubleClickHandler.getInstance().registerAction("RunAnything", 17, -1, false);
                this.myIsDoubleCtrlRegistered = true;
            }
        } else if (this.myIsDoubleCtrlRegistered) {
            ModifierKeyDoubleClickHandler.getInstance().unregisterAction("RunAnything");
            this.myIsDoubleCtrlRegistered = false;
        }
        boolean isEnabled = (Boolean)IS_ACTION_ENABLED.getValue();
        e.getPresentation().setVisible(isEnabled);
        e.getPresentation().setEnabled(isEnabled);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation) {
        if (presentation == null) {
            RunAnythingAction.$$$reportNull$$$0(2);
        }
        ActionButton actionButton = new ActionButton(this, presentation, "NavBarToolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            @Override
            protected void updateToolTipText() {
                if (Registry.is((String)"ide.helptooltip.enabled")) {
                    HelpTooltip.dispose((Component)this);
                    new HelpTooltip().setTitle(this.myPresentation.getText()).setShortcut(RunAnythingAction.this.getShortcut()).setDescription(RunAnythingAction.this.getShortcutText()).setLocation(this.getTooltipLocation()).installOn((JComponent)this);
                } else {
                    this.setToolTipText(RunAnythingAction.this.getShortcutText());
                }
            }
        };
        if (actionButton == null) {
            RunAnythingAction.$$$reportNull$$$0(3);
        }
        return actionButton;
    }

    @NotNull
    private String getShortcutText() {
        String string = IdeBundle.message((String)"run.anything.action.tooltip.text", (Object[])new Object[0]) + this.getShortcut();
        if (string == null) {
            RunAnythingAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private String getShortcut() {
        if (this.myIsDoubleCtrlRegistered) {
            String string = " " + IdeBundle.message((String)"run.anything.double.ctrl.shortcut", (Object[])new Object[]{SystemInfo.isMac ? FontUtil.thinSpace() + "\u2303" : " Ctrl"});
            if (string == null) {
                RunAnythingAction.$$$reportNull$$$0(5);
            }
            return string;
        }
        if ("" == null) {
            RunAnythingAction.$$$reportNull$$$0(6);
        }
        return "";
    }

    static {
        IdeEventQueue.getInstance().addPostprocessor(event -> {
            if (event instanceof KeyEvent) {
                int keyCode = ((KeyEvent)event).getKeyCode();
                if (keyCode == 16) {
                    SHIFT_IS_PRESSED.set(event.getID() == 401);
                } else if (keyCode == 18) {
                    ALT_IS_PRESSED.set(event.getID() == 401);
                }
            }
            return false;
        }, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/runAnything/RunAnythingAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/runAnything/RunAnythingAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

