/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.Gray;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.Consumer;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.breadcrumbs.BreadcrumbsComponent;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import com.intellij.xml.breadcrumbs.PsiBreadcrumbs;
import com.intellij.xml.breadcrumbs.PsiCrumb;
import com.intellij.xml.breadcrumbs.PsiFileBreadcrumbsCollector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreadcrumbsXmlWrapper
extends JComponent
implements Disposable {
    final PsiBreadcrumbs breadcrumbs;
    private final Project myProject;
    private Editor myEditor;
    private Collection<RangeHighlighter> myHighlighed;
    private final VirtualFile myFile;
    private boolean myUserCaretChange;
    private final MergingUpdateQueue myQueue;
    private final Update myUpdate;
    private ProgressIndicator myAsyncUpdateProgress;
    private final FileBreadcrumbsCollector myBreadcrumbsCollector;
    public static final Key<BreadcrumbsXmlWrapper> BREADCRUMBS_COMPONENT_KEY = new Key("BREADCRUMBS_KEY");

    public BreadcrumbsXmlWrapper(@NotNull Editor editor) {
        if (editor == null) {
            BreadcrumbsXmlWrapper.$$$reportNull$$$0(0);
        }
        this.breadcrumbs = new PsiBreadcrumbs();
        this.myUserCaretChange = true;
        this.myQueue = new MergingUpdateQueue("Breadcrumbs.Queue", 200, true, (JComponent)((Object)this.breadcrumbs));
        this.myUpdate = new Update(this){

            public void run() {
                BreadcrumbsXmlWrapper.this.updateCrumbs();
            }

            public boolean canEat(Update update) {
                return true;
            }
        };
        this.myAsyncUpdateProgress = null;
        this.myEditor = editor;
        this.myEditor.putUserData(BREADCRUMBS_COMPONENT_KEY, (Object)this);
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).addPropertyChangeListener(this::updateEditorFont, this);
        }
        Project project = editor.getProject();
        assert (project != null);
        this.myProject = project;
        this.myFile = FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
        FileStatusManager manager = FileStatusManager.getInstance((Project)project);
        manager.addFileStatusListener(new FileStatusListener(){

            public void fileStatusesChanged() {
                BreadcrumbsXmlWrapper.this.queueUpdate();
            }
        }, (Disposable)this);
        CaretListener caretListener = new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (BreadcrumbsXmlWrapper.this.myUserCaretChange) {
                    BreadcrumbsXmlWrapper.this.queueUpdate();
                }
                BreadcrumbsXmlWrapper.this.myUserCaretChange = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$3", "caretPositionChanged"));
            }
        };
        editor.getCaretModel().addCaretListener(caretListener, (Disposable)this);
        this.myBreadcrumbsCollector = this.findBreadcrumbsCollector();
        if (this.myFile != null) {
            this.myBreadcrumbsCollector.watchForChanges(this.myFile, this, () -> this.queueUpdate());
        }
        this.breadcrumbs.onHover(this::itemHovered);
        this.breadcrumbs.onSelect(this::itemSelected);
        this.breadcrumbs.setFont(BreadcrumbsXmlWrapper.getNewFont(this.myEditor));
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)((Object)this.breadcrumbs), (boolean)true);
        pane.setVerticalScrollBarPolicy(21);
        pane.getHorizontalScrollBar().setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add("Center", pane);
        EditorGutter gutter = editor.getGutter();
        if (gutter instanceof EditorGutterComponentEx) {
            final EditorGutterComponentEx gutterComponent = (EditorGutterComponentEx)gutter;
            MouseEventAdapter<EditorGutterComponentEx> mouseListener = new MouseEventAdapter<EditorGutterComponentEx>(gutterComponent){

                @NotNull
                protected MouseEvent convert(@NotNull MouseEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    MouseEvent mouseEvent = 4.convert((MouseEvent)event, (Component)gutterComponent);
                    if (mouseEvent == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return mouseEvent;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$4";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$4";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "convert";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "convert";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            ComponentAdapter resizeListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent event) {
                    BreadcrumbsXmlWrapper.this.breadcrumbs.updateBorder(gutterComponent.getWhitespaceSeparatorOffset());
                    BreadcrumbsXmlWrapper.this.breadcrumbs.setFont(BreadcrumbsXmlWrapper.getNewFont(BreadcrumbsXmlWrapper.this.myEditor));
                }
            };
            this.addComponentListener(resizeListener);
            gutterComponent.addComponentListener(resizeListener);
            this.breadcrumbs.addMouseListener((MouseListener)mouseListener);
            Disposer.register((Disposable)this, () -> this.lambda$new$1(resizeListener, gutterComponent, (MouseEventAdapter)mouseListener));
            this.breadcrumbs.updateBorder(gutterComponent.getWhitespaceSeparatorOffset());
        } else {
            this.breadcrumbs.updateBorder(0);
        }
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)((Object)this.breadcrumbs), (Activatable)this.myQueue));
        Disposer.register((Disposable)this, (Disposable)this.myQueue);
        this.queueUpdate();
    }

    private FileBreadcrumbsCollector findBreadcrumbsCollector() {
        if (this.myFile != null) {
            for (FileBreadcrumbsCollector extension : (FileBreadcrumbsCollector[])FileBreadcrumbsCollector.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
                if (!extension.handlesFile(this.myFile)) continue;
                return extension;
            }
        }
        return new PsiFileBreadcrumbsCollector(this.myProject);
    }

    private void updateCrumbs() {
        if (this.myEditor == null || this.myFile == null || this.myEditor.isDisposed()) {
            return;
        }
        if (this.myAsyncUpdateProgress != null) {
            this.myAsyncUpdateProgress.cancel();
        }
        ProgressIndicatorBase progress = new ProgressIndicatorBase();
        this.myAsyncUpdateProgress = progress;
        this.myBreadcrumbsCollector.updateCrumbs(this.myFile, this.myEditor, this.myAsyncUpdateProgress, (Consumer<Iterable<Crumb>>)((Consumer)crumbs -> {
            if (!(progress.isCanceled() || this.myEditor == null || this.myEditor.isDisposed() || this.myProject.isDisposed())) {
                this.breadcrumbs.setFont(BreadcrumbsXmlWrapper.getNewFont(this.myEditor));
                if (!this.breadcrumbs.isShowing()) {
                    this.breadcrumbs.setCrumbs(null);
                    return;
                }
                this.breadcrumbs.setCrumbs((Iterable)crumbs);
            }
        }));
    }

    public void queueUpdate() {
        this.myQueue.cancelAllUpdates();
        this.myQueue.queue(this.myUpdate);
    }

    @Deprecated
    public JComponent getComponent() {
        return this;
    }

    private void itemSelected(Crumb crumb, InputEvent event) {
        if (event == null || !(crumb instanceof NavigatableCrumb)) {
            return;
        }
        NavigatableCrumb navigatableCrumb = (NavigatableCrumb)crumb;
        this.myUserCaretChange = false;
        navigatableCrumb.navigate(this.myEditor, event.isShiftDown() || event.isMetaDown());
    }

    private void itemHovered(Crumb crumb, InputEvent event) {
        if (!Registry.is((String)"editor.breadcrumbs.highlight.on.hover")) {
            return;
        }
        HighlightManager hm = HighlightManager.getInstance((Project)this.myProject);
        if (this.myHighlighed != null) {
            for (RangeHighlighter highlighter : this.myHighlighed) {
                hm.removeSegmentHighlighter(this.myEditor, highlighter);
            }
            this.myHighlighed = null;
        }
        if (crumb instanceof NavigatableCrumb) {
            Color background;
            Color color;
            TextRange range2 = ((NavigatableCrumb)crumb).getHighlightRange();
            if (range2 == null) {
                return;
            }
            TextAttributes attributes = new TextAttributes();
            CrumbPresentation p = PsiCrumb.getPresentation(crumb);
            Color color2 = color = p == null ? null : p.getBackgroundColor(false, false, false);
            if (color == null) {
                color = BreadcrumbsComponent.ButtonSettings.getBackgroundColor((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
            if (color == null) {
                color = UIUtil.getLabelBackground();
            }
            attributes.setBackgroundColor(XmlTagTreeHighlightingUtil.makeTransparent(color, (background = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.CARET_ROW_COLOR)) != null ? background : Gray._200, 0.3));
            this.myHighlighed = new ArrayList<RangeHighlighter>(1);
            int flags = 7;
            hm.addOccurrenceHighlight(this.myEditor, range2.getStartOffset(), range2.getEndOffset(), attributes, flags, this.myHighlighed, null);
        }
    }

    @Nullable
    public static BreadcrumbsXmlWrapper getBreadcrumbsComponent(@NotNull Editor editor) {
        if (editor == null) {
            BreadcrumbsXmlWrapper.$$$reportNull$$$0(1);
        }
        return (BreadcrumbsXmlWrapper)editor.getUserData(BREADCRUMBS_COMPONENT_KEY);
    }

    public void dispose() {
        if (this.myEditor != null) {
            this.myEditor.putUserData(BREADCRUMBS_COMPONENT_KEY, null);
        }
        this.myEditor = null;
        this.breadcrumbs.setCrumbs(null);
    }

    private void updateEditorFont(PropertyChangeEvent event) {
        if ("fontSize".equals(event.getPropertyName())) {
            this.queueUpdate();
        }
    }

    private static Font getNewFont(Editor editor) {
        Font font = editor == null || Registry.is((String)"editor.breadcrumbs.system.font") ? UIUtil.getLabelFont() : BreadcrumbsXmlWrapper.getEditorFont(editor);
        return UISettings.getInstance().getUseSmallLabelsOnTabs() ? RelativeFont.SMALL.derive(font) : font;
    }

    private static Font getEditorFont(Editor editor) {
        return ComplementaryFontsRegistry.getFontAbleToDisplay(97, 0, editor.getColorsScheme().getFontPreferences(), null).getFont();
    }

    private /* synthetic */ void lambda$new$1(ComponentAdapter resizeListener, EditorGutterComponentEx gutterComponent, MouseEventAdapter mouseListener) {
        this.removeComponentListener(resizeListener);
        gutterComponent.removeComponentListener(resizeListener);
        this.breadcrumbs.removeMouseListener((MouseListener)mouseListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBreadcrumbsComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

