/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.run;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.PyCommonOptionsFormFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.run.IpnbRunConfiguration;

public class IpnbConfigurationEditor
extends SettingsEditor<IpnbRunConfiguration>
implements PanelWithAnchor {
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final String DEFAULT_PORT = "8888";
    private JPanel myPanel;
    private JTextField myAdditionalOptionsTextField;
    private JPanel myCommonOptionsFormPlaceholder;
    private JBLabel myAdditionalOptionsLabel;
    private JTextField myHostTextField;
    private JTextField myPortTextField;
    private final AbstractPyCommonOptionsForm myCommonOptionsForm;
    private JComponent myAnchor;

    public IpnbConfigurationEditor(IpnbRunConfiguration configuration) {
        this.$$$setupUI$$$();
        this.myCommonOptionsForm = PyCommonOptionsFormFactory.getInstance().createForm(configuration.getCommonOptionsFormData());
        this.myCommonOptionsFormPlaceholder.add((Component)this.myCommonOptionsForm.getMainPanel(), "Center");
        String title = "Select Configuration File:";
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
        fileChooserDescriptor.setTitle("Select Configuration File:");
    }

    protected void resetEditorFrom(@NotNull IpnbRunConfiguration s) {
        if (s == null) {
            IpnbConfigurationEditor.$$$reportNull$$$0(0);
        }
        AbstractPythonRunConfiguration.copyParams((AbstractPythonRunConfigurationParams)s, (AbstractPythonRunConfigurationParams)this.myCommonOptionsForm);
        this.setHost(s.getHost());
        this.setPort(s.getPort());
        this.myAdditionalOptionsTextField.setText(s.getAdditionalOptions());
    }

    protected void applyEditorTo(@NotNull IpnbRunConfiguration s) throws ConfigurationException {
        if (s == null) {
            IpnbConfigurationEditor.$$$reportNull$$$0(1);
        }
        AbstractPythonRunConfiguration.copyParams((AbstractPythonRunConfigurationParams)this.myCommonOptionsForm, (AbstractPythonRunConfigurationParams)s);
        s.setHost(this.getHost());
        s.setPort(this.getPort());
        s.setAdditionalOptions(this.myAdditionalOptionsTextField.getText());
    }

    @Nullable
    public String getHost() {
        return this.myHostTextField.getText();
    }

    @Nullable
    public String getPort() {
        return this.myPortTextField.getText();
    }

    public void setHost(String host) {
        this.myHostTextField.setText(StringUtil.isEmptyOrSpaces((String)host) ? DEFAULT_HOST : host);
    }

    public void setPort(String port) {
        this.myPortTextField.setText(StringUtil.isEmptyOrSpaces((String)port) ? DEFAULT_PORT : port);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            IpnbConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myCommonOptionsForm.setAnchor(anchor);
        this.myAdditionalOptionsLabel.setAnchor(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/run/IpnbConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/run/IpnbConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        JTextField jTextField3;
        JBLabel jBLabel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAdditionalOptionsLabel = jBLabel = new JBLabel();
        jBLabel.setText("Additional options:");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdditionalOptionsTextField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(1, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCommonOptionsFormPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Host:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostTextField = jTextField2 = new JTextField();
        jTextField2.setColumns(20);
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Port:");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortTextField = jTextField = new JTextField();
        jTextField.setHorizontalAlignment(4);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 3, 1, 1, 4, 0, 0, 0, null, new Dimension(70, -1), new Dimension(70, -1)));
        jBLabel.setLabelFor(jTextField3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

