/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.format.cells.output;

import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCell;

public class IpnbOutputCell
implements IpnbCell {
    @Nullable
    protected final Integer myPromptNumber;
    @Nullable
    private final List<String> myText;
    @Nullable
    private final Map<String, Object> myMetadata;

    public IpnbOutputCell(@Nullable List<String> text, @Nullable Integer promptNumber, @Nullable Map<String, Object> metadata) {
        this.myText = text;
        this.myPromptNumber = promptNumber;
        this.myMetadata = metadata;
    }

    @Nullable
    public List<String> getText() {
        return this.myText;
    }

    @Nullable
    public String getSourceAsString() {
        return this.myText == null ? null : StringUtil.join(this.myText, (String)"\n");
    }

    @Nullable
    public Integer getPromptNumber() {
        return this.myPromptNumber;
    }

    @Nullable
    public Map<String, Object> getMetadata() {
        return this.myMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpnbOutputCell cell = (IpnbOutputCell)o;
        if (this.myPromptNumber != null ? !this.myPromptNumber.equals(cell.myPromptNumber) : cell.myPromptNumber != null) {
            return false;
        }
        if (this.myText != null ? !this.myText.equals(cell.myText) : cell.myText != null) {
            return false;
        }
        return !(this.myMetadata != null ? !this.myMetadata.equals(cell.myMetadata) : cell.myMetadata != null);
    }

    public int hashCode() {
        int result = this.myPromptNumber != null ? this.myPromptNumber.hashCode() : 0;
        result = 31 * result + (this.myText != null ? this.myText.hashCode() : 0);
        result = 31 * result + (this.myMetadata != null ? this.myMetadata.hashCode() : 0);
        return result;
    }
}

