/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbMergeCellAboveAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbMergeCellBelowAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbSplitCellAction;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbPanel;
import org.jetbrains.plugins.ipnb.format.cells.IpnbEditableCell;

public abstract class IpnbEditablePanel<T extends JComponent, K extends IpnbEditableCell>
extends IpnbPanel<T, K> {
    private static final Logger LOG = Logger.getInstance(IpnbEditablePanel.class);
    private boolean myEditing;
    protected JTextArea myEditableTextArea;
    public static final String EDITABLE_PANEL = "Editable panel";
    public static final String VIEW_PANEL = "View panel";
    protected OnePixelSplitter mySplitter;
    protected JPanel myViewPrompt;
    private JPanel myEditablePrompt;
    protected JLabel myPromptLabel;
    protected Runnable myOnFinish;

    public IpnbEditablePanel(@NotNull K cell) {
        if (cell == null) {
            IpnbEditablePanel.$$$reportNull$$$0(0);
        }
        super(cell);
    }

    public IpnbEditablePanel(@NotNull K cell, @NotNull LayoutManager layoutManager) {
        if (cell == null) {
            IpnbEditablePanel.$$$reportNull$$$0(1);
        }
        if (layoutManager == null) {
            IpnbEditablePanel.$$$reportNull$$$0(2);
        }
        super(cell, layoutManager);
    }

    protected void initPanel() {
        this.mySplitter = new OnePixelSplitter(true);
        this.addViewPanel();
        this.addEditablePanel();
        this.mySplitter.setFirstComponent((JComponent)this.myViewPrompt);
        this.mySplitter.setSecondComponent(null);
        this.setBackground(IpnbEditorUtil.getBackground());
        this.add((Component)this.mySplitter);
        this.setBorder(BorderFactory.createLineBorder(IpnbEditorUtil.getBackground()));
        this.addRightClickMenu();
    }

    private void addEditablePanel() {
        this.myEditableTextArea = this.createEditablePanel();
        this.myEditablePrompt = new JPanel(new GridBagLayout());
        this.myEditablePrompt.setName(EDITABLE_PANEL);
        this.myEditablePrompt.setBackground(IpnbEditorUtil.getBackground());
        this.addPromptPanel(this.myEditablePrompt, null, IpnbEditorUtil.PromptType.None, this.myEditableTextArea);
    }

    private void addViewPanel() {
        this.myViewPanel = this.createViewPanel();
        this.myViewPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Container parent = IpnbEditablePanel.this.getParent();
                MouseEvent parentEvent = SwingUtilities.convertMouseEvent(IpnbEditablePanel.this.myViewPanel, e, parent);
                parent.dispatchEvent(parentEvent);
                if (e.getClickCount() == 2) {
                    IpnbEditablePanel.this.switchToEditing();
                }
            }
        });
        this.myViewPanel.setName(VIEW_PANEL);
        this.myViewPrompt = new JPanel(new GridBagLayout());
        this.addPromptPanel(this.myViewPrompt, null, IpnbEditorUtil.PromptType.None, this.myViewPanel);
        this.myViewPrompt.setBackground(IpnbEditorUtil.getBackground());
    }

    public void addPromptPanel(@NotNull JComponent parent, Integer promptNumber, @NotNull IpnbEditorUtil.PromptType promptType, @NotNull JComponent component) {
        if (parent == null) {
            IpnbEditablePanel.$$$reportNull$$$0(3);
        }
        if (promptType == null) {
            IpnbEditablePanel.$$$reportNull$$$0(4);
        }
        if (component == null) {
            IpnbEditablePanel.$$$reportNull$$$0(5);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.anchor = 18;
        JLabel promptComponent = IpnbEditorUtil.createPromptComponent(promptNumber, promptType);
        if (promptType == IpnbEditorUtil.PromptType.In) {
            this.myPromptLabel = promptComponent;
        }
        c.insets = JBUI.insets((int)2, (int)2, (int)2, (int)5);
        parent.add((Component)promptComponent, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets = JBUI.insets((int)2);
        c.anchor = 10;
        parent.add((Component)component, c);
    }

    public void switchToEditing() {
        this.setEditing(true);
        this.mySplitter.setFirstComponent((JComponent)this.myEditablePrompt);
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditableTextArea, true);
        this.mySplitter.setSecondComponent(null);
    }

    public boolean isModified() {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            String name = component.getName();
            if (!component.isVisible() || !EDITABLE_PANEL.equals(name)) continue;
            return true;
        }
        return false;
    }

    protected String getRawCellText() {
        return "";
    }

    public void onFinishExecutionAction(Runnable onFinish) {
        this.myOnFinish = onFinish;
    }

    public void runCell(boolean selectNext) {
        if (this.mySplitter != null) {
            this.updateCellSource();
            this.updateCellView();
            this.mySplitter.setFirstComponent((JComponent)this.myViewPrompt);
            this.mySplitter.setSecondComponent(null);
            this.setEditing(false);
            Container parent = this.getParent();
            if (parent instanceof IpnbFilePanel) {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)parent, true);
                if (selectNext) {
                    ((IpnbFilePanel)parent).selectNext(this, true);
                }
            }
            if (this.myOnFinish != null) {
                this.myOnFinish.run();
                this.myOnFinish = null;
            }
        }
    }

    private JTextArea createEditablePanel() {
        final JTextArea textArea = new JTextArea(this.getRawCellText());
        textArea.setLineWrap(true);
        textArea.setEditable(true);
        textArea.setBorder(BorderFactory.createLineBorder((Color)JBColor.lightGray));
        textArea.setBackground(IpnbEditorUtil.getEditablePanelBackground());
        textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    IpnbEditablePanel.this.setEditing(true);
                    Container parent = IpnbEditablePanel.this.getParent();
                    if (parent instanceof IpnbFilePanel) {
                        ((IpnbFilePanel)parent).setSelectedCellPanel(IpnbEditablePanel.this);
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)textArea, true));
                    }
                }
            }
        });
        textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    IpnbEditablePanel.this.setEditing(false);
                    Container parent = IpnbEditablePanel.this.getParent();
                    if (parent instanceof IpnbFilePanel) {
                        IdeFocusManager.getGlobalInstance().requestFocus((Component)parent, true);
                    }
                }
            }
        });
        return textArea;
    }

    public boolean contains(int y) {
        return y >= this.getTop() && y <= this.getBottom();
    }

    public int getTop() {
        return this.getY();
    }

    public int getBottom() {
        return this.getTop() + this.getHeight();
    }

    public boolean isEditing() {
        return this.myEditing;
    }

    public void setEditing(boolean editing) {
        ((IpnbFilePanel.EditingModeChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(IpnbFilePanel.TOPIC)).modeChanged(this.myEditing, editing);
        this.myEditing = editing;
        this.setBorder(BorderFactory.createLineBorder((Color)(editing ? JBColor.GREEN : JBColor.GRAY)));
    }

    public void updateCellView() {
    }

    public int getCaretPosition() {
        return this.myEditing && this.myEditableTextArea != null ? this.myEditableTextArea.getCaretPosition() : -1;
    }

    @Override
    protected void addRightClickMenu() {
        this.myViewPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
                    DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{new IpnbMergeCellAboveAction(), new IpnbMergeCellBelowAction()});
                    ListPopup menu = IpnbEditablePanel.this.createPopupMenu(group);
                    menu.show(RelativePoint.fromScreen((Point)e.getLocationOnScreen()));
                }
            }
        });
        this.myEditableTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
                    DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{new IpnbSplitCellAction()});
                    ListPopup menu = IpnbEditablePanel.this.createPopupMenu(group);
                    menu.show(RelativePoint.fromScreen((Point)e.getLocationOnScreen()));
                }
            }
        });
    }

    @Nullable
    public String getText(int from, int to) {
        if (this.myEditing && this.myEditableTextArea != null) {
            try {
                return this.myEditableTextArea.getDocument().getText(from, to - from);
            }
            catch (BadLocationException e) {
                LOG.warn(e.getMessage());
            }
        }
        return null;
    }

    public String getText(int from) {
        if (this.myEditing && this.myEditableTextArea != null) {
            Document document = this.myEditableTextArea.getDocument();
            int to = document.getLength();
            return this.getText(from, to);
        }
        return null;
    }

    public void updateCellSource() {
        String text = this.myEditableTextArea.getText();
        if (StringUtil.isEmpty((String)text) && ((IpnbEditableCell)this.myCell).getSource().isEmpty()) {
            return;
        }
        ((IpnbEditableCell)this.myCell).setSource(Arrays.asList(StringUtil.splitByLinesKeepSeparators((String)(text != null ? text : ""))));
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    public K getCell() {
        return (K)((IpnbEditableCell)this.myCell);
    }

    public JTextArea getEditableTextArea() {
        return this.myEditableTextArea;
    }

    public void dispose() {
        this.removeAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promptType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/panels/IpnbEditablePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addPromptPanel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

