/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.session;

import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.Environment;
import java.awt.Component;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

public class FileHelper {
    public static final String DEFAULT_FILE_EXTENSION = "pod";
    public static final int PROJECTLIBRE_FILE_TYPE = 1;
    public static final int MSP_FILE_TYPE = 101;
    private JFileChooser fileChooser = null;

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
        }
        return this.fileChooser;
    }

    public synchronized String chooseFileName(final boolean bl, String string, Component component) {
        Object object;
        if (!Environment.getStandAlone() && bl && string != null && string.endsWith(".pod")) {
            string = FileHelper.changeFileExtension(string, bl ? "xml" : "mpp");
        }
        JFileChooser jFileChooser = this.getFileChooser();
        jFileChooser.setDialogType(bl ? 1 : 0);
        jFileChooser.resetChoosableFileFilters();
        if (string == null) {
            try {
                object = Preferences.userNodeForPackage(FileHelper.class).get("lastDirectory", System.getProperty("user.home") + File.separator + "ProjectLibre");
                jFileChooser.setCurrentDirectory(new File((String)object));
            }
            catch (Exception exception) {}
        } else {
            jFileChooser.setSelectedFile(new File(string));
        }
        object = new FileView(){

            @Override
            public Icon getIcon(File file) {
                String string = FileHelper.getFileExtension(file.getName());
                if (string != null && FileHelper.DEFAULT_FILE_EXTENSION.equals(string)) {
                    return FileHelper.getIcon("format.projectlibre");
                }
                return null;
            }
        };
        jFileChooser.setFileView((FileView)object);
        final FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".pod");
            }

            @Override
            public String getDescription() {
                return Messages.getString("File.projectlibre") + " (*." + FileHelper.DEFAULT_FILE_EXTENSION + ")";
            }
        };
        final FileFilter fileFilter2 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string = file.getName().toLowerCase();
                boolean bl2 = bl ? false : string.endsWith(".mpp") || string.endsWith(".mpx");
                return file.isDirectory() || bl2;
            }

            @Override
            public String getDescription() {
                return Messages.getString("File.microsoft") + " (*.mpp, *.mpx)";
            }
        };
        final FileFilter fileFilter3 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string = file.getName().toLowerCase();
                boolean bl2 = bl ? string.endsWith(".xml") : string.endsWith(".xml");
                return file.isDirectory() || bl2;
            }

            @Override
            public String getDescription() {
                return Messages.getString("File.microsoftXML") + " (*.xml)";
            }
        };
        final FileFilter fileFilter4 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string = file.getName().toLowerCase();
                boolean bl2 = bl ? false : string.endsWith("*.planner");
                return file.isDirectory() || bl2;
            }

            @Override
            public String getDescription() {
                return Messages.getString("File.planner") + " (*.planner)";
            }
        };
        FileFilter fileFilter5 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (fileFilter.accept(file)) {
                    return true;
                }
                if (fileFilter3.accept(file)) {
                    return true;
                }
                if (fileFilter4.accept(file)) {
                    return true;
                }
                return fileFilter2.accept(file);
            }

            @Override
            public String getDescription() {
                return Messages.getString("File.projects");
            }
        };
        if (bl) {
            if (fileFilter2.accept(jFileChooser.getSelectedFile())) {
                if (Environment.getStandAlone()) {
                    jFileChooser.addChoosableFileFilter(fileFilter);
                }
                jFileChooser.addChoosableFileFilter(fileFilter3);
            } else {
                jFileChooser.addChoosableFileFilter(fileFilter3);
                if (Environment.getStandAlone()) {
                    jFileChooser.addChoosableFileFilter(fileFilter);
                }
            }
        } else {
            jFileChooser.addChoosableFileFilter(fileFilter);
            jFileChooser.addChoosableFileFilter(fileFilter2);
            jFileChooser.addChoosableFileFilter(fileFilter3);
            jFileChooser.addChoosableFileFilter(fileFilter4);
            jFileChooser.addChoosableFileFilter(fileFilter5);
        }
        if (jFileChooser.showDialog(component, null) != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        String string2 = file.toString();
        FileFilter fileFilter6 = jFileChooser.getFileFilter();
        if (bl) {
            if (fileFilter6 == fileFilter3) {
                if (!string2.endsWith(".xml")) {
                    string2 = string2 + ".xml";
                }
            } else if (!string2.endsWith(".pod")) {
                string2 = string2 + ".pod";
            }
        }
        Preferences.userNodeForPackage(FileHelper.class).put("lastDirectory", file.getParent());
        return string2;
    }

    public static boolean isFileNameAllowed(String string, boolean bl) {
        String string2 = string.toLowerCase();
        if (bl) {
            return string2.endsWith(".xml") || string2.endsWith(".pod");
        }
        return string2.endsWith(".xml") || string2.endsWith(".mpp") || string2.endsWith(".mpx") || string2.endsWith(".planner") || string2.endsWith(".pod") || string2.endsWith(".mpx");
    }

    public static String getFileExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public static String changeFileExtension(String string, int n) {
        return FileHelper.changeFileExtension(string, FileHelper.getFileExtension(n));
    }

    public static String changeFileExtension(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n <= 0) {
            return string + "." + string2;
        }
        return string.substring(0, n) + "." + string2;
    }

    public static Icon getIcon(String string) {
        try {
            return (Icon)Class.forName("com.projectlibre1.pm.graphic.IconManager").getMethod("getIcon", String.class).invoke(null, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getFileExtension(int n) {
        switch (n) {
            case 1: {
                return DEFAULT_FILE_EXTENSION;
            }
            case 101: {
                return "xml";
            }
        }
        return DEFAULT_FILE_EXTENSION;
    }

    public static int getFileType(String string) {
        if (string == null) {
            return 0;
        }
        if ((string = string.toLowerCase()).endsWith(DEFAULT_FILE_EXTENSION)) {
            return 1;
        }
        if (string.endsWith("mpp") || string.endsWith("mpx") || string.endsWith("xml") || string.endsWith("planner")) {
            return 101;
        }
        return 0;
    }
}

