/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.Netshot;
import onl.netfishers.netshot.collector.SnmpTrapReceiver;
import onl.netfishers.netshot.collector.SyslogServer;
import onl.netfishers.netshot.device.Config;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDataProvider;
import onl.netfishers.netshot.device.Module;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.Network6Address;
import onl.netfishers.netshot.device.NetworkAddress;
import onl.netfishers.netshot.device.NetworkInterface;
import onl.netfishers.netshot.device.PhysicalAddress;
import onl.netfishers.netshot.device.access.Cli;
import onl.netfishers.netshot.device.attribute.ConfigAttribute;
import onl.netfishers.netshot.device.attribute.ConfigBinaryAttribute;
import onl.netfishers.netshot.device.attribute.ConfigLongTextAttribute;
import onl.netfishers.netshot.device.attribute.ConfigNumericAttribute;
import onl.netfishers.netshot.device.attribute.ConfigTextAttribute;
import onl.netfishers.netshot.device.attribute.DeviceBinaryAttribute;
import onl.netfishers.netshot.device.attribute.DeviceLongTextAttribute;
import onl.netfishers.netshot.device.attribute.DeviceNumericAttribute;
import onl.netfishers.netshot.device.attribute.DeviceTextAttribute;
import onl.netfishers.netshot.device.credentials.DeviceCliAccount;
import onl.netfishers.netshot.work.Task;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class DeviceDriver {
    private static Logger logger = LoggerFactory.getLogger(DeviceDriver.class);
    private static String JSLOADER;
    private static Map<String, DeviceDriver> drivers;
    private String name;
    private String author;
    private String description;
    private String version;
    private Set<AttributeDefinition> attributes;
    private Set<DriverProtocol> protocols;
    private boolean canAnalyzeTraps;
    private boolean canAnalyzeSyslog;
    private boolean canSnmpAutodiscover;
    private ScriptEngine engine;

    public static Map<String, DeviceDriver> getDrivers() {
        return drivers;
    }

    public static Collection<DeviceDriver> getAllDrivers() {
        return drivers.values();
    }

    public static DeviceDriver getDriverByName(String name) {
        if (name == null) {
            return null;
        }
        return drivers.get(name);
    }

    public static void refreshDrivers() throws Exception {
        HashMap<String, DeviceDriver> drivers = new HashMap<String, DeviceDriver>();
        String addPath = Netshot.getConfig("netshot.drivers.path");
        if (addPath != null) {
            File folder = new File(addPath);
            if (folder != null && folder.isDirectory()) {
                File[] files;
                for (File file : files = folder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && pathname.getName().endsWith(".js");
                    }
                })) {
                    logger.info("Found user device driver file {}.", (Object)file);
                    try {
                        FileInputStream stream = new FileInputStream(file);
                        DeviceDriver driver = new DeviceDriver(stream);
                        if (drivers.containsKey(driver.getName())) {
                            logger.warn("Skipping user device driver file {}, because a similar driver is already loaded.", (Object)file);
                            continue;
                        }
                        drivers.put(driver.getName(), driver);
                    }
                    catch (Exception e) {
                        logger.error("Error while loading user device driver {}.", (Object)file, (Object)e);
                    }
                }
            } else {
                logger.error("Unable to open {} to find device drivers.", (Object)addPath);
            }
        }
        String driverPathName = "drivers/";
        URL driverUrl = DeviceDriver.class.getResource("/" + driverPathName);
        if (driverUrl != null && "file".equals(driverUrl.getProtocol())) {
            logger.debug("Scanning folder {} for device drivers (.js).", (Object)driverUrl);
            File folder = new File(driverUrl.toURI());
            if (folder.isDirectory()) {
                File[] files;
                for (File file : files = folder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && pathname.getName().endsWith(".js");
                    }
                })) {
                    logger.info("Found Netshot device driver file {}.", (Object)file);
                    try {
                        InputStream stream = DeviceDriver.class.getResourceAsStream("/" + driverPathName + file.getName());
                        DeviceDriver driver = new DeviceDriver(stream);
                        if (drivers.containsKey(driver.getName())) {
                            logger.warn("Skipping Netshot device driver file {}, because a similar driver is already loaded.", (Object)file);
                            continue;
                        }
                        drivers.put(driver.getName(), driver);
                    }
                    catch (Exception e1) {
                        logger.error("Error while loading the device driver {}.", (Object)file, (Object)e1);
                    }
                }
            }
        }
        if (driverUrl != null && "jar".equals(driverUrl.getProtocol())) {
            String path = driverUrl.getFile();
            path = path.substring(0, path.lastIndexOf(33));
            File file = new File(new URI(path));
            try {
                JarFile jar = new JarFile(file);
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry je = e.nextElement();
                    if (je.isDirectory() || !je.getName().startsWith(driverPathName)) continue;
                    logger.info("Found Netshot device driver file {} (in jar).", (Object)file);
                    try {
                        InputStream stream = jar.getInputStream(je);
                        DeviceDriver driver = new DeviceDriver(stream);
                        if (drivers.containsKey(driver.getName())) {
                            logger.warn("Skipping Netshot device driver file {}, because a similar driver is already loaded.", (Object)file);
                            continue;
                        }
                        drivers.put(driver.getName(), driver);
                    }
                    catch (Exception e1) {
                        logger.error("Error while loading the device driver {} from jar file.", (Object)file, (Object)e1);
                    }
                }
                jar.close();
            }
            catch (Exception e) {
                logger.error("While looking for device drivers in {}.", (Object)path, (Object)e);
            }
        }
        DeviceDriver.drivers = drivers;
    }

    protected static Object toObject(Object o, String key, Object defaultValue) throws IllegalArgumentException {
        if (o == null || !(o instanceof Bindings) && !(o instanceof ScriptEngine)) {
            throw new IllegalArgumentException("Invalid object.");
        }
        Object v = null;
        if (o instanceof Bindings) {
            v = ((Bindings)o).get(key);
        }
        if (o instanceof ScriptEngine) {
            v = ((ScriptEngine)o).get(key);
        }
        if (v == null) {
            if (defaultValue == null) {
                throw new IllegalArgumentException(String.format("The key '%s' doesn't exist.", key));
            }
            return defaultValue;
        }
        return v;
    }

    protected static Object toObject(Object o, String key) throws IllegalArgumentException {
        return DeviceDriver.toObject(o, key, null);
    }

    protected static Bindings toBindings(Object o, String key) throws IllegalArgumentException {
        Object v = DeviceDriver.toObject(o, key);
        if (!(v instanceof Bindings)) {
            throw new IllegalArgumentException(String.format("The value of %s is not a Javascript object.", key));
        }
        return (Bindings)v;
    }

    protected static String toString(Object o, String key, String defaultValue) throws IllegalArgumentException {
        Object v = DeviceDriver.toObject(o, key, defaultValue);
        if (!(v instanceof String)) {
            throw new IllegalArgumentException(String.format("The value of %s is not a string.", key));
        }
        String s = (String)v;
        if (s.trim().equals("")) {
            throw new IllegalArgumentException(String.format("The value of %s cannot be empty.", key));
        }
        return s;
    }

    protected static String toString(Object o, String key) throws IllegalArgumentException {
        return DeviceDriver.toString(o, key, null);
    }

    protected static Integer toInteger(Object o, String key, Integer defaultValue) throws IllegalArgumentException {
        Object v = DeviceDriver.toObject(o, key, defaultValue);
        if (!(v instanceof Integer)) {
            throw new IllegalArgumentException(String.format("The value of %s is not an integer.", key));
        }
        return (Integer)v;
    }

    protected static Integer toInteger(Object o, String key) throws IllegalArgumentException {
        return DeviceDriver.toInteger(o, key, null);
    }

    protected static Boolean toBoolean(Object o, String key, Boolean defaultValue) throws IllegalArgumentException {
        Object v = DeviceDriver.toObject(o, key, defaultValue);
        if (!(v instanceof Boolean)) {
            throw new IllegalArgumentException(String.format("The value of %s is not a boolean.", key));
        }
        return (Boolean)v;
    }

    protected static Boolean toBoolean(Object o, String key) throws IllegalArgumentException {
        return DeviceDriver.toBoolean(o, key, null);
    }

    protected void testFunction(String function) throws IllegalArgumentException {
        try {
            ((Invocable)((Object)this.engine)).invokeFunction(function, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("The function %s doesn't exist.", function));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected DeviceDriver() {
        this.attributes = new HashSet<AttributeDefinition>();
        this.protocols = new HashSet<DriverProtocol>();
        this.canAnalyzeTraps = true;
        this.canAnalyzeSyslog = true;
        this.canSnmpAutodiscover = true;
    }

    /*
     * Exception decompiling
     */
    protected DeviceDriver(InputStream in) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    @XmlElement
    public String getAuthor() {
        return this.author;
    }

    @XmlElement
    public String getDescription() {
        return this.description;
    }

    @XmlElement
    public String getVersion() {
        return this.version;
    }

    @XmlElement
    public Set<DriverProtocol> getProtocols() {
        return this.protocols;
    }

    protected void setProtocols(Set<DriverProtocol> protocols) {
        this.protocols = protocols;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeviceDriver [");
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        if (this.author != null) {
            builder.append("author=");
            builder.append(this.author);
            builder.append(", ");
        }
        if (this.description != null) {
            builder.append("description=");
            builder.append(this.description);
            builder.append(", ");
        }
        builder.append("version=");
        builder.append(this.version);
        builder.append("]");
        return builder.toString();
    }

    private void cliRunFunction(Device device, Config config, Cli cli, DriverProtocol protocol, String function, DeviceCliAccount account, boolean debugSession) throws Device.InvalidCredentialsException, IOException, ScriptException {
        Session session = Database.getSession();
        DeviceDataProvider dataProvider = new DeviceDataProvider(session, device);
        JsCli jsCli = new JsCli(cli, account, debugSession);
        try {
            ((Invocable)((Object)this.engine)).invokeFunction("_connect", jsCli, protocol.value(), function, new JsDevice(device), new JsConfig(config), dataProvider);
        }
        catch (ScriptException e) {
            logger.error("Error while running function {} using driver {}.", function, this.name, e);
            device.logIt(String.format("Error while running function %s  using driver %s: '%s'.", function, this.name, e.getMessage()), 1);
            if (e.getMessage().contains("Authentication failed")) {
                throw new Device.InvalidCredentialsException("Authentication failed");
            }
            throw e;
        }
        catch (NoSuchMethodException e) {
            logger.error("No such method {} while using driver {}.", function, this.name, e);
            device.logIt(String.format("No such method %s while using driver %s to take snapshot: '%s'.", function, this.name, e.getMessage()), 1);
            throw new ScriptException(e);
        }
        finally {
            device.sessionDebugLog = jsCli.log;
            session.close();
        }
    }

    @XmlElement
    public Set<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    public void runScript(Device device, Cli cli, DriverProtocol protocol, DeviceCliAccount account, String script, boolean debugSession) throws Device.InvalidCredentialsException, IOException, ScriptException {
        if (script == null) {
            this.takeSnapshot(device, cli, protocol, account, debugSession);
        } else {
            JsCli jsCli = new JsCli(cli, account, debugSession);
            try {
                SimpleScriptContext scriptContext = new SimpleScriptContext();
                scriptContext.setBindings(this.engine.getContext().getBindings(100), 100);
                this.engine.eval(script, (ScriptContext)scriptContext);
                ((Invocable)((Object)this.engine)).invokeFunction("_connect", jsCli, protocol.value(), "run", new JsDevice(device));
            }
            catch (ScriptException e) {
                logger.error("Error while running script using driver {}.", (Object)this.name, (Object)e);
                device.logIt(String.format("Error while running script  using driver %s: '%s'.", this.name, e.getMessage()), 1);
                if (e.getMessage().contains("Authentication failed")) {
                    throw new Device.InvalidCredentialsException("Authentication failed");
                }
                throw e;
            }
            catch (NoSuchMethodException e) {
                logger.error("No such method while using driver {}.", (Object)this.name, (Object)e);
                device.logIt(String.format("No such method while using driver %s to take snapshot: '%s'.", this.name, e.getMessage()), 1);
                throw new ScriptException(e);
            }
            finally {
                device.sessionDebugLog = jsCli.log;
            }
        }
    }

    public void takeSnapshot(Device device, Cli cli, DriverProtocol protocol, DeviceCliAccount account, boolean debugSession) throws Device.InvalidCredentialsException, IOException, ScriptException {
        ConfigAttribute newAttribute;
        Map<String, ConfigAttribute> newAttributes;
        boolean different;
        Config config;
        block19: {
            config = new Config(device);
            this.cliRunFunction(device, config, cli, protocol, "snapshot", account, debugSession);
            different = false;
            try {
                Config lastConfig = Database.unproxy(device.getLastConfig());
                if (lastConfig == null) {
                    different = true;
                    break block19;
                }
                Map<String, ConfigAttribute> oldAttributes = lastConfig.getAttributeMap();
                newAttributes = config.getAttributeMap();
                for (AttributeDefinition definition : this.attributes) {
                    if (definition.getLevel() != AttributeLevel.CONFIG) continue;
                    ConfigAttribute oldAttribute = oldAttributes.get(definition.getName());
                    newAttribute = newAttributes.get(definition.getName());
                    if (oldAttribute != null) {
                        if (oldAttribute.equals(newAttribute)) continue;
                        different = true;
                    } else {
                        if (newAttribute == null) continue;
                        different = true;
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error("Error while comparing old and new configuration. Will save the new configuration.", e);
            }
        }
        if (different) {
            device.setLastConfig(config);
            device.getConfigs().add(config);
        } else {
            device.logIt("The configuration hasn't changed. Not storing a new one in the DB.", 1);
        }
        String path = Netshot.getConfig("netshot.snapshots.dump");
        if (path != null) {
            try {
                BufferedWriter output = new BufferedWriter(new FileWriter(Paths.get(path, device.getName()).normalize().toFile()));
                newAttributes = config.getAttributeMap();
                for (AttributeDefinition definition : this.attributes) {
                    String postText;
                    String text;
                    if (!definition.isDump()) continue;
                    String preText = definition.getPreDump();
                    if (preText != null) {
                        preText = preText.replaceAll("%when%", Matcher.quoteReplacement(new Date().toString()));
                        output.write(preText);
                        output.write("\r\n");
                    }
                    if ((newAttribute = newAttributes.get(definition.getName())) != null && (text = newAttribute.getAsText()) != null) {
                        if (definition.getPreLineDump() != null || definition.getPostLineDump() != null) {
                            String[] lines;
                            for (String line : lines = text.split("\\r?\\n")) {
                                if (definition.getPreLineDump() != null) {
                                    output.write(definition.getPreLineDump());
                                }
                                output.write(line);
                                if (definition.getPostLineDump() != null) {
                                    output.write(definition.getPostLineDump());
                                }
                                output.write("\r\n");
                            }
                        } else {
                            output.write(text);
                        }
                    }
                    if ((postText = definition.getPostDump()) == null) continue;
                    postText = postText.replaceAll("%when%", Matcher.quoteReplacement(new Date().toString()));
                    output.write(postText);
                    output.write("\r\n");
                }
                output.close();
                device.logIt("The configuration has been saved as a file in the dump folder.", 5);
            }
            catch (IOException e) {
                logger.warn("Couldn't write the configuration into file.", e);
                device.logIt("Unable to write the configuration as a file.", 2);
            }
        }
    }

    public boolean snmpAutoDiscover(Task task, String sysObjectId, String sysDesc) {
        if (!this.canSnmpAutodiscover) {
            return false;
        }
        try {
            Object result = ((Invocable)((Object)this.engine)).invokeFunction("_snmpAutoDiscover", sysObjectId, sysDesc, new JsTaskLogger(task));
            if (result != null && result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (Exception e) {
            if (e instanceof ScriptException && e.getMessage() != null && e.getMessage().contains("No snmpAutoDiscover function.")) {
                logger.info("The driver {} has no snmpAutoDiscover function.", (Object)this.name);
                this.canSnmpAutodiscover = false;
            }
            logger.error("Error while running _identify function on driver {}.", (Object)this.name, (Object)e);
        }
        return false;
    }

    public boolean analyzeTrap(Map<String, String> data, Network4Address ip) {
        if (!this.canAnalyzeTraps) {
            return false;
        }
        try {
            Object result = ((Invocable)((Object)this.engine)).invokeFunction("_analyzeTrap", data, new JsSnmpLogger());
            if (result != null && result instanceof Boolean && ((Boolean)result).booleanValue()) {
                return true;
            }
        }
        catch (Exception e) {
            if (e instanceof ScriptException && e.getMessage() != null && e.getMessage().contains("No analyzeTrap function.")) {
                logger.info("The driver {} has no analyzeTrap function. Won't be called again.", (Object)this.name);
                this.canAnalyzeTraps = false;
            }
            logger.error("Error while running _analyzeTrap function on driver {}.", (Object)this.name, (Object)e);
        }
        return false;
    }

    public boolean analyzeSyslog(String message, Network4Address ip) {
        if (!this.canAnalyzeSyslog) {
            return false;
        }
        try {
            Object result = ((Invocable)((Object)this.engine)).invokeFunction("_analyzeSyslog", message, new JsSyslogLogger());
            if (result != null && result instanceof Boolean && ((Boolean)result).booleanValue()) {
                return true;
            }
        }
        catch (Exception e) {
            if (e instanceof ScriptException && e.getMessage() != null && e.getMessage().contains("No analyzeSyslog function.")) {
                logger.info("The driver {} has no analyzeSyslog function. Won't be called again.", (Object)this.name);
                this.canAnalyzeSyslog = false;
            }
            logger.error("Error while running _analyzeSyslog function on driver {}.", (Object)this.name, (Object)e);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceDriver)) {
            return false;
        }
        DeviceDriver other = (DeviceDriver)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    static {
        try {
            logger.info("Reading the JavaScript driver loader code from the resource JS file.");
            String path = "interfaces/driver-loader.js";
            InputStream in = DeviceDriver.class.getResourceAsStream("/" + path);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line + "\n");
            }
            reader.close();
            in.close();
            JSLOADER = buffer.toString();
            logger.debug("The JavaScript driver loader code has been read from the resource JS file.");
        }
        catch (Exception e) {
            logger.error(MarkerFactory.getMarker("FATAL"), "Unable to read the Javascript driver loader.", e);
            System.err.println("NETSHOT FATAL ERROR");
            e.printStackTrace();
            System.exit(1);
        }
        drivers = new HashMap<String, DeviceDriver>();
    }

    public class JsSyslogLogger {
        public void debug(String message) {
            Logger logger2 = LoggerFactory.getLogger(SyslogServer.class);
            logger2.debug("JS debug - " + message);
        }
    }

    public class JsSnmpLogger {
        public void debug(String message) {
            Logger logger2 = LoggerFactory.getLogger(SnmpTrapReceiver.class);
            logger2.debug("JS debug - " + message);
        }
    }

    public class JsTaskLogger {
        Task task;

        public JsTaskLogger(Task task) {
            this.task = task;
        }

        public void debug(String message) {
            this.task.logIt("JS debug - " + message, 5);
        }
    }

    public class JsDevice {
        private Device device;

        public JsDevice(Device device) {
            this.device = device;
        }

        public void reset() {
            this.device.setFamily("");
            this.device.setLocation("");
            this.device.setContact("");
            this.device.setSoftwareVersion("");
            this.device.setNetworkClass(Device.NetworkClass.UNKNOWN);
            this.device.clearAttributes();
            this.device.clearVrfInstance();
            this.device.clearVirtualDevices();
            this.device.getNetworkInterfaces().clear();
            this.device.getModules().clear();
            this.device.setEolModule(null);
            this.device.setEosModule(null);
            this.device.setEolDate(null);
            this.device.setEosDate(null);
        }

        public void set(String key, String value) {
            block17: {
                if (value == null) {
                    return;
                }
                try {
                    if ("name".equals(key)) {
                        this.device.setName(value);
                        break block17;
                    }
                    if ("family".equals(key)) {
                        this.device.setFamily(value);
                        break block17;
                    }
                    if ("location".equals(key)) {
                        this.device.setLocation(value);
                        break block17;
                    }
                    if ("contact".equals(key)) {
                        this.device.setContact(value);
                        break block17;
                    }
                    if ("softwareVersion".equals(key)) {
                        this.device.setSoftwareVersion(value);
                        break block17;
                    }
                    if ("serialNumber".equals(key)) {
                        this.device.setSerialNumber(value);
                        break block17;
                    }
                    if ("comments".equals(key)) {
                        this.device.setComments(value);
                        break block17;
                    }
                    if ("networkClass".equals(key)) {
                        Device.NetworkClass nc = Device.NetworkClass.valueOf(value);
                        if (nc != null) {
                            this.device.setNetworkClass(nc);
                        }
                        break block17;
                    }
                    for (AttributeDefinition attribute : DeviceDriver.this.attributes) {
                        if (!attribute.getLevel().equals((Object)AttributeLevel.DEVICE) || !attribute.getName().equals(key)) continue;
                        switch (attribute.getType()) {
                            case LONGTEXT: {
                                this.device.addAttribute(new DeviceLongTextAttribute(this.device, key, value));
                                break;
                            }
                            case TEXT: {
                                this.device.addAttribute(new DeviceTextAttribute(this.device, key, value));
                                break;
                            }
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    logger.warn("Error during snapshot while setting device attribute key '{}'.", (Object)key);
                }
            }
        }

        public void set(String key, Double value) {
            if (value == null) {
                return;
            }
            try {
                for (AttributeDefinition attribute : DeviceDriver.this.attributes) {
                    if (!attribute.getLevel().equals((Object)AttributeLevel.DEVICE) || !attribute.getName().equals(key)) continue;
                    switch (attribute.getType()) {
                        case NUMERIC: {
                            this.device.addAttribute(new DeviceNumericAttribute(this.device, key, value));
                            break;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.warn("Error during snapshot while setting device attribute key '{}'.", (Object)key);
            }
        }

        public void set(String key, Boolean value) {
            if (value == null) {
                return;
            }
            try {
                for (AttributeDefinition attribute : DeviceDriver.this.attributes) {
                    if (!attribute.getLevel().equals((Object)AttributeLevel.DEVICE) || !attribute.getName().equals(key)) continue;
                    switch (attribute.getType()) {
                        case BINARY: {
                            this.device.addAttribute(new DeviceBinaryAttribute(this.device, key, value));
                            break;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.warn("Error during snapshot while setting device attribute key '{}'.", (Object)key);
            }
        }

        public void add(String key, String value) {
            if (value == null) {
                return;
            }
            try {
                if ("vrf".equals(key)) {
                    this.device.addVrfInstance(value);
                } else if ("virtualDevice".equals(key)) {
                    this.device.addVirtualDevice(value);
                }
            }
            catch (Exception e) {
                logger.warn("Error during snapshot while adding device attribute key '{}'.", (Object)key, (Object)e);
            }
        }

        public void add(String key, Bindings data) {
            if (data == null) {
                return;
            }
            try {
                if ("module".equals(key)) {
                    Module module = new Module(data.getOrDefault("slot", ""), data.getOrDefault("partNumber", ""), data.getOrDefault("serialNumber", ""), this.device);
                    this.device.getModules().add(module);
                } else if ("networkInterface".equals(key)) {
                    Boolean enabled = data.getOrDefault("enabled", true);
                    enabled = enabled == null ? Boolean.valueOf(false) : enabled;
                    Boolean level3 = data.getOrDefault("level3", true);
                    level3 = level3 == null ? Boolean.valueOf(false) : level3;
                    NetworkInterface networkInterface = new NetworkInterface(this.device, (String)data.get("name"), data.getOrDefault("virtualDevice", ""), data.getOrDefault("vrf", ""), enabled, level3, data.getOrDefault("description", ""));
                    networkInterface.setPhysicalAddress(new PhysicalAddress(data.getOrDefault("mac", "0000.0000.0000")));
                    Bindings ipAddresses = (Bindings)data.get("ip");
                    if (ipAddresses != null) {
                        for (Object ipAddress : ipAddresses.values()) {
                            Bindings ip = (Bindings)ipAddress;
                            NetworkAddress address = null;
                            address = ip.get("ipv6") != null ? new Network6Address((String)ip.get("ipv6"), ((Number)ip.get("mask")).intValue()) : (ip.get("mask") instanceof Number ? new Network4Address((String)ip.get("ip"), ((Number)ip.get("mask")).intValue()) : new Network4Address((String)ip.get("ip"), (String)ip.get("mask")));
                            Object usage = ip.get("usage");
                            if (usage != null) {
                                address.setAddressUsage(NetworkAddress.AddressUsage.valueOf((String)usage));
                            }
                            networkInterface.addIpAddress(address);
                        }
                    }
                    this.device.getNetworkInterfaces().add(networkInterface);
                }
            }
            catch (Exception e) {
                logger.warn("Error during snapshot while adding device attribute key '{}'.", (Object)key, (Object)e);
                this.device.logIt(String.format("Can't add device attribute %s: %s", key, e.getMessage()), 1);
            }
        }

        public void debug(String message) {
            this.device.logIt("JS debug - " + message, 5);
        }
    }

    public class JsConfig {
        private Config config;

        public JsConfig(Config config) {
            this.config = config;
        }

        public void set(String key, Double value) {
            if (value == null) {
                return;
            }
            try {
                for (AttributeDefinition attribute : DeviceDriver.this.attributes) {
                    if (!attribute.getLevel().equals((Object)AttributeLevel.CONFIG) || !attribute.getName().equals(key)) continue;
                    switch (attribute.getType()) {
                        case NUMERIC: {
                            this.config.addAttribute(new ConfigNumericAttribute(this.config, key, value));
                            break;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.warn("Error during snapshot while setting config attribute key '{}'.", (Object)key);
            }
        }

        public void set(String key, Boolean value) {
            if (value == null) {
                return;
            }
            try {
                for (AttributeDefinition attribute : DeviceDriver.this.attributes) {
                    if (!attribute.getLevel().equals((Object)AttributeLevel.CONFIG) || !attribute.getName().equals(key)) continue;
                    switch (attribute.getType()) {
                        case BINARY: {
                            this.config.addAttribute(new ConfigBinaryAttribute(this.config, key, value));
                            break;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.warn("Error during snapshot while setting config attribute key '{}'.", (Object)key);
            }
        }

        public void set(String key, Object value) {
            block9: {
                if (value == null) {
                    return;
                }
                try {
                    if ("author".equals(key)) {
                        this.config.setAuthor((String)value);
                        break block9;
                    }
                    for (AttributeDefinition attribute : DeviceDriver.this.attributes) {
                        if (!attribute.getLevel().equals((Object)AttributeLevel.CONFIG) || !attribute.getName().equals(key)) continue;
                        switch (attribute.getType()) {
                            case LONGTEXT: {
                                this.config.addAttribute(new ConfigLongTextAttribute(this.config, key, (String)value));
                                break;
                            }
                            case TEXT: {
                                this.config.addAttribute(new ConfigTextAttribute(this.config, key, (String)value));
                                break;
                            }
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    logger.warn("Error during snapshot while setting config attribute key '{}'.", (Object)key);
                }
            }
        }
    }

    public static class JsCli {
        private Cli cli;
        private DeviceCliAccount account;
        private boolean errored = false;
        private boolean debugSession = false;
        protected transient List<String> log = new ArrayList<String>();

        private static String toHexAscii(String text) {
            StringBuffer hex = new StringBuffer();
            for (int i = 0; i < text.length(); ++i) {
                if (i % 16 == 0 && i > 0) {
                    hex.append("\n");
                }
                hex.append(" ").append(String.format("%02x", text.charAt(i)));
            }
            return hex.toString();
        }

        private JsCli(Cli cli, DeviceCliAccount account) {
            this.cli = cli;
            this.account = account;
        }

        private JsCli(Cli cli, DeviceCliAccount account, boolean debugSession) {
            this(cli, account);
            this.debugSession = debugSession;
        }

        public String removeEcho(String text, String command) {
            String output = text;
            String headCommand = command;
            if (output.startsWith(headCommand = headCommand.replaceFirst("[\\r\\n]+$", ""))) {
                output = output.substring(headCommand.length());
                output = output.replaceFirst("^ *[\\r\\n]+", "");
                return output;
            }
            return output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String send(String command, String[] expects, int timeout) {
            this.errored = false;
            if (command == null) {
                command = "";
            }
            if (this.debugSession) {
                this.logIt("About to send the following command: '" + command + "'");
                this.logIt("In hex: " + JsCli.toHexAscii(command));
            }
            command = command.replaceAll("\\$\\$NetshotUsername\\$\\$", Matcher.quoteReplacement(this.account.getUsername()));
            command = command.replaceAll("\\$\\$NetshotPassword\\$\\$", Matcher.quoteReplacement(this.account.getPassword()));
            command = command.replaceAll("\\$\\$NetshotSuperPassword\\$\\$", Matcher.quoteReplacement(this.account.getSuperPassword()));
            int oldTimeout = this.cli.getCommandTimeout();
            if (timeout > 0) {
                this.cli.setCommandTimeout(timeout);
            }
            try {
                logger.debug("Command to be sent: '{}'.", (Object)command);
                String result = this.cli.send(command, expects);
                if (this.debugSession) {
                    this.logIt("Received the following output: '" + result + "'");
                    this.logIt("In hex: " + JsCli.toHexAscii(result));
                }
                String string = result;
                return string;
            }
            catch (IOException e) {
                logger.error("CLI I/O error.", e);
                this.logIt("I/O error: " + e.getMessage());
                if (this.debugSession && e instanceof Cli.WithBufferIOException) {
                    String buffer = ((Cli.WithBufferIOException)e).getReceivedBuffer().toString();
                    this.logIt("Received buffer: '" + buffer + "'");
                    this.logIt("In hex: " + JsCli.toHexAscii(buffer));
                }
                this.errored = true;
            }
            finally {
                this.cli.setCommandTimeout(oldTimeout);
            }
            return null;
        }

        public String send(String command, String[] expects) throws IOException {
            return this.send(command, expects, -1);
        }

        public String send(String[] expects) throws IOException {
            return this.send(null, expects, -1);
        }

        public String getLastCommand() {
            return this.cli.getLastCommand();
        }

        public String getLastExpectMatch() {
            return this.cli.getLastExpectMatch().group();
        }

        public String getLastExpectMatchGroup(int group) {
            try {
                return this.cli.getLastExpectMatch().group(group);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getLastExpectMatchPattern() {
            return this.cli.getLastExpectMatchPattern();
        }

        public int getLastExpectMatchIndex() {
            return this.cli.getLastExpectMatchIndex();
        }

        public String getLastFullOutput() {
            return this.cli.getLastFullOutput();
        }

        public boolean isErrored() {
            return this.errored;
        }

        public void sleep(long millis) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void log() {
        }

        protected void logIt(String log) {
            this.log.add(Instant.now() + " [CLI] " + log);
        }

        public List<String> getLog() {
            return this.log;
        }
    }

    public static class AttributeDefinition {
        private AttributeType type;
        private AttributeLevel level;
        private String name;
        private String title;
        private boolean comparable = false;
        private boolean searchable = false;
        private boolean checkable = false;
        private boolean dump = false;
        private String preDump = null;
        private String postDump = null;
        private String preLineDump = null;
        private String postLineDump = null;

        protected AttributeDefinition() {
        }

        public AttributeDefinition(AttributeType type, AttributeLevel level, String name, String title, boolean comparable, boolean searchable, boolean checkable) {
            this.type = type;
            this.level = level;
            this.name = name;
            this.title = title;
            this.comparable = comparable;
            this.searchable = searchable;
            this.checkable = checkable;
        }

        public AttributeDefinition(AttributeLevel level, String name, Object data) throws Exception {
            this.level = level;
            this.name = name;
            this.title = DeviceDriver.toString(data, "title");
            if (!this.title.matches("^[0-9A-Za-z\\-_\\(\\)][0-9A-Za-z \\-_\\(\\)]+$")) {
                throw new IllegalArgumentException("Invalid title for item %s.");
            }
            String type = DeviceDriver.toString(data, "type");
            if (type.equals("Text")) {
                this.type = AttributeType.TEXT;
            } else if (type.equals("LongText")) {
                this.type = AttributeType.LONGTEXT;
            } else if (type.equals("Numeric")) {
                this.type = AttributeType.NUMERIC;
            } else if (type.equals("Binary")) {
                this.type = AttributeType.BINARY;
            } else {
                throw new IllegalArgumentException("Invalid type for item %s.");
            }
            this.searchable = DeviceDriver.toBoolean(data, "searchable", false);
            this.comparable = DeviceDriver.toBoolean(data, "comparable", false);
            this.checkable = DeviceDriver.toBoolean(data, "checkable", false);
            Object dump = DeviceDriver.toObject(data, "dump", Boolean.FALSE);
            if (dump != null) {
                if (dump instanceof Boolean) {
                    this.dump = (Boolean)dump;
                } else if (dump instanceof Bindings) {
                    this.dump = true;
                    try {
                        this.preDump = DeviceDriver.toString(dump, "pre");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.preLineDump = DeviceDriver.toString(dump, "preLine");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.postDump = DeviceDriver.toString(dump, "post");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.postLineDump = DeviceDriver.toString(dump, "postLine");
                    }
                    catch (Exception exception) {}
                } else {
                    throw new IllegalArgumentException("Invalid 'dump' object in Config.");
                }
            }
        }

        @XmlElement
        public AttributeType getType() {
            return this.type;
        }

        public void setType(AttributeType type) {
            this.type = type;
        }

        @XmlElement
        public AttributeLevel getLevel() {
            return this.level;
        }

        public void setLevel(AttributeLevel level) {
            this.level = level;
        }

        @XmlElement
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlElement
        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        @XmlElement
        public boolean isComparable() {
            return this.comparable;
        }

        public void setComparable(boolean comparable) {
            this.comparable = comparable;
        }

        @XmlElement
        public boolean isCheckable() {
            return this.checkable;
        }

        public void setCheckable(boolean checkable) {
            this.checkable = checkable;
        }

        @XmlElement
        public boolean isSearchable() {
            return this.searchable;
        }

        public void setSearchable(boolean searchable) {
            this.searchable = searchable;
        }

        public boolean isDump() {
            return this.dump;
        }

        public void setDump(boolean dump) {
            this.dump = dump;
        }

        public String getPreDump() {
            return this.preDump;
        }

        public void setPreDump(String preDump) {
            this.preDump = preDump;
        }

        public String getPostDump() {
            return this.postDump;
        }

        public void setPostDump(String postDump) {
            this.postDump = postDump;
        }

        public String getPreLineDump() {
            return this.preLineDump;
        }

        public void setPreLineDump(String preLineDump) {
            this.preLineDump = preLineDump;
        }

        public String getPostLineDump() {
            return this.postLineDump;
        }

        public void setPostLineDump(String postLineDump) {
            this.postLineDump = postLineDump;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AttributeDefinition [");
            if (this.type != null) {
                builder.append("type=");
                builder.append((Object)this.type);
                builder.append(", ");
            }
            if (this.level != null) {
                builder.append("level=");
                builder.append((Object)this.level);
                builder.append(", ");
            }
            if (this.name != null) {
                builder.append("name=");
                builder.append(this.name);
                builder.append(", ");
            }
            if (this.title != null) {
                builder.append("title=");
                builder.append(this.title);
                builder.append(", ");
            }
            builder.append("comparable=");
            builder.append(this.comparable);
            builder.append(", searchable=");
            builder.append(this.searchable);
            builder.append("]");
            return builder.toString();
        }
    }

    public static enum AttributeLevel {
        DEVICE,
        CONFIG;

    }

    public static enum AttributeType {
        NUMERIC,
        TEXT,
        LONGTEXT,
        DATE,
        BINARY;

    }

    public static enum DriverProtocol {
        TELNET("telnet"),
        SSH("ssh");

        private String protocol;

        private DriverProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String value() {
            return this.protocol;
        }
    }
}

