/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.persistence.Entity;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import onl.netfishers.netshot.Netshot;
import onl.netfishers.netshot.aaa.User;
import onl.netfishers.netshot.compliance.CheckResult;
import onl.netfishers.netshot.compliance.Exemption;
import onl.netfishers.netshot.compliance.HardwareRule;
import onl.netfishers.netshot.compliance.Policy;
import onl.netfishers.netshot.compliance.Rule;
import onl.netfishers.netshot.compliance.SoftwareRule;
import onl.netfishers.netshot.device.Config;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceGroup;
import onl.netfishers.netshot.device.Domain;
import onl.netfishers.netshot.device.DynamicDeviceGroup;
import onl.netfishers.netshot.device.Module;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.Network6Address;
import onl.netfishers.netshot.device.NetworkAddress;
import onl.netfishers.netshot.device.NetworkInterface;
import onl.netfishers.netshot.device.PhysicalAddress;
import onl.netfishers.netshot.device.StaticDeviceGroup;
import onl.netfishers.netshot.device.attribute.ConfigAttribute;
import onl.netfishers.netshot.device.attribute.ConfigBinaryAttribute;
import onl.netfishers.netshot.device.attribute.ConfigLongTextAttribute;
import onl.netfishers.netshot.device.attribute.ConfigNumericAttribute;
import onl.netfishers.netshot.device.attribute.ConfigTextAttribute;
import onl.netfishers.netshot.device.attribute.DeviceAttribute;
import onl.netfishers.netshot.device.attribute.DeviceBinaryAttribute;
import onl.netfishers.netshot.device.attribute.DeviceLongTextAttribute;
import onl.netfishers.netshot.device.attribute.DeviceNumericAttribute;
import onl.netfishers.netshot.device.attribute.DeviceTextAttribute;
import onl.netfishers.netshot.device.attribute.LongTextConfiguration;
import onl.netfishers.netshot.device.credentials.DeviceSnmpv1Community;
import onl.netfishers.netshot.device.credentials.DeviceSnmpv2cCommunity;
import onl.netfishers.netshot.device.credentials.DeviceSnmpv3Community;
import onl.netfishers.netshot.device.credentials.DeviceSshAccount;
import onl.netfishers.netshot.device.credentials.DeviceSshKeyAccount;
import onl.netfishers.netshot.device.credentials.DeviceTelnetAccount;
import onl.netfishers.netshot.work.DebugLog;
import onl.netfishers.netshot.work.Task;
import onl.netfishers.netshot.work.tasks.DeviceJsScript;
import org.apache.commons.lang3.ArrayUtils;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.hibernate4.encryptor.HibernatePBEEncryptorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class Database {
    private static SessionFactory sessionFactory;
    private static ServiceRegistry serviceRegistry;
    private static Configuration configuration;
    private static Logger logger;

    public static List<Class<?>> listClassesInPackage(String packageName) throws ClassNotFoundException, IOException {
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = ClassLoader.getSystemResources(path);
        ArrayList<String> dirs = new ArrayList<String>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(URLDecoder.decode(resource.getFile(), "UTF-8"));
        }
        TreeSet<String> classes = new TreeSet<String>();
        for (String directory : dirs) {
            classes.addAll(Database.findClasses(directory, packageName));
        }
        ArrayList classList = new ArrayList();
        for (String clazz : classes) {
            classList.add(Class.forName(clazz));
        }
        return classList;
    }

    private static TreeSet<String> findClasses(String path, String packageName) throws MalformedURLException, IOException {
        File[] files;
        File dir;
        TreeSet<String> classes = new TreeSet<String>();
        if (path.startsWith("file:") && path.contains("!")) {
            ZipEntry entry;
            String[] split = path.split("!");
            URL jar = new URL(split[0]);
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((entry = zip.getNextEntry()) != null) {
                String className;
                if (!entry.getName().endsWith(".class") || !(className = entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.')).startsWith(packageName)) continue;
                classes.add(className);
            }
        }
        if (!(dir = new File(path)).exists()) {
            return classes;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(Database.findClasses(file.getAbsolutePath(), packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            classes.add(className);
        }
        return classes;
    }

    private static String getDriverClass() {
        return Netshot.getConfig("netshot.db.driver_class", "com.mysql.jdbc.Driver");
    }

    private static String getUrl() {
        return Netshot.getConfig("netshot.db.url", "jdbc:mysql://localhost/netshot01");
    }

    private static String getUsername() {
        return Netshot.getConfig("netshot.db.username", "netshot");
    }

    private static String getPassword() {
        return Netshot.getConfig("netshot.db.password", "netshot");
    }

    public static void update() {
        try {
            Connection connection = DriverManager.getConnection(Database.getUrl(), Database.getUsername(), Database.getPassword());
            liquibase.database.Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
            Liquibase liquibase = new Liquibase("migration/netshot0.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.update(new Contexts(), new LabelExpression());
        }
        catch (SQLException | LiquibaseException e) {
            logger.error(MarkerFactory.getMarker("FATAL"), "Unable to connect to the database (for the initial schema update)", e);
            throw new RuntimeException("Unable to connect to the database, see logs for more details");
        }
    }

    public static void init() {
        try {
            configuration = new Configuration();
            configuration.setProperty("hibernate.connection.driver_class", Database.getDriverClass()).setProperty("hibernate.connection.url", Database.getUrl()).setProperty("hibernate.connection.username", Database.getUsername()).setProperty("hibernate.connection.password", Database.getPassword()).setProperty("hibernate.c3p0.min_size", "5").setProperty("hibernate.c3p0.max_size", "30").setProperty("hibernate.c3p0.timeout", "1800").setProperty("hibernate.c3p0.max_statements", "50").setProperty("hibernate.c3p0.unreturnedConnectionTimeout", "1800").setProperty("hibernate.c3p0.debugUnreturnedConnectionStackTraces", "true");
            StandardPBEStringEncryptor credentialEncryptor = new StandardPBEStringEncryptor();
            String cryptPassword = Netshot.getConfig("netshot.db.encryptionpassword", null);
            if (cryptPassword == null) {
                cryptPassword = Netshot.getConfig("netshot.db.encryptionPassword", "NETSHOT");
            }
            credentialEncryptor.setPassword(cryptPassword);
            HibernatePBEEncryptorRegistry encryptorRegistry = HibernatePBEEncryptorRegistry.getInstance();
            encryptorRegistry.registerPBEStringEncryptor("credentialEncryptor", credentialEncryptor);
            configuration.setProperty("factory_class", "org.hibernate.transaction.JDBCTransactionFactory").setProperty("current_session_context_class", "thread").setProperty("hibernate.hbm2ddl.auto", "").addAnnotatedClass(Device.class).addAnnotatedClass(DeviceGroup.class).addAnnotatedClass(Config.class).addAnnotatedClass(DeviceAttribute.class).addAnnotatedClass(DeviceNumericAttribute.class).addAnnotatedClass(DeviceTextAttribute.class).addAnnotatedClass(DeviceLongTextAttribute.class).addAnnotatedClass(DeviceBinaryAttribute.class).addAnnotatedClass(ConfigAttribute.class).addAnnotatedClass(ConfigNumericAttribute.class).addAnnotatedClass(ConfigTextAttribute.class).addAnnotatedClass(ConfigLongTextAttribute.class).addAnnotatedClass(ConfigBinaryAttribute.class).addAnnotatedClass(LongTextConfiguration.class).addAnnotatedClass(StaticDeviceGroup.class).addAnnotatedClass(DynamicDeviceGroup.class).addAnnotatedClass(Module.class).addAnnotatedClass(Domain.class).addAnnotatedClass(PhysicalAddress.class).addAnnotatedClass(NetworkAddress.class).addAnnotatedClass(Network4Address.class).addAnnotatedClass(Network6Address.class).addAnnotatedClass(NetworkInterface.class).addAnnotatedClass(DeviceSnmpv1Community.class).addAnnotatedClass(DeviceSnmpv2cCommunity.class).addAnnotatedClass(DeviceSnmpv3Community.class).addAnnotatedClass(DeviceSshAccount.class).addAnnotatedClass(DeviceSshKeyAccount.class).addAnnotatedClass(DeviceTelnetAccount.class).addAnnotatedClass(Policy.class).addAnnotatedClass(Rule.class).addAnnotatedClass(Task.class).addAnnotatedClass(DebugLog.class).addAnnotatedClass(Exemption.class).addAnnotatedClass(Exemption.Key.class).addAnnotatedClass(CheckResult.class).addAnnotatedClass(CheckResult.Key.class).addAnnotatedClass(SoftwareRule.class).addAnnotatedClass(HardwareRule.class).addAnnotatedClass(DeviceJsScript.class).addAnnotatedClass(User.class);
            for (Class<? extends Task> clazz : Task.getTaskClasses()) {
                logger.info("Registering task class " + clazz.getName());
                configuration.addAnnotatedClass(clazz);
            }
            for (Class<Object> clazz : Rule.getRuleClasses()) {
                configuration.addAnnotatedClass(clazz);
                for (Class<?> subClass : clazz.getClasses()) {
                    if (subClass.getAnnotation(Entity.class) == null) continue;
                    configuration.addAnnotatedClass(subClass);
                }
            }
            configuration.setNamingStrategy(new ImprovedNamingStrategy());
            configuration.setInterceptor(new DatabaseInterceptor());
            serviceRegistry = new StandardServiceRegistryBuilder().applySettings(configuration.getProperties()).build();
            sessionFactory = configuration.buildSessionFactory(serviceRegistry);
        }
        catch (HibernateException e) {
            logger.error(MarkerFactory.getMarker("FATAL"), "Unable to instantiate Hibernate", e);
            throw new RuntimeException("Unable to instantiate Hibernate, see logs for more details");
        }
    }

    public static Session getSession() throws HibernateException {
        return sessionFactory.openSession();
    }

    public static <T> T unproxy(T entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof HibernateProxy) {
            Hibernate.initialize(entity);
            entity = ((HibernateProxy)entity).getHibernateLazyInitializer().getImplementation();
        }
        return entity;
    }

    static {
        logger = LoggerFactory.getLogger(Database.class);
    }

    private static class DatabaseInterceptor
    extends EmptyInterceptor {
        private static final long serialVersionUID = 5897665908529047371L;

        private DatabaseInterceptor() {
        }

        @Override
        public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
            int indexOf = ArrayUtils.indexOf(propertyNames, "changeDate");
            if (indexOf != -1) {
                currentState[indexOf] = new Date(1000L * (System.currentTimeMillis() / 1000L));
                return true;
            }
            return false;
        }

        @Override
        public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
            int indexOf = ArrayUtils.indexOf(propertyNames, "changeDate");
            if (indexOf != -1) {
                if (state[indexOf] == null) {
                    state[indexOf] = new Date(1000L * (System.currentTimeMillis() / 1000L));
                }
                return true;
            }
            return false;
        }
    }
}

