/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.yaml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import liquibase.ContextExpression;
import liquibase.Labels;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.logging.LogType;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.yaml.YamlParser;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class YamlChangeLogParser
extends YamlParser
implements ChangeLogParser {
    @Override
    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        Yaml yaml = new Yaml(new SafeConstructor());
        try {
            InputStream changeLogStream = StreamUtil.singleInputStream(physicalChangeLogLocation, resourceAccessor);
            if (changeLogStream == null) {
                throw new ChangeLogParseException(physicalChangeLogLocation + " does not exist");
            }
            Map parsedYaml = this.parseYamlStream(physicalChangeLogLocation, yaml, changeLogStream);
            if (parsedYaml == null || parsedYaml.isEmpty()) {
                throw new ChangeLogParseException("Empty file " + physicalChangeLogLocation);
            }
            DatabaseChangeLog changeLog = new DatabaseChangeLog(physicalChangeLogLocation);
            Object rootList = parsedYaml.get("databaseChangeLog");
            if (rootList == null) {
                throw new ChangeLogParseException("Could not find databaseChangeLog node");
            }
            if (!(rootList instanceof List)) {
                throw new ChangeLogParseException("databaseChangeLog does not contain a list of entries. Each changeSet must begin ' - changeSet:'");
            }
            for (Object obj : (List)rootList) {
                if (!(obj instanceof Map) || !((Map)obj).containsKey("property")) continue;
                Map property = (Map)((Map)obj).get("property");
                ContextExpression context = new ContextExpression((String)property.get("context"));
                Labels labels = new Labels((String)property.get("labels"));
                Boolean global = this.getGlobalParam(property);
                if (property.containsKey("name")) {
                    Object value = property.get("value");
                    if (value != null) {
                        value = value.toString();
                    }
                    changeLogParameters.set((String)property.get("name"), (String)value, context, labels, (String)property.get("dbms"), (boolean)global, changeLog);
                    continue;
                }
                if (!property.containsKey("file")) continue;
                this.loadChangeLogParametersFromFile(changeLogParameters, resourceAccessor, changeLog, property, context, labels, global);
            }
            this.replaceParameters(parsedYaml, changeLogParameters, changeLog);
            changeLog.setChangeLogParameters(changeLogParameters);
            ParsedNode databaseChangeLogNode = new ParsedNode(null, "databaseChangeLog");
            databaseChangeLogNode.setValue(rootList);
            changeLog.load(databaseChangeLogNode, resourceAccessor);
            return changeLog;
        }
        catch (ChangeLogParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ChangeLogParseException("Error parsing " + physicalChangeLogLocation, e);
        }
    }

    private Map parseYamlStream(String physicalChangeLogLocation, Yaml yaml, InputStream changeLogStream) throws ChangeLogParseException {
        Map parsedYaml;
        try {
            parsedYaml = (Map)yaml.load(changeLogStream);
        }
        catch (Exception e) {
            throw new ChangeLogParseException("Syntax error in file " + physicalChangeLogLocation + ": " + e.getMessage(), e);
        }
        return parsedYaml;
    }

    private void loadChangeLogParametersFromFile(ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor, DatabaseChangeLog changeLog, Map property, ContextExpression context, Labels labels, Boolean global) throws IOException {
        Properties props = new Properties();
        try (InputStream propertiesStream = StreamUtil.singleInputStream((String)property.get("file"), resourceAccessor);){
            if (propertiesStream == null) {
                this.log.info(LogType.LOG, "Could not open properties file " + property.get("file"));
            } else {
                props.load(propertiesStream);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    changeLogParameters.set(entry.getKey().toString(), entry.getValue().toString(), context, labels, (String)property.get("dbms"), (boolean)global, changeLog);
                }
            }
        }
    }

    private Boolean getGlobalParam(Map property) {
        Boolean global = null;
        Object globalObj = property.get("global");
        global = globalObj == null ? Boolean.valueOf(true) : (Boolean)globalObj;
        return global;
    }

    protected void replaceParameters(Object obj, ChangeLogParameters changeLogParameters, DatabaseChangeLog changeLog) {
        block5: {
            block4: {
                if (!(obj instanceof Map)) break block4;
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    if (entry.getValue() instanceof Map || entry.getValue() instanceof Collection) {
                        this.replaceParameters(entry.getValue(), changeLogParameters, changeLog);
                        continue;
                    }
                    if (!(entry.getValue() instanceof String)) continue;
                    entry.setValue(changeLogParameters.expandExpressions((String)entry.getValue(), changeLog));
                }
                break block5;
            }
            if (!(obj instanceof Collection)) break block5;
            ListIterator<String> iterator = ((List)obj).listIterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Map || e instanceof Collection) {
                    this.replaceParameters(e, changeLogParameters, changeLog);
                    continue;
                }
                if (!(e instanceof String)) continue;
                iterator.set(changeLogParameters.expandExpressions((String)e, changeLog));
            }
        }
    }
}

