/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import liquibase.ContextExpression;
import liquibase.Labels;
import liquibase.change.CheckSum;
import liquibase.changelog.AbstractChangeLogHistoryService;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.OfflineConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.servicelocator.LiquibaseService;
import liquibase.statement.core.CreateDatabaseChangeLogTableStatement;
import liquibase.statement.core.MarkChangeSetRanStatement;
import liquibase.statement.core.RemoveChangeSetRanStatusStatement;
import liquibase.statement.core.UpdateChangeSetChecksumStatement;
import liquibase.util.ISODateFormat;
import liquibase.util.LiquibaseUtil;
import liquibase.util.csv.CSVReader;
import liquibase.util.csv.CSVWriter;

@LiquibaseService(skip=true)
public class OfflineChangeLogHistoryService
extends AbstractChangeLogHistoryService {
    private final File changeLogFile;
    private boolean executeDmlAgainstDatabase = true;
    private boolean executeDdlAgainstDatabase = true;
    private int COLUMN_ID;
    private int COLUMN_AUTHOR = 1;
    private int COLUMN_FILENAME = 2;
    private int COLUMN_DATEEXECUTED = 3;
    private int COLUMN_ORDEREXECUTED = 4;
    private int COLUMN_EXECTYPE = 5;
    private int COLUMN_MD5SUM = 6;
    private int COLUMN_DESCRIPTION = 7;
    private int COLUMN_COMMENTS = 8;
    private int COLUMN_TAG = 9;
    private int COLUMN_LIQUIBASE = 10;
    private int COLUMN_CONTEXTS = 11;
    private int COLUMN_LABELS = 12;
    private int DEPLOYMENT_ID = 13;
    private Integer lastChangeSetSequenceValue;

    public OfflineChangeLogHistoryService(Database database, File changeLogFile, boolean executeDmlAgainstDatabase, boolean executeDdlAgainstDatabase) {
        this.setDatabase(database);
        this.executeDmlAgainstDatabase = executeDmlAgainstDatabase;
        this.executeDdlAgainstDatabase = executeDdlAgainstDatabase;
        this.changeLogFile = changeLogFile = changeLogFile.getAbsoluteFile();
    }

    @Override
    public int getPriority() {
        return 500;
    }

    @Override
    public boolean supports(Database database) {
        return database.getConnection() != null && database.getConnection() instanceof OfflineConnection;
    }

    public boolean isExecuteDmlAgainstDatabase() {
        return this.executeDmlAgainstDatabase;
    }

    public void setExecuteDmlAgainstDatabase(boolean executeDmlAgainstDatabase) {
        this.executeDmlAgainstDatabase = executeDmlAgainstDatabase;
    }

    public boolean isExecuteDdlAgainstDatabase() {
        return this.executeDdlAgainstDatabase;
    }

    public void setExecuteDdlAgainstDatabase(boolean executeDdlAgainstDatabase) {
        this.executeDdlAgainstDatabase = executeDdlAgainstDatabase;
    }

    @Override
    public void reset() {
    }

    @Override
    public void init() throws DatabaseException {
        if (!this.changeLogFile.exists()) {
            this.changeLogFile.getParentFile().mkdirs();
            try {
                this.changeLogFile.createNewFile();
                this.writeHeader(this.changeLogFile);
                if (this.isExecuteDdlAgainstDatabase()) {
                    ExecutorService.getInstance().getExecutor(this.getDatabase()).execute(new CreateDatabaseChangeLogTableStatement());
                }
            }
            catch (Exception e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }
    }

    protected void writeHeader(File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding());){
            CSVWriter csvWriter = new CSVWriter(writer);
            csvWriter.writeNext(new String[]{"ID", "AUTHOR", "FILENAME", "DATEEXECUTED", "ORDEREXECUTED", "EXECTYPE", "MD5SUM", "DESCRIPTION", "COMMENTS", "TAG", "LIQUIBASE", "CONTEXTS", "LABELS"});
        }
    }

    @Override
    protected void replaceChecksum(final ChangeSet changeSet) throws DatabaseException {
        if (this.isExecuteDmlAgainstDatabase()) {
            ExecutorService.getInstance().getExecutor(this.getDatabase()).execute(new UpdateChangeSetChecksumStatement(changeSet));
        }
        this.replaceChangeSet(changeSet, new ReplaceChangeSetLogic(){

            @Override
            public String[] execute(String[] line) {
                line[((OfflineChangeLogHistoryService)OfflineChangeLogHistoryService.this).COLUMN_MD5SUM] = changeSet.generateCheckSum().toString();
                return line;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<RanChangeSet> getRanChangeSets() throws DatabaseException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.changeLogFile), LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding());){
            CSVReader csvReader = new CSVReader(reader);
            String[] line = csvReader.readNext();
            if (line == null) {
                this.writeHeader(this.changeLogFile);
                ArrayList<RanChangeSet> arrayList = new ArrayList<RanChangeSet>();
                return arrayList;
            }
            if (!"ID".equals(line[this.COLUMN_ID])) {
                throw new DatabaseException("Missing header in file " + this.changeLogFile.getAbsolutePath());
            }
            ArrayList<RanChangeSet> returnList = new ArrayList<RanChangeSet>();
            while ((line = csvReader.readNext()) != null) {
                ContextExpression contexts = new ContextExpression();
                if (line.length > this.COLUMN_CONTEXTS) {
                    contexts = new ContextExpression(line[this.COLUMN_CONTEXTS]);
                }
                Labels labels = new Labels();
                if (line.length > this.COLUMN_LABELS) {
                    labels = new Labels(line[this.COLUMN_LABELS]);
                }
                String deploymentId = null;
                if (line.length > this.DEPLOYMENT_ID) {
                    deploymentId = line[this.DEPLOYMENT_ID];
                }
                returnList.add(new RanChangeSet(line[this.COLUMN_FILENAME], line[this.COLUMN_ID], line[this.COLUMN_AUTHOR], CheckSum.parse(line[this.COLUMN_MD5SUM]), new ISODateFormat().parse(line[this.COLUMN_DATEEXECUTED]), line[this.COLUMN_TAG], ChangeSet.ExecType.valueOf(line[this.COLUMN_EXECTYPE]), line[this.COLUMN_DESCRIPTION], line[this.COLUMN_COMMENTS], contexts, labels, deploymentId));
            }
            ArrayList<RanChangeSet> arrayList = returnList;
            return arrayList;
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    protected void replaceChangeSet(ChangeSet changeSet, ReplaceChangeSetLogic replaceLogic) throws DatabaseException {
        File oldFile = this.changeLogFile;
        File newFile = new File(oldFile.getParentFile(), oldFile.getName() + ".new");
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(oldFile), LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding());
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding());
             CSVReader csvReader = new CSVReader(reader);
             CSVWriter csvWriter = new CSVWriter(writer);){
            String[] line;
            while ((line = csvReader.readNext()) != null) {
                if (changeSet == null || line[this.COLUMN_ID].equals(changeSet.getId()) && line[this.COLUMN_AUTHOR].equals(changeSet.getAuthor()) && line[this.COLUMN_FILENAME].equals(changeSet.getFilePath())) {
                    line = replaceLogic.execute(line);
                }
                if (line == null) continue;
                csvWriter.writeNext(line);
            }
            oldFile.delete();
            newFile.renameTo(oldFile);
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    protected void appendChangeSet(ChangeSet changeSet, ChangeSet.ExecType execType) throws DatabaseException {
        File oldFile = this.changeLogFile;
        File newFile = new File(oldFile.getParentFile(), oldFile.getName() + ".new");
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(oldFile), LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding());
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding());
             CSVReader csvReader = new CSVReader(reader);
             CSVWriter csvWriter = new CSVWriter(writer);){
            String[] line;
            while ((line = csvReader.readNext()) != null) {
                csvWriter.writeNext(line);
            }
            String[] newLine = new String[14];
            newLine[this.COLUMN_ID] = changeSet.getId();
            newLine[this.COLUMN_AUTHOR] = changeSet.getAuthor();
            newLine[this.COLUMN_FILENAME] = changeSet.getFilePath();
            newLine[this.COLUMN_DATEEXECUTED] = new ISODateFormat().format(new Timestamp(new Date().getTime()));
            newLine[this.COLUMN_ORDEREXECUTED] = String.valueOf(this.getNextSequenceValue());
            newLine[this.COLUMN_EXECTYPE] = execType.value;
            newLine[this.COLUMN_MD5SUM] = changeSet.generateCheckSum().toString();
            newLine[this.COLUMN_DESCRIPTION] = changeSet.getDescription();
            newLine[this.COLUMN_COMMENTS] = changeSet.getComments();
            newLine[this.COLUMN_TAG] = "";
            newLine[this.COLUMN_LIQUIBASE] = LiquibaseUtil.getBuildVersion().replaceAll("SNAPSHOT", "SNP");
            if (newLine.length > 11) {
                newLine[this.COLUMN_CONTEXTS] = changeSet.getContexts() == null ? null : changeSet.getContexts().toString();
                String string = newLine[this.COLUMN_LABELS] = changeSet.getLabels() == null ? null : changeSet.getLabels().toString();
            }
            if (newLine.length > 13) {
                newLine[this.DEPLOYMENT_ID] = this.getDeploymentId();
            }
            csvWriter.writeNext(newLine);
            oldFile.delete();
            newFile.renameTo(oldFile);
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void setExecType(final ChangeSet changeSet, final ChangeSet.ExecType execType) throws DatabaseException {
        if (this.isExecuteDmlAgainstDatabase()) {
            ExecutorService.getInstance().getExecutor(this.getDatabase()).execute(new MarkChangeSetRanStatement(changeSet, execType));
            this.getDatabase().commit();
        }
        if (execType.equals((Object)ChangeSet.ExecType.FAILED) || execType.equals((Object)ChangeSet.ExecType.SKIPPED)) {
            return;
        }
        if (execType.ranBefore) {
            this.replaceChangeSet(changeSet, new ReplaceChangeSetLogic(){

                @Override
                public String[] execute(String[] line) {
                    line[((OfflineChangeLogHistoryService)OfflineChangeLogHistoryService.this).COLUMN_DATEEXECUTED] = new ISODateFormat().format(new Timestamp(new Date().getTime()));
                    line[((OfflineChangeLogHistoryService)OfflineChangeLogHistoryService.this).COLUMN_MD5SUM] = changeSet.generateCheckSum().toString();
                    line[((OfflineChangeLogHistoryService)OfflineChangeLogHistoryService.this).COLUMN_EXECTYPE] = execType.value;
                    return line;
                }
            });
        } else {
            this.appendChangeSet(changeSet, execType);
        }
    }

    @Override
    public void removeFromHistory(ChangeSet changeSet) throws DatabaseException {
        if (this.isExecuteDmlAgainstDatabase()) {
            ExecutorService.getInstance().getExecutor(this.getDatabase()).execute(new RemoveChangeSetRanStatusStatement(changeSet));
            this.getDatabase().commit();
        }
        this.replaceChangeSet(changeSet, new ReplaceChangeSetLogic(){

            @Override
            public String[] execute(String[] line) {
                return null;
            }
        });
    }

    @Override
    public int getNextSequenceValue() throws LiquibaseException {
        if (this.lastChangeSetSequenceValue == null) {
            this.lastChangeSetSequenceValue = 0;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.changeLogFile), LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding());){
                CSVReader csvReader = new CSVReader(reader);
                String[] line = csvReader.readNext();
                ArrayList returnList = new ArrayList();
                while ((line = csvReader.readNext()) != null) {
                    try {
                        this.lastChangeSetSequenceValue = Integer.valueOf(line[this.COLUMN_ORDEREXECUTED]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.lastChangeSetSequenceValue = this.lastChangeSetSequenceValue + 1;
        return this.lastChangeSetSequenceValue;
    }

    @Override
    public void tag(final String tagString) throws DatabaseException {
        RanChangeSet last = null;
        List<RanChangeSet> ranChangeSets = this.getRanChangeSets();
        if (ranChangeSets.isEmpty()) {
            ChangeSet emptyChangeSet = new ChangeSet(String.valueOf(new Date().getTime()), "liquibase", false, false, "liquibase-internal", null, null, this.getDatabase().getObjectQuotingStrategy(), null);
            this.appendChangeSet(emptyChangeSet, ChangeSet.ExecType.EXECUTED);
            last = new RanChangeSet(emptyChangeSet);
        } else {
            last = ranChangeSets.get(ranChangeSets.size() - 1);
        }
        ChangeSet lastChangeSet = new ChangeSet(last.getId(), last.getAuthor(), false, false, last.getChangeLog(), null, null, true, null, null);
        this.replaceChangeSet(lastChangeSet, new ReplaceChangeSetLogic(){

            @Override
            public String[] execute(String[] line) {
                line[((OfflineChangeLogHistoryService)OfflineChangeLogHistoryService.this).COLUMN_TAG] = tagString;
                return line;
            }
        });
    }

    @Override
    public boolean tagExists(String tag) throws DatabaseException {
        List<RanChangeSet> ranChangeSets = this.getRanChangeSets();
        for (RanChangeSet changeset : ranChangeSets) {
            if (!tag.equals(changeset.getTag())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearAllCheckSums() throws LiquibaseException {
        this.replaceChangeSet(null, new ReplaceChangeSetLogic(){

            @Override
            public String[] execute(String[] line) {
                line[((OfflineChangeLogHistoryService)OfflineChangeLogHistoryService.this).COLUMN_MD5SUM] = null;
                return line;
            }
        });
    }

    @Override
    public void destroy() throws DatabaseException {
        if (this.changeLogFile.exists() && !this.changeLogFile.delete()) {
            throw new DatabaseException("Could not delete changelog history file " + this.changeLogFile.getAbsolutePath());
        }
    }

    private static interface ReplaceChangeSetLogic {
        public String[] execute(String[] var1);
    }
}

