/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui.api;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.ui.api.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class UICommonUtils {
    private static final Logger LOG = Logger.getLogger(UICommonUtils.class.getName());

    public static FileObject[] getFileObjectsFromNodes(Node[] nodes) {
        ArrayList<FileObject> fos = new ArrayList<FileObject>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            FileObject fo;
            Node node = nodes[i];
            if (UICommonUtils.hasParentAmongNodes(nodes, i) || (fo = UICommonUtils.getFileObject(node, true)) == null) continue;
            fos.add(fo);
        }
        return fos.isEmpty() ? null : fos.toArray(new FileObject[fos.size()]);
    }

    private static boolean hasParentAmongNodes(Node[] nodes, int idx) {
        for (Node node = nodes[idx].getParentNode(); null != node; node = node.getParentNode()) {
            for (int i = 0; i < nodes.length; ++i) {
                if (i == idx || node != nodes[i]) continue;
                return true;
            }
        }
        return false;
    }

    private static FileObject getFileObject(Node node, boolean justLogIt) {
        FileObject fo = UICommonUtils.getFileObjectFromNode(node);
        if (fo == null) {
            if (justLogIt) {
                LOG.info(Bundle.MSG_file_from_node_failed(node.getDisplayName()));
            } else {
                UICommonUtils.notifyUser(Bundle.MSG_file_from_node_failed(node.getDisplayName()));
            }
            return null;
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (owner == null) {
            if (justLogIt) {
                LOG.info(Bundle.MSG_no_project(fo));
            } else {
                UICommonUtils.notifyUser(Bundle.MSG_no_project(fo));
            }
            return null;
        }
        return fo;
    }

    public static FileObject getFileObjectFromNode(Node node) {
        FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fo == null) {
            Children children = node.getChildren();
            for (Node child : children.getNodes()) {
                fo = (FileObject)child.getLookup().lookup(FileObject.class);
                if (fo == null) continue;
                return child.getDisplayName().equals("<default package>") ? fo : fo.getParent();
            }
        }
        return fo;
    }

    public static void notifyUser(String msg) {
        UICommonUtils.notifyUser(msg, 0);
    }

    public static void notifyUser(String msg, int messageType) {
        NotifyDescriptor.Message descr = new NotifyDescriptor.Message((Object)msg, messageType);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
    }
}

