/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateTime
extends AbstractExpression {
    private String identifier;

    public DateTime(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression(this.getText()));
    }

    public String getActualIdentifier() {
        return this.identifier;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("functions_returning_datetime");
    }

    @Override
    public String getText() {
        return super.getText();
    }

    public boolean isCurrentDate() {
        return this.getText() == "CURRENT_DATE";
    }

    public boolean isCurrentTime() {
        return this.getText() == "CURRENT_TIME";
    }

    public boolean isCurrentTimestamp() {
        return this.getText() == "CURRENT_TIMESTAMP";
    }

    public boolean isJDBCDate() {
        return this.getText().charAt(0) == '{';
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        if (wordParser.startsWith('{')) {
            this.parseJDBCEscapeFormat(wordParser);
        } else {
            String identifier = this.parseIdentifier(wordParser);
            this.setText(identifier);
            this.identifier = wordParser.moveForward(identifier);
        }
    }

    private String parseIdentifier(WordParser wordParser) {
        int position = wordParser.position();
        char character = wordParser.character(position + 8);
        if (character == 'd' || character == 'D') {
            return "CURRENT_DATE";
        }
        character = wordParser.character(position + 12);
        if (character == 's' || character == 'S') {
            return "CURRENT_TIMESTAMP";
        }
        return "CURRENT_TIME";
    }

    private void parseJDBCEscapeFormat(WordParser wordParser) {
        int startIndex = wordParser.position();
        int stopIndex = startIndex + 1;
        int index = startIndex + 1;
        int length = wordParser.length();
        while (index < length) {
            char character = wordParser.character(index);
            if (character == '}') {
                stopIndex = index + 1;
                break;
            }
            ++stopIndex;
            ++index;
        }
        this.setText(wordParser.substring(startIndex, stopIndex));
        wordParser.moveForward(stopIndex - startIndex);
    }

    @Override
    public String toActualText() {
        return this.getText();
    }

    @Override
    public String toParsedText() {
        return this.getText();
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual && !this.isJDBCDate() ? this.identifier : this.getText());
    }
}

