/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.netbeans.Stamps;

final class Clusters
implements Stamps.Updater {
    private static String[] dirs;
    private static String dirPrefix;
    private static final Clusters INSTANCE;

    private Clusters() {
    }

    static void scheduleSave(Stamps s) {
        s.scheduleSaveImpl(INSTANCE, "all-clusters.dat", false);
    }

    static boolean compareDirs(DataInputStream is) throws IOException {
        String[] arr;
        int cnt = is.readInt();
        if (cnt != (arr = Clusters.relativeDirsWithHome()).length) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            String cluster = is.readUTF();
            if (cluster.equals(arr[i])) continue;
            return false;
        }
        return true;
    }

    static synchronized String[] dirs() {
        if (dirs == null) {
            ArrayList<String> tmp = new ArrayList<String>();
            String nbdirs = System.getProperty("netbeans.dirs");
            if (nbdirs != null) {
                StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
                while (tok.hasMoreTokens()) {
                    tmp.add(tok.nextToken());
                }
            }
            dirs = tmp.toArray(new String[tmp.size()]);
        }
        return dirs;
    }

    static int findCommonPrefix(String s1, String s2) {
        int len = Math.min(s1.length(), s2.length());
        int max = 0;
        for (int i = 0; i < len; ++i) {
            char ch = s1.charAt(i);
            if (ch != s2.charAt(i)) {
                return max;
            }
            if (ch != '/' && ch != File.separatorChar) continue;
            max = i + 1;
        }
        return len;
    }

    static synchronized String dirPrefix() {
        if (dirPrefix == null) {
            String p = System.getProperty("netbeans.home");
            for (String d : Clusters.dirs()) {
                if (p == null) {
                    p = d;
                    continue;
                }
                int len = Clusters.findCommonPrefix(p, d);
                if (len <= 3) {
                    p = "";
                    break;
                }
                p = p.substring(0, len);
            }
            dirPrefix = p == null ? "" : p;
        }
        return dirPrefix;
    }

    static String[] relativeDirsWithHome() {
        String[] arr = Clusters.dirs();
        String[] tmp = new String[arr.length + 1];
        tmp[0] = System.getProperty("netbeans.home", "");
        if (tmp[0].length() >= Clusters.dirPrefix().length()) {
            tmp[0] = tmp[0].substring(Clusters.dirPrefix().length());
        }
        for (int i = 0; i < arr.length; ++i) {
            tmp[i + 1] = arr[i].substring(Clusters.dirPrefix().length()).replace(File.separatorChar, '/');
        }
        return tmp;
    }

    static synchronized void clear() {
        dirs = null;
        dirPrefix = null;
    }

    @Override
    public void flushCaches(DataOutputStream os) throws IOException {
        String[] arr = Clusters.relativeDirsWithHome();
        os.writeInt(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            os.writeUTF(arr[i]);
        }
    }

    @Override
    public void cacheReady() {
    }

    static {
        INSTANCE = new Clusters();
    }
}

