/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.actions;

import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.ui.CreateDatabasePanel;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;

public class CreateDatabaseAction
extends CookieAction {
    private static Logger LOGGER = Logger.getLogger(CreateDatabaseAction.class.getName());
    private static final Class[] COOKIE_CLASSES = new Class[]{DatabaseServer.class};

    public CreateDatabaseAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return Utils.getBundle().getString("LBL_CreateDatabaseAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CreateDatabaseAction.class);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        Node node = activatedNodes[0];
        DatabaseServer server = (DatabaseServer)node.getCookie(DatabaseServer.class);
        return server != null && server.isConnected();
    }

    protected int mode() {
        return 8;
    }

    protected Class<?>[] cookieClasses() {
        return COOKIE_CLASSES;
    }

    protected void performAction(Node[] activatedNodes) {
        Node node = activatedNodes[0];
        DatabaseServer server = (DatabaseServer)node.getCookie(DatabaseServer.class);
        try {
            CreateDatabasePanel panel = new CreateDatabasePanel(server);
            panel.showCreateDatabaseDialog();
        }
        catch (DatabaseException dbe) {
            Utils.displayErrorMessage(dbe.getMessage());
        }
    }
}

