/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.WebAsyncTask;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class AsyncTaskMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private final BeanFactory beanFactory;

    public AsyncTaskMethodReturnValueHandler(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        Class paramType = returnType.getParameterType();
        return WebAsyncTask.class.isAssignableFrom(paramType);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (returnValue == null) {
            mavContainer.setRequestHandled(true);
            return;
        }
        WebAsyncTask webAsyncTask = (WebAsyncTask)returnValue;
        webAsyncTask.setBeanFactory(this.beanFactory);
        WebAsyncUtils.getAsyncManager((WebRequest)webRequest).startCallableProcessing(webAsyncTask, new Object[]{mavContainer});
    }
}

