# -*- text -*-

# file stdtoolbars.inc
# This file is part of LyX, the document processor.
# Licence details can be found in the file COPYING.

# author Jean-Marc Lasgouttes
# author John Levon

# Full author contact details are available in file CREDITS.

# The interface is designed (partially) following the KDE Human Interface
# Guidelines (http://techbase.kde.org/Projects/Usability/HIG)

# Casing rules "The tooltip":
# Capitalize the first letter of the first word, and any other words normally
# capitalized in sentences, such as application names.
#
# Casing Rules for the "GUI Name":
# Capitalize all words in the element, with the following exceptions:
# * Articles: a, an, the.
# * Conjunctions: and, but, for, not, so, yet ...
# * Prepositions of three or fewer letters: at, for, by, in, to ...
#
# (http://library.gnome.org/devel/hig-book/stable/design-text-labels.html.en)

# A Toolbar starts like :
#
# Toolbar "name" "GUI Name"
#
# Only seven commands are allowed inside the Toolbar and End
# directives:
#   Item "The tooltip" "<action> [<parameter>]" adds an icon to the toolbar performing
#          "<action> <parameter>"
#      Examples:
#      Item "Small font" "font-size small"
#      Item Emphasized set-emph
#
#   Layouts adds the layouts combo-box to the toolbar
#
#   Separator adds some spacing to the toolbar
#
#   Minibuffer adds the command buffer (Qt only, only one may exist)
#
#   TableInsert "The tooltip" adds a special widget for quick insertion of tables
#
#   PopupMenu "name" "The tooltip"
#
#   ... inserts a button with a popup menu derived from Toolbar "name"
#
#   IconPalette "name" "The tooltip"
#
#   ... inserts a button with a popup iconpalette derived from Toolbar "name"
#
#
# The icons are found in the lib/images/ direcory under the name
# action.png or action_parameter.png, except for math-insert, which
# is e.g. lib/image/math/sum.png. Note that some characters are
# replaced (e.g. ')' -> rbracket).
#
#  All other lyx commands will get a "unknown" icon.
#
# This is the default toolbar:

Format 4

ToolbarSet

	Toolbar "standard" "Standard"
		Layouts
		Item "New document" "buffer-new"
		Item "Open document" "file-open"
		Item "Save document" "buffer-write"
		Separator
		Item "Check spelling" "dialog-show spellchecker"
		Item "Spellcheck continuously" "spelling-continuously"
		Separator
		Item "Undo" "undo"
		Item "Redo" "redo"
		Item "Cut" "cut"
		Item "Copy" "copy"
		Item "Paste" "paste"
		Item "Find and replace" "dialog-show findreplace"
		Item "Find and replace (advanced)" "dialog-toggle findreplaceadv"
		Item "Navigate back" "bookmark-goto 0"
		Separator
		Item "Toggle emphasis" "font-emph"
		Item "Toggle noun" "font-noun"
		Item "Apply last" "textstyle-apply"
		Separator
		Item "Insert math" "math-mode on"
		Item "Insert graphics" "dialog-show-new-inset graphics"
		TableInsert "Insert table"
		Separator
		Item "Toggle outline" "dialog-toggle toc"
		Item "Toggle math toolbar" "toolbar-toggle math"
		Item "Toggle table toolbar" "toolbar-toggle table"
		Item "Toggle review toolbar" "toolbar-toggle review"
	End

	Toolbar "view/update" "View/Update"
		Item "View" "buffer-view"
		Item "Update" "buffer-update"
		Item "View master document" "master-buffer-view"
		Item "Update master document" "master-buffer-update"
		Item "Enable Forward/Reverse Search" "buffer-toggle-output-sync"
		Separator
		StickyPopupMenu "view-others" "View other formats"
		StickyPopupMenu "update-others" "Update other formats"
	End

	Toolbar "extra" "Extra"
		Item "Default" "layout"
		Item "Numbered list" "layout Enumerate"
		Item "Itemized list" "layout Itemize"
		Item "List" "layout List"
		Item "Description" "layout Description"
		Item "Increase depth" "depth-increment"
		Item "Decrease depth" "depth-decrement"
		Separator
		Item "Insert figure float" "float-insert figure"
		Item "Insert table float" "float-insert table"
		Item "Insert label" "label-insert"
		Item "Insert cross-reference" "dialog-show-new-inset ref"
		Item "Insert citation" "dialog-show-new-inset citation"
		Item "Insert index entry" "index-insert"
		Item "Insert nomenclature entry" "nomencl-insert"
		Separator
		Item "Insert footnote" "footnote-insert"
		Item "Insert margin note" "marginalnote-insert"
		Item "Insert LyX note" "note-insert"
		Item "Insert box" "box-insert Frameless"
		Item "Insert hyperlink" "href-insert"
		Item "Insert TeX code" "ert-insert"
		Item "Insert math macro" "math-macro newmacroname newcommand"
		Item "Include file" "dialog-show-new-inset include"
		Separator
		Item "Text style" "dialog-show character"
		Item "Paragraph settings" "layout-paragraph"
		Item "Thesaurus" "thesaurus-entry"
	End

	Toolbar "table" "Table"
		Item "Add row" "tabular-feature append-row"
		Item "Add column" "tabular-feature append-column"
		Item "Delete row" "tabular-feature delete-row"
		Item "Delete column" "tabular-feature delete-column"
		Item "Move row up" "tabular-feature move-row-up"
		Item "Move column left" "tabular-feature move-column-left"
		Item "Move row down" "tabular-feature move-row-down"
		Item "Move column right" "tabular-feature move-column-right"
		Separator
		Item "Set top line" "tabular-feature toggle-line-top"
		Item "Set bottom line" "tabular-feature toggle-line-bottom"
		Item "Set left line" "tabular-feature toggle-line-left"
		Item "Set right line" "tabular-feature toggle-line-right"
		Item "Set border lines" "tabular-feature set-border-lines"
		Item "Set all lines" "tabular-feature set-all-lines"
		Item "Unset all lines" "tabular-feature unset-all-lines"
		Separator
		Item "Align left" "command-alternatives tabular-feature m-align-left;tabular-feature align-left"
		Item "Align center" "command-alternatives tabular-feature m-align-center;tabular-feature align-center"
		Item "Align right" "command-alternatives tabular-feature m-align-right;tabular-feature align-right"
		Item "Align on decimal" "tabular-feature align-decimal"
		Separator
		Item "Align top" "command-alternatives tabular-feature m-valign-top;tabular-feature valign-top"
		Item "Align middle" "command-alternatives tabular-feature m-valign-middle;tabular-feature valign-middle"
		Item "Align bottom" "command-alternatives tabular-feature m-valign-bottom;tabular-feature valign-bottom"
		Separator
		Item "Rotate cell by 90 degrees or unset rotation" "tabular-feature toggle-rotate-cell"
		Item "Rotate table by 90 degrees or unset rotation" "tabular-feature toggle-rotate-tabular"
		Item "Set multi-column" "tabular-feature multicolumn"
		Item "Set multi-row" "tabular-feature multirow"
	End

	Toolbar "math" "Math"
		Item "Set display mode" "math-display"
		Separator
		Item "Subscript" "math-subscript"
		Item "Superscript" "math-superscript"
		Item "Insert square root" "math-insert \sqrt"
		Item "Insert root" "math-insert \root"
		Item "Insert standard fraction" "math-insert \frac"
		Item "Insert sum" "math-insert \sum"
		Item "Insert integral" "math-insert \int"
		Item "Insert product" "math-insert \prod"
		Separator
		Item "Insert ( )" "math-delim ( )"
		Item "Insert [ ]" "math-delim [ ]"
		Item "Insert { }" "math-delim { }"
		Item "Insert delimiters" "dialog-show mathdelimiter"
		Separator
		Item "Insert matrix" "dialog-show mathmatrix"
		Item "Insert cases environment" "math-insert \cases"
		Item "Add row" "tabular-feature append-row"
		Item "Add column" "tabular-feature append-column"
		Item "Delete row" "tabular-feature delete-row"
		Item "Delete column" "tabular-feature delete-column"
		Separator
		Item "Toggle math panels" "toolbar-toggle math_panels"
	End

	Toolbar "mathmacrotemplate" "Math Macros"
		Item "Remove last argument" "math-macro-remove-param"
		Item "Append argument" "math-macro-add-param"
		Separator
		Item "Make first non-optional into optional argument" "math-macro-make-optional"
		Item "Make last optional into non-optional argument"
		"math-macro-make-nonoptional"
		Item "Remove optional argument" "math-macro-remove-optional-param"
		Item "Insert optional argument" "math-macro-add-optional-param"
		Separator
		Item "Remove last argument spitting out to the right" "math-macro-remove-greedy-param"
		Item "Append argument eating from the right" "math-macro-append-greedy-param"
		Item "Append optional argument eating from the right" "math-macro-add-greedy-optional-param"
	End

	Toolbar "ipa" "Phonetic Symbols"
		IconPalette "ipa_pulmonic" "IPA Pulmonic Consonants"
		IconPalette "ipa_nonpulmonic" "IPA Non-Pulmonic Consonants"
		IconPalette "ipa_vowels" "IPA Vowels"
		IconPalette "ipa_others" "IPA Other Symbols"
		IconPalette "ipa_suprasegmentals" "IPA Suprasegmentals"
		IconPalette "ipa_diacritics" "IPA Diacritics"
		IconPalette "ipa_accents" "IPA Tones and Word Accents"
	End

	Toolbar "minibuffer" "Command Buffer"
		Minibuffer
	End

	Toolbar "review" "Review[[Toolbar]]"
		Item "Track changes" "changes-track"
		Item "Show changes in output" "changes-output"
		Separator
		Item "Next change" "change-next"
		Item "Accept change inside selection" "change-accept"
		Item "Reject change inside selection" "change-reject"
		Separator
		Item "Merge changes" "changes-merge"
		Item "Accept all changes" "all-changes-accept"
		Item "Reject all changes" "all-changes-reject"
		Separator
		Item "Insert note" "note-insert"
		Item "Next note" "note-next"
	End

	Toolbar "documentation" "LyX Documentation Tools"
		Item "Info" "info-insert"
		Item "Menu Separator" "specialchar-insert menu-separator"
		Separator
		Item "LyX Logo" "specialchar-insert lyx"
		Item "TeX Logo" "specialchar-insert tex"
		Item "LaTeX Logo" "specialchar-insert latex"
		Item "LaTeX2e Logo" "specialchar-insert latex2e"
	End

	Toolbar "view-others" "View Other Formats"
		ViewFormats
	End

	Toolbar "update-others" "Update Other Formats"
		UpdateFormats
	End

# The following three toolbars are disabled because of missing icons.
#	Toolbar "import/export" "Import/Export"
#		Item "Import" "buffer-import"
#		Item "Export" "buffer-export"
#		StickyPopupMenu "import-others" "Import other formats"
#		StickyPopupMenu "export-others" "Export other formats"
#	End

#	Toolbar "import-others" "Import Other Formats"
#		ImportFormats
#	End

#	Toolbar "export-others" "Export Other Formats"
#		ExportFormats
#	End

	Toolbar "vcs" "Version Control"
		Item "Register" "vc-register"
		Item "Check-out for edit" "vc-check-out"
		Item "Check-in changes" "vc-check-in"
		Item "View revision log" "dialog-show vclog"
		Item "Revert changes" "vc-revert"
		Item "Compare with older revision" "vc-compare"
		Item "Compare with last revision" "vc-compare 0"
		Item "Insert Version Info" "info-insert buffer vcs-revision"
		Separator
		Item "Use SVN file locking property" "vc-locking-toggle"
		Separator
		Item "Update local directory from repository" "vc-repo-update"
	End

	Toolbar "math_panels" "Math Panels"
		PopupMenu "space" "Math spacings"
		PopupMenu "style" "Styles & classes"
		PopupMenu "frac-square" "Fractions"
		PopupMenu "font" "Fonts"
		PopupMenu "functions" "Functions"
		IconPalette "latex_deco" "Frame decorations"
		IconPalette "latex_varsz" "Big operators"
		IconPalette "latex_misc" "Miscellaneous"
		IconPalette "latex_greek" "Greek"
		IconPalette "latex_arrow" "Arrows"
		IconPalette "latex_ams_arrows" "Arrows (extended)"
		IconPalette "latex_bop" "Operators"
		IconPalette "latex_ams_ops" "Operators (extended)"
		IconPalette "latex_brel" "Relations"
		IconPalette "latex_ams_rel" "Relations (extended)"
		IconPalette "latex_ams_nrel" "Negative relations (extended)"
		IconPalette "latex_dots" "Dots"
		IconPalette "latex_delim" "Delimiters (fixed size)"
		IconPalette "latex_ams_misc" "Miscellaneous (extended)"
	End

	Toolbar "functions" "Functions"
		Item "arccos" "math-insert \arccos"
		Item "arcsin" "math-insert \arcsin"
		Item "arctan" "math-insert \arctan"
		Item "arg" "math-insert \arg"
		Item "bmod" "math-insert \bmod"
		Item "cos" "math-insert \cos"
		Item "cosh" "math-insert \cosh"
		Item "cot" "math-insert \cot"
		Item "coth" "math-insert \coth"
		Item "csc" "math-insert \csc"
		Item "deg" "math-insert \deg"
		Item "det" "math-insert \det"
		Item "dim" "math-insert \dim"
		Item "exp" "math-insert \exp"
		Item "gcd" "math-insert \gcd"
		Item "hom" "math-insert \hom"
		Item "inf" "math-insert \inf"
		Item "ker" "math-insert \ker"
		Item "lg" "math-insert \lg"
		Item "lim" "math-insert \lim"
		Item "liminf" "math-insert \liminf"
		Item "limsup" "math-insert \limsup"
		Item "ln" "math-insert \ln"
		Item "log" "math-insert \log"
		Item "max" "math-insert \max"
		Item "min" "math-insert \min"
		Item "sec" "math-insert \sec"
		Item "sin" "math-insert \sin"
		Item "sinh" "math-insert \sinh"
		Item "sup" "math-insert \sup"
		Item "tan" "math-insert \tan"
		Item "tanh" "math-insert \tanh"
		Item "Pr" "math-insert \Pr"
	End

	Toolbar "space" "Spacings"
		Item "Thin space	\\," "math-insert \,"
		Item "Medium space	\\:" "math-insert \:"
		Item "Thick space	\\;" "math-insert \;"
		Item "Quadratin space	\\quad" "math-insert \quad"
		Item "Double quadratin space	\\qquad" "math-insert \qquad"
		Item "Negative space	\\!" "math-insert \!"
		Item "Phantom	\\phantom" "math-insert \phantom"
		Item "Horizontal phantom	\\hphantom" "math-insert \hphantom"
		Item "Vertical phantom	\\vphantom" "math-insert \vphantom"
		Item "Smash	\\smash" "math-insert \smash"
		Item "Top smash	\\smasht" "math-insert \smasht"
		Item "Bottom smash	\\smashb" "math-insert \smashb"
		Item "Left overlap	\\mathllap" "math-insert \mathllap"
		Item "Center overlap	\\mathclap" "math-insert \mathclap"
		Item "Right overlap	\\mathrlap" "math-insert \mathrlap"
	End

	Toolbar "sqrt-square" "Roots"
		Item "Square root	\\sqrt" "math-insert \sqrt"
		Item "Other root	\\root" "math-insert \root"
	End

	Toolbar "style" "Styles & Classes"
		Item "Display style	\\displaystyle" "math-size \displaystyle"
		Item "Normal text style	\\textstyle" "math-size \textstyle"
		Item "Script (small) style	\\scriptstyle" "math-size \scriptstyle"
		Item "Scriptscript (smaller) style	\\scriptscriptstyle" "math-size \scriptscriptstyle"
		Item "Relation class	\\mathrel" "math-insert \mathrel"
		Item "Binary operator class	\\mathbin" "math-insert \mathbin"
		Item "Large operator class	\\mathop" "math-insert \mathop"
		Item "Ordinary class	\\mathord" "math-insert \mathord"
	End

	Toolbar "frac-square" "Fractions"
		Item "Standard	\\frac" "math-insert \frac"
		Item "Nice fraction (3/4)	\\nicefrac" "math-insert \nicefrac"
		Item "Unit (km)	\\unitone" "math-insert \unitone"
		Item "Unit (864 m)	\\unittwo" "math-insert \unittwo"
		Item "Unit fraction (km/h)	\\unitfrac" "math-insert \unitfrac"
		Item "Unit fraction (20 km/h)	\\unitfracthree" "math-insert \unitfracthree"
		Item "Text fraction	\\tfrac" "math-insert \tfrac"
		Item "Display fraction	\\dfrac" "math-insert \dfrac"
		Item "Continued fraction	\\cfrac" "math-insert \cfrac"
		Item "Continued fraction (left)	\\cfracleft" "math-insert \cfracleft"
		Item "Continued fraction (right)	\\cfracright" "math-insert \cfracright"
		Item "Binomial	\\binom" "math-insert \binom"
		Item "Text binomial	\\tbinom" "math-insert \tbinom"
		Item "Display binomial	\\dbinom" "math-insert \dbinom"
	End

	Toolbar "font" "Fonts"
		Item "Roman	\\mathrm" "math-insert \mathrm"
		Item "Bold	\\mathbf" "math-insert \mathbf"
		Item "Bold symbol	\\boldsymbol" "math-insert \boldsymbol"
		Item "Sans serif	\\mathsf" "math-insert \mathsf"
		Item "Italic	\\mathit" "math-insert \mathit"
		Item "Typewriter	\\mathtt" "math-insert \mathtt"
		Item "Blackboard	\\mathbb" "math-insert \mathbb"
		Item "Fraktur	\\mathfrak" "math-insert \mathfrak"
		Item "Calligraphic	\\mathcal" "math-insert \mathcal"
		Item "Formal Script	\\mathscr" "math-insert \mathscr"
		Item "Normal text mode	\\textrm" "math-insert \textrm"
	End

	Toolbar "latex_dots" "Dots"
		Item "ldots" "math-insert \ldots"
		Item "cdots" "math-insert \cdots"
		Item "vdots" "math-insert \vdots"
		Item "ddots" "math-insert \ddots"
		Item "iddots" "math-insert \iddots"
#		Item "adots" "math-insert \adots" # identical to idots, idots has better dependencies
#		Item "dotsb" "math-insert \dotsb"
#		Item "dotsc" "math-insert \dotsc"
#		Item "dotsi" "math-insert \dotsi"
#		Item "dotsm" "math-insert \dotsm"
#		Item "dotso" "math-insert \dotso"
#		Item "dots" "math-insert \dots"
	End

	Toolbar "latex_deco" "Frame Decorations"
		Item "hat" "math-insert \hat"
		Item "tilde" "math-insert \tilde"
		Item "bar" "math-insert \bar"
		Item "grave" "math-insert \grave"
		Item "dot" "math-insert \dot"
		Item "check" "math-insert \check"
		Item "widehat" "math-insert \widehat"
		Item "widetilde" "math-insert \widetilde"
		Item "utilde" "math-insert \utilde"
		Item "vec" "math-insert \vec"
		Item "acute" "math-insert \acute"
		Item "ddot" "math-insert \ddot"
		Item "dddot" "math-insert \dddot"
		Item "ddddot" "math-insert \ddddot"
		Item "breve" "math-insert \breve"
		Item "mathring" "math-insert \mathring"
		Item "overline" "math-insert \overline"
		Item "overbrace" "math-insert \overbrace"
		Item "overleftarrow" "math-insert \overleftarrow"
		Item "overrightarrow" "math-insert \overrightarrow"
		Item "overleftrightarrow" "math-insert \overleftrightarrow"
		Item "underline" "math-insert \underline"
#		Item "underbar" "math-insert \underbar" # switches to text mode, strikes through underlengths
		Item "underbrace" "math-insert \underbrace"
#		Item "undertilde" "math-insert \undertilde" # problematic dependencies (see lib/symbols)
		Item "underleftarrow" "math-insert \underleftarrow"
		Item "underrightarrow" "math-insert \underrightarrow"
		Item "underleftrightarrow" "math-insert \underleftrightarrow"
		Item "cancel" "math-insert \cancel"
		Item "bcancel" "math-insert \bcancel"
		Item "xcancel" "math-insert \xcancel"
		Item "cancelto" "math-insert \cancelto"
		Item "Insert left/right side scripts (sideset)" "math-insert \sideset"
		Item "Insert right side scripts (sidesetr)" "math-insert \sidesetr"
		Item "Insert left side scripts (sidesetl)" "math-insert \sidesetl"
		Item "Insert side scripts (sidesetn)" "math-insert \sidesetn"
		Item "overset" "math-insert \overset"
		Item "underset" "math-insert \underset"
		Item "stackrel" "math-insert \stackrel"
		Item "stackrelthree" "math-insert \stackrelthree"
	End

	Toolbar "latex_arrow" "Arrows"
		Item "leftarrow" "math-insert \leftarrow"
#		Item "gets" "math-insert \gets" # same as leftarrow
		Item "rightarrow" "math-insert \rightarrow"
#		Item "to" "math-insert \to" # same as rightarrow
		Item "downarrow" "math-insert \downarrow"
		Item "uparrow" "math-insert \uparrow"
		Item "updownarrow" "math-insert \updownarrow"
		Item "leftrightarrow" "math-insert \leftrightarrow"
		Item "Leftarrow" "math-insert \Leftarrow"
		Item "Rightarrow" "math-insert \Rightarrow"
		Item "Downarrow" "math-insert \Downarrow"
		Item "Uparrow" "math-insert \Uparrow"
		Item "Updownarrow" "math-insert \Updownarrow"
		Item "Leftrightarrow" "math-insert \Leftrightarrow"
		Item "Longleftrightarrow" "math-insert \Longleftrightarrow"
		Item "Longleftarrow" "math-insert \Longleftarrow"
		Item "Longrightarrow" "math-insert \Longrightarrow"
		Item "longleftrightarrow" "math-insert \longleftrightarrow"
		Item "longleftarrow" "math-insert \longleftarrow"
		Item "longrightarrow" "math-insert \longrightarrow"
		Item "leftharpoondown" "math-insert \leftharpoondown"
		Item "rightharpoondown" "math-insert \rightharpoondown"
		Item "mapsto" "math-insert \mapsto"
		Item "longmapsto" "math-insert \longmapsto"
		Item "nwarrow" "math-insert \nwarrow"
		Item "nearrow" "math-insert \nearrow"
		Item "leftharpoonup" "math-insert \leftharpoonup"
		Item "rightharpoonup" "math-insert \rightharpoonup"
		Item "hookleftarrow" "math-insert \hookleftarrow"
		Item "hookrightarrow" "math-insert \hookrightarrow"
		Item "swarrow" "math-insert \swarrow"
		Item "searrow" "math-insert \searrow"
		Item "rightleftharpoons" "math-insert \rightleftharpoons"
#		Item "arrowvert" "math-insert \arrowvert" # not really an arrow
#		Item "Arrowvert" "math-insert \Arrowvert" # not really an arrow
	End

	Toolbar "latex_bop" "Operators"
		Item "pm" "math-insert \pm"
		Item "cap" "math-insert \cap"
		Item "diamond" "math-insert \diamond"
		Item "oplus" "math-insert \oplus"
		Item "mp" "math-insert \mp"
		Item "cup" "math-insert \cup"
		Item "bigtriangleup" "math-insert \bigtriangleup"
		Item "ominus" "math-insert \ominus"
		Item "times" "math-insert \times"
		Item "uplus" "math-insert \uplus"
		Item "bigtriangledown" "math-insert \bigtriangledown"
		Item "otimes" "math-insert \otimes"
		Item "div" "math-insert \div"
		Item "sqcap" "math-insert \sqcap"
		Item "triangleright" "math-insert \triangleright"
		Item "oslash" "math-insert \oslash"
		Item "cdot" "math-insert \cdot"
		Item "sqcup" "math-insert \sqcup"
		Item "triangleleft" "math-insert \triangleleft"
		Item "odot" "math-insert \odot"
		Item "star" "math-insert \star"
		Item "ast" "math-insert \ast"
		Item "vee" "math-insert \vee"
		Item "amalg" "math-insert \amalg"
		Item "bigcirc" "math-insert \bigcirc"
		Item "setminus" "math-insert \setminus"
		Item "wedge" "math-insert \wedge"
		Item "dagger" "math-insert \dagger"
		Item "circ" "math-insert \circ"
		Item "bullet" "math-insert \bullet"
		Item "wr" "math-insert \wr"
		Item "ddagger" "math-insert \ddagger"
		Item "smallint" "math-insert \smallint"
	End

	Toolbar "latex_brel" "Relations"
		Item "leq" "math-insert \leq"
#		Item "le" "math-insert \le" # same as leq
		Item "geq" "math-insert \geq"
#		Item "ge" "math-insert \ge" # same a geq
		Item "equiv" "math-insert \equiv"
		Item "models" "math-insert \models"
		Item "prec" "math-insert \prec"
		Item "succ" "math-insert \succ"
		Item "sim" "math-insert \sim"
		Item "perp" "math-insert \perp"
		Item "preceq" "math-insert \preceq"
		Item "succeq" "math-insert \succeq"
		Item "simeq" "math-insert \simeq"
		Item "mid" "math-insert \mid"
		Item "ll" "math-insert \ll"
		Item "gg" "math-insert \gg"
		Item "asymp" "math-insert \asymp"
		Item "parallel" "math-insert \parallel"
		Item "subset" "math-insert \subset"
		Item "supset" "math-insert \supset"
		Item "approx" "math-insert \approx"
		Item "smile" "math-insert \smile"
		Item "subseteq" "math-insert \subseteq"
		Item "supseteq" "math-insert \supseteq"
		Item "cong" "math-insert \cong"
		Item "frown" "math-insert \frown"
		Item "sqsubseteq" "math-insert \sqsubseteq"
		Item "sqsupseteq" "math-insert \sqsupseteq"
		Item "doteq" "math-insert \doteq"
		Item "neq" "math-insert \neq"
#		Item "ne" "math-insert \ne" # same as neq
		Item "in[[math relation]]" "math-insert \in"
		Item "ni" "math-insert \ni"
#		Item "owns" "math-insert \owns" # same as ni
		Item "propto" "math-insert \propto"
		Item "notin" "math-insert \notin"
		Item "vdash" "math-insert \vdash"
		Item "dashv" "math-insert \dashv"
		Item "bowtie" "math-insert \bowtie"
		Item "iff" "math-insert \iff"
		Item "not" "math-insert \not"
		Item "land" "math-insert \land"
		Item "lor" "math-insert \lor"
		Item "lnot" "math-insert \lnot"
	End

	Toolbar "latex_greek" "Greek"
		Item "alpha" "math-insert \alpha"
		Item "beta" "math-insert \beta"
		Item "gamma" "math-insert \gamma"
		Item "delta" "math-insert \delta"
		Item "epsilon" "math-insert \epsilon"
		Item "varepsilon" "math-insert \varepsilon"
		Item "zeta" "math-insert \zeta"
		Item "eta" "math-insert \eta"
		Item "theta" "math-insert \theta"
		Item "vartheta" "math-insert \vartheta"
		Item "iota" "math-insert \iota"
		Item "kappa" "math-insert \kappa"
		Item "lambda" "math-insert \lambda"
		Item "mu" "math-insert \mu"
		Item "nu" "math-insert \nu"
		Item "xi" "math-insert \xi"
		Item "pi" "math-insert \pi"
		Item "varpi" "math-insert \varpi"
		Item "rho" "math-insert \rho"
		Item "varrho" "math-insert \varrho"
		Item "sigma" "math-insert \sigma"
		Item "varsigma" "math-insert \varsigma"
		Item "tau" "math-insert \tau"
		Item "upsilon" "math-insert \upsilon"
		Item "phi" "math-insert \phi"
		Item "varphi" "math-insert \varphi"
		Item "chi" "math-insert \chi"
		Item "psi" "math-insert \psi"
		Item "omega" "math-insert \omega"
		Item "Gamma" "math-insert \Gamma"
		Item "Delta" "math-insert \Delta"
		Item "Theta" "math-insert \Theta"
		Item "Lambda" "math-insert \Lambda"
		Item "Xi" "math-insert \Xi"
		Item "Pi" "math-insert \Pi"
		Item "Sigma" "math-insert \Sigma"
		Item "Upsilon" "math-insert \Upsilon"
		Item "Phi" "math-insert \Phi"
		Item "Psi" "math-insert \Psi"
		Item "Omega" "math-insert \Omega"
		Item "varGamma" "math-insert \varGamma"
		Item "varDelta" "math-insert \varDelta"
		Item "varTheta" "math-insert \varTheta"
		Item "varLambda" "math-insert \varLambda"
		Item "varXi" "math-insert \varXi"
		Item "varPi" "math-insert \varPi"
		Item "varSigma" "math-insert \varSigma"
		Item "varUpsilon" "math-insert \varUpsilon"
		Item "varPhi" "math-insert \varPhi"
		Item "varPsi" "math-insert \varPsi"
		Item "varOmega" "math-insert \varOmega"
	End

	Toolbar "latex_misc" "Miscellaneous"
		Item "nabla" "math-insert \nabla"
		Item "partial" "math-insert \partial"
		Item "infty" "math-insert \infty"
		Item "prime" "math-insert \prime"
		Item "ell" "math-insert \ell"
		Item "emptyset" "math-insert \emptyset"
		Item "exists" "math-insert \exists"
		Item "forall" "math-insert \forall"
		Item "imath" "math-insert \imath"
		Item "jmath" "math-insert \jmath"
		Item "Re" "math-insert \Re"
		Item "Im" "math-insert \Im"
		Item "aleph" "math-insert \aleph"
		Item "wp" "math-insert \wp"
		Item "hbar" "math-insert \hbar"
		Item "angle" "math-insert \angle"
		Item "top" "math-insert \top"
		Item "bot" "math-insert \bot"
		Item "Vert" "math-insert \Vert"
		Item "neg" "math-insert \neg"
		Item "flat" "math-insert \flat"
		Item "natural" "math-insert \natural"
		Item "sharp" "math-insert \sharp"
		Item "surd" "math-insert \surd"
		Item "lhook" "math-insert \lhook"
		Item "rhook" "math-insert \rhook"
		Item "triangle" "math-insert \triangle"
		Item "diamondsuit" "math-insert \diamondsuit"
		Item "heartsuit" "math-insert \heartsuit"
		Item "clubsuit" "math-insert \clubsuit"
		Item "spadesuit" "math-insert \spadesuit"
		Item "textrm \\AA" "math-insert \textrm \AA"
		Item "textrm \\O" "math-insert \textrm \O"
		Item "mathcircumflex" "math-insert \mathcircumflex"
		Item "_" "math-insert \_"
		Item "textdegree" "math-insert \textdegree"
		Item "mathdollar" "math-insert \mathdollar"
		Item "mathparagraph" "math-insert \mathparagraph"
		Item "mathsection" "math-insert \mathsection"
		Item "mathrm T" "math-insert \mathrm T"
		Item "mathbb N" "math-insert \mathbb N"
		Item "mathbb Z" "math-insert \mathbb Z"
		Item "mathbb Q" "math-insert \mathbb Q"
		Item "mathbb R" "math-insert \mathbb R"
		Item "mathbb C" "math-insert \mathbb C"
		Item "mathbb H" "math-insert \mathbb H"
		Item "mathcal F" "math-insert \mathcal F"
		Item "mathcal L" "math-insert \mathcal L"
		Item "mathcal H" "math-insert \mathcal H"
		Item "mathcal O" "math-insert \mathcal O"
	End

	Toolbar "latex_varsz" "Big Operators"
		Item "intop" "math-insert \intop"
		Item "int" "math-insert \int"
		Item "iint" "math-insert \iint"
		Item "iintop" "math-insert \iintop"
		Item "iiint" "math-insert \iiint"
		Item "iiintop" "math-insert \iiintop"
		Item "iiiint" "math-insert \iiiint"
		Item "iiiintop" "math-insert \iiiintop"
		Item "dotsint" "math-insert \dotsint"
		Item "dotsintop" "math-insert \dotsintop"
		Item "idotsint" "math-insert \idotsint"
		Item "oint" "math-insert \oint"
		Item "ointop" "math-insert \ointop"
		Item "oiint" "math-insert \oiint"
		Item "oiintop" "math-insert \oiintop"
		Item "ointctrclockwiseop" "math-insert \ointctrclockwiseop"
		Item "ointctrclockwise" "math-insert \ointctrclockwise"
		Item "ointclockwiseop" "math-insert \ointclockwiseop"
		Item "ointclockwise" "math-insert \ointclockwise"
		Item "sqint" "math-insert \sqint"
		Item "sqintop" "math-insert \sqintop"
		Item "sqiint" "math-insert \sqiint"
		Item "sqiintop" "math-insert \sqiintop"
		Item "fint" "math-insert \fint"
		Item "fintop" "math-insert \fintop"
		Item "landupint" "math-insert \landupint"
		Item "landupintop" "math-insert \landupintop"
		Item "landdownint" "math-insert \landdownint"
		Item "landdownintop" "math-insert \landdownintop"
		Item "varint" "math-insert \varint"
		Item "varoint" "math-insert \varoint"
		Item "varoiint" "math-insert \varoiint"
		Item "varoiintop" "math-insert \varoiintop"
		Item "varointclockwise" "math-insert \varointclockwise"
		Item "varointclockwiseop" "math-insert \varointclockwiseop"
		Item "varointctrclockwise" "math-insert \varointctrclockwise"
		Item "varointctrclockwiseop" "math-insert \varointctrclockwiseop"
		Item "sum" "math-insert \sum"
		Item "prod" "math-insert \prod"
		Item "coprod" "math-insert \coprod"
		Item "bigsqcup" "math-insert \bigsqcup"
		Item "bigotimes" "math-insert \bigotimes"
		Item "bigodot" "math-insert \bigodot"
		Item "bigoplus" "math-insert \bigoplus"
		Item "bigcap" "math-insert \bigcap"
		Item "bigcup" "math-insert \bigcup"
		Item "biguplus" "math-insert \biguplus"
		Item "bigvee" "math-insert \bigvee"
		Item "bigwedge" "math-insert \bigwedge"
	End

	Toolbar "latex_ams_misc" "Miscellaneous (extended)"
		Item "digamma" "math-insert \digamma"
		Item "varkappa" "math-insert \varkappa"
		Item "beth" "math-insert \beth"
		Item "daleth" "math-insert \daleth"
		Item "gimel" "math-insert \gimel"
		Item "ulcorner" "math-insert \ulcorner"
		Item "urcorner" "math-insert \urcorner"
		Item "llcorner" "math-insert \llcorner"
		Item "lrcorner" "math-insert \lrcorner"
		Item "hbar" "math-insert \hbar"
		Item "hslash" "math-insert \hslash"
		Item "vartriangle" "math-insert \vartriangle"
		Item "triangledown" "math-insert \triangledown"
		Item "square" "math-insert \square"
#		Item "Box" "math-insert \Box" # same as square
		Item "Square" "math-insert \Square"
		Item "CheckedBox" "math-insert \CheckedBox"
		Item "XBox" "math-insert \XBox"
		Item "lozenge" "math-insert \lozenge"
		Item "wasylozenge" "math-insert \wasylozenge"
		Item "circledR" "math-insert \circledR"
		Item "circledS" "math-insert \circledS"
		Item "measuredangle" "math-insert \measuredangle"
		Item "varangle" "math-insert \varangle"
		Item "nexists" "math-insert \nexists"
		Item "mho" "math-insert \mho"
		Item "Finv" "math-insert \Finv"
		Item "Game" "math-insert \Game"
		Item "Bbbk" "math-insert \Bbbk"
		Item "backprime" "math-insert \backprime"
		Item "varnothing" "math-insert \varnothing"
#		Item "Diamond" "math-insert \Diamond" # same as lozenge
		Item "blacktriangle" "math-insert \blacktriangle"
		Item "blacktriangledown" "math-insert \blacktriangledown"
		Item "blacksquare" "math-insert \blacksquare"
		Item "blacklozenge" "math-insert \blacklozenge"
		Item "bigstar" "math-insert \bigstar"
		Item "sphericalangle" "math-insert \sphericalangle"
		Item "complement" "math-insert \complement"
		Item "eth" "math-insert \eth"
		Item "diagup" "math-insert \diagup"
		Item "diagdown" "math-insert \diagdown"
		Item "lightning" "math-insert \lightning"
		Item "varcopyright" "math-insert \varcopyright"
		Item "Bowtie" "math-insert \Bowtie"
		Item "diameter" "math-insert \diameter"
		Item "invdiameter" "math-insert \invdiameter"
		Item "bell" "math-insert \bell"
		Item "hexagon" "math-insert \hexagon"
		Item "varhexagon" "math-insert \varhexagon"
		Item "pentagon" "math-insert \pentagon"
		Item "octagon" "math-insert \octagon"
#		Item "pointer" "math-insert \pointer" # works in text mode only (produces \Psi in math mode)
#		Item "thorn" "math-insert \thorn" # works in text mode only (produces i in math mode)
#		Item "Thorn" "math-insert \Thorn" # works in text mode only (produces j in math mode)
#		Item "agemO" "math-insert \agemO" # works in text mode only (produces 0 in math mode)
#		Item "phone" "math-insert \phone" # works in text mode only (produces \Upsilon in math mode)
#		Item "recorder" "math-insert \recorder" # works in text mode only (produces \Sigma in math mode)
#		Item "clock" "math-insert \clock" # works in text mode only (produces \o in math mode)
		Item "smiley" "math-insert \smiley"
		Item "blacksmiley" "math-insert \blacksmiley"
		Item "frownie" "math-insert \frownie"
		Item "sun" "math-insert \sun"
		Item "leadsto" "math-insert \leadsto"
		Item "Circle" "math-insert \Circle"
		Item "Leftcircle" "math-insert \Leftcircle"
		Item "Rightcircle" "math-insert \Rightcircle"
		Item "CIRCLE" "math-insert \CIRCLE"
		Item "LEFTCIRCLE" "math-insert \LEFTCIRCLE"
		Item "RIGHTCIRCLE" "math-insert \RIGHTCIRCLE"
		Item "LEFTcircle" "math-insert \LEFTcircle"
		Item "RIGHTcircle" "math-insert \RIGHTcircle"
		Item "leftturn" "math-insert \leftturn"
		Item "rightturn" "math-insert \rightturn"
		Item "AC" "math-insert \AC"
		Item "HF" "math-insert \HF"
		Item "VHF" "math-insert \VHF"
		Item "photon" "math-insert \photon"
		Item "gluon" "math-insert \gluon"
		Item "permil" "math-insert \permil"
#		Item "currency" "math-insert \currency" # works in text mode only (produces \oe in math mode)
		Item "cent" "math-insert \cent"
		Item "yen" "math-insert \yen"
#		Item "openo" "math-insert \openo" # works in text mode only (produces l in math mode)
#		Item "inve" "math-insert \inve" # works in text mode only (produces U in math mode)
		Item "hexstar" "math-insert \hexstar"
		Item "varhexstar" "math-insert \varhexstar"
		Item "davidsstar" "math-insert \davidsstar"
		Item "maltese" "math-insert \maltese"
		Item "kreuz" "math-insert \kreuz"
		Item "ataribox" "math-insert \ataribox"
		Item "XBox" "math-insert \XBox"
		Item "checked" "math-insert \checked"
		Item "checkmark" "math-insert \checkmark"
		Item "eighthnote" "math-insert \eighthnote"
		Item "quarternote" "math-insert \quarternote"
		Item "halfnote" "math-insert \halfnote"
		Item "fullnote" "math-insert \fullnote"
		Item "twonotes" "math-insert \twonotes"
		Item "female" "math-insert \female"
		Item "male" "math-insert \male"
		Item "vernal" "math-insert \vernal"
		Item "ascnode" "math-insert \ascnode"
		Item "descnode" "math-insert \descnode"
		Item "fullmoon" "math-insert \fullmoon"
		Item "newmoon" "math-insert \newmoon"
		Item "leftmoon" "math-insert \leftmoon"
		Item "rightmoon" "math-insert \rightmoon"
		Item "astrosun" "math-insert \astrosun"
		Item "mercury" "math-insert \mercury"
		Item "venus" "math-insert \venus"
		Item "earth" "math-insert \earth"
		Item "mars" "math-insert \mars"
		Item "jupiter" "math-insert \jupiter"
		Item "saturn" "math-insert \saturn"
		Item "uranus" "math-insert \uranus"
		Item "neptune" "math-insert \neptune"
		Item "pluto" "math-insert \pluto"
		Item "aries" "math-insert \aries"
		Item "taurus" "math-insert \taurus"
		Item "gemini" "math-insert \gemini"
		Item "cancer" "math-insert \cancer"
		Item "leo" "math-insert \leo"
		Item "virgo" "math-insert \virgo"
		Item "libra" "math-insert \libra"
		Item "scorpio" "math-insert \scorpio"
		Item "sagittarius" "math-insert \sagittarius"
		Item "capricornus" "math-insert \capricornus"
		Item "aquarius" "math-insert \aquarius"
		Item "pisces" "math-insert \pisces"
#		Item "conjunction" "math-insert \conjunction" # works in text mode only (produces V in math mode)
#		Item "opposition" "math-insert \opposition" # works in text mode only (produces W in math mode)
		Item "APLbox" "math-insert \APLbox"
		Item "APLcomment" "math-insert \APLcomment"
		Item "APLdown" "math-insert \APLdown"
		Item "APLdownarrowbox" "math-insert \APLdownarrowbox"
		Item "APLinput" "math-insert \APLinput"
		Item "APLinv" "math-insert \APLinv"
		Item "APLleftarrowbox" "math-insert \APLleftarrowbox"
		Item "APLlog" "math-insert \APLlog"
		Item "APLrightarrowbox" "math-insert \APLrightarrowbox"
		Item "APLstar" "math-insert \APLstar"
		Item "APLup" "math-insert \APLup"
		Item "APLuparrowbox" "math-insert \APLuparrowbox"
	End

	Toolbar "latex_ams_arrows" "Arrows (extended)"
#		Item "dasharrow" "math-insert \dasharrow" # same as dashrightarrow
		Item "dashleftarrow" "math-insert \dashleftarrow"
		Item "dashrightarrow" "math-insert \dashrightarrow"
		Item "leftleftarrows" "math-insert \leftleftarrows"
		Item "leftrightarrows" "math-insert \leftrightarrows"
		Item "rightrightarrows" "math-insert \rightrightarrows"
		Item "rightleftarrows" "math-insert \rightleftarrows"
		Item "Lleftarrow" "math-insert \Lleftarrow"
		Item "Rrightarrow" "math-insert \Rrightarrow"
		Item "twoheadleftarrow" "math-insert \twoheadleftarrow"
		Item "twoheadrightarrow" "math-insert \twoheadrightarrow"
		Item "leftarrowtail" "math-insert \leftarrowtail"
		Item "rightarrowtail" "math-insert \rightarrowtail"
		Item "looparrowleft" "math-insert \looparrowleft"
		Item "looparrowright" "math-insert \looparrowright"
		Item "curvearrowleft" "math-insert \curvearrowleft"
		Item "curvearrowright" "math-insert \curvearrowright"
		Item "circlearrowleft" "math-insert \circlearrowleft"
		Item "circlearrowright" "math-insert \circlearrowright"
		Item "Lsh" "math-insert \Lsh"
		Item "Rsh" "math-insert \Rsh"
		Item "upuparrows" "math-insert \upuparrows"
		Item "downdownarrows" "math-insert \downdownarrows"
		Item "upharpoonleft" "math-insert \upharpoonleft"
		Item "upharpoonright" "math-insert \upharpoonright"
#		Item "restriction" "math-insert \restriction" # same as upharpoonright
		Item "downharpoonleft" "math-insert \downharpoonleft"
		Item "downharpoonright" "math-insert \downharpoonright"
		Item "leftrightharpoons" "math-insert \leftrightharpoons"
		Item "rightleftharpoons" "math-insert \rightleftharpoons"
		Item "rightsquigarrow" "math-insert \rightsquigarrow"
		Item "leftrightsquigarrow" "math-insert \leftrightsquigarrow"
		Item "nleftarrow" "math-insert \nleftarrow"
		Item "nrightarrow" "math-insert \nrightarrow"
		Item "nleftrightarrow" "math-insert \nleftrightarrow"
		Item "nLeftarrow" "math-insert \nLeftarrow"
		Item "nRightarrow" "math-insert \nRightarrow"
		Item "nLeftrightarrow" "math-insert \nLeftrightarrow"
		Item "multimap" "math-insert \multimap"
		Item "shortleftarrow" "math-insert \shortleftarrow"
		Item "shortrightarrow" "math-insert \shortrightarrow"
		Item "shortuparrow" "math-insert \shortuparrow"
		Item "shortdownarrow" "math-insert \shortdownarrow"
		Item "leftrightarroweq" "math-insert \leftrightarroweq"
		Item "curlyveedownarrow" "math-insert \curlyveedownarrow"
		Item "curlyveeuparrow" "math-insert \curlyveeuparrow"
		Item "nnwarrow" "math-insert \nnwarrow"
		Item "nnearrow" "math-insert \nnearrow"
		Item "sswarrow" "math-insert \sswarrow"
		Item "ssearrow" "math-insert \ssearrow"
		Item "curlywedgeuparrow" "math-insert \curlywedgeuparrow"
		Item "curlywedgedownarrow" "math-insert \curlywedgedownarrow"
		Item "leftrightarrowtriangle" "math-insert \leftrightarrowtriangle"
		Item "leftarrowtriangle" "math-insert \leftarrowtriangle"
		Item "rightarrowtriangle" "math-insert \rightarrowtriangle"
		Item "Mapsto" "math-insert \Mapsto"
		Item "mapsfrom" "math-insert \mapsfrom"
		Item "Mapsfrom" "math-insert \Mapsfrom"
		Item "Longmapsto" "math-insert \Longmapsto"
		Item "longmapsfrom" "math-insert \longmapsfrom"
		Item "Longmapsfrom" "math-insert \Longmapsfrom"
		Item "xleftarrow" "math-insert \xleftarrow"
		Item "xrightarrow" "math-insert \xrightarrow"
#		Item "mapstochar" "math-insert \mapstochar"
#		Item "Mapstochar" "math-insert \Mapstochar"
#		Item "mapsfromchar" "math-insert \mapsfromchar"
#		Item "Mapsfromchar" "math-insert \Mapsfromchar"
#		Item "arrownot" "math-insert \arrownot"
#		Item "Arrownot" "math-insert \Arrownot"
#		Item "longarrownot" "math-insert \longarrownot"
#		Item "Longarrownot" "math-insert \Longarrownot"
#		Item "LEFTarrow" "math-insert \LEFTarrow" # works in text mode only (produces \imath in math mode)
#		Item "RIGHTarrow" "math-insert \RIGHTarrow" # works in text mode only (produces \jmath in math mode)
#		Item "DOWNarrow" "math-insert \DOWNarrow" # works in text mode only (produces L in math mode)
#		Item "UParrow" "math-insert \UParrow" # works in text mode only (produces K in math mode)
	End

	Toolbar "latex_ams_rel" "Relations (extended)"
		Item "leqq" "math-insert \leqq"
		Item "geqq" "math-insert \geqq"
		Item "leqslant" "math-insert \leqslant"
		Item "geqslant" "math-insert \geqslant"
		Item "eqslantless" "math-insert \eqslantless"
		Item "eqslantgtr" "math-insert \eqslantgtr"
		Item "eqsim" "math-insert \eqsim"
		Item "lesssim" "math-insert \lesssim"
		Item "gtrsim" "math-insert \gtrsim"
		Item "apprge" "math-insert \apprge"
		Item "apprle" "math-insert \apprle"
		Item "lessapprox" "math-insert \lessapprox"
		Item "gtrapprox" "math-insert \gtrapprox"
		Item "approxeq" "math-insert \approxeq"
		Item "triangleq" "math-insert \triangleq"
		Item "lessdot" "math-insert \lessdot"
		Item "gtrdot" "math-insert \gtrdot"
		Item "lll" "math-insert \lll"
		Item "ggg" "math-insert \ggg"
#		Item "llless" "math-insert \llless" # same as lll
#		Item "gggtr" "math-insert \gggtr" # same as ggg
		Item "lessgtr" "math-insert \lessgtr"
		Item "gtrless" "math-insert \gtrless"
		Item "lesseqgtr" "math-insert \lesseqgtr"
		Item "gtreqless" "math-insert \gtreqless"
		Item "lesseqqgtr" "math-insert \lesseqqgtr"
		Item "gtreqqless" "math-insert \gtreqqless"
		Item "eqcirc" "math-insert \eqcirc"
		Item "circeq" "math-insert \circeq"
		Item "thicksim" "math-insert \thicksim"
		Item "thickapprox" "math-insert \thickapprox"
		Item "backsim" "math-insert \backsim"
		Item "backsimeq" "math-insert \backsimeq"
		Item "subseteqq" "math-insert \subseteqq"
		Item "supseteqq" "math-insert \supseteqq"
		Item "Subset" "math-insert \Subset"
		Item "Supset" "math-insert \Supset"
		Item "sqsubset" "math-insert \sqsubset"
		Item "sqsupset" "math-insert \sqsupset"
		Item "preccurlyeq" "math-insert \preccurlyeq"
		Item "succcurlyeq" "math-insert \succcurlyeq"
		Item "curlyeqprec" "math-insert \curlyeqprec"
		Item "curlyeqsucc" "math-insert \curlyeqsucc"
		Item "precsim" "math-insert \precsim"
		Item "succsim" "math-insert \succsim"
		Item "precapprox" "math-insert \precapprox"
		Item "succapprox" "math-insert \succapprox"
		Item "vartriangleleft" "math-insert \vartriangleleft"
#		Item "lhd" "math-insert \lhd" # same as vartriangleleft
		Item "vartriangleright" "math-insert \vartriangleright"
#		Item "rhd" "math-insert \rhd" # same as vartriangleright
		Item "trianglelefteq" "math-insert \trianglelefteq"
#		Item "unlhd" "math-insert \unlhd" # same as trianglelefteq
		Item "trianglerighteq" "math-insert \trianglerighteq"
#		Item "unrhd" "math-insert \unrhd" # same as trianglerighteq
		Item "bumpeq" "math-insert \bumpeq"
		Item "Bumpeq" "math-insert \Bumpeq"
		Item "doteqdot" "math-insert \doteqdot"
#		Item "Doteq" "math-insert \Doteq" # same as doteqdot
		Item "risingdotseq" "math-insert \risingdotseq"
		Item "fallingdotseq" "math-insert \fallingdotseq"
		Item "vDash" "math-insert \vDash"
		Item "Vvdash" "math-insert \Vvdash"
		Item "Vdash" "math-insert \Vdash"
		Item "shortmid" "math-insert \shortmid"
		Item "shortparallel" "math-insert \shortparallel"
		Item "smallsmile" "math-insert \smallsmile"
		Item "smallfrown" "math-insert \smallfrown"
		Item "blacktriangleleft" "math-insert \blacktriangleleft"
#		Item "LHD" "math-insert \LHD" # same as blacktriangleleft
		Item "blacktriangleright" "math-insert \blacktriangleright"
#		Item "RHD" "math-insert \RHD" # same as blacktriangleright
		Item "because" "math-insert \because"
		Item "therefore" "math-insert \therefore"
		Item "wasytherefore" "math-insert \wasytherefore"
		Item "backepsilon" "math-insert \backepsilon"
		Item "varpropto" "math-insert \varpropto"
		Item "between" "math-insert \between"
		Item "pitchfork" "math-insert \pitchfork"
		Item "trianglelefteqslant" "math-insert \trianglelefteqslant"
		Item "trianglerighteqslant" "math-insert \trianglerighteqslant"
		Item "inplus" "math-insert \inplus"
		Item "niplus" "math-insert \niplus"
		Item "subsetplus" "math-insert \subsetplus"
		Item "supsetplus" "math-insert \supsetplus"
		Item "subsetpluseq" "math-insert \subsetpluseq"
		Item "supsetpluseq" "math-insert \supsetpluseq"
		Item "minuso" "math-insert \minuso"
		Item "baro" "math-insert \baro"
		Item "sslash" "math-insert \sslash"
		Item "bbslash" "math-insert \bbslash"
		Item "moo" "math-insert \moo"
		Item "merge" "math-insert \merge"
		Item "invneg" "math-insert \invneg"
		Item "lbag" "math-insert \lbag"
		Item "rbag" "math-insert \rbag"
		Item "interleave" "math-insert \interleave"
		Item "leftslice" "math-insert \leftslice"
		Item "rightslice" "math-insert \rightslice"
		Item "oblong" "math-insert \oblong"
		Item "talloblong" "math-insert \talloblong"
		Item "fatsemi" "math-insert \fatsemi"
		Item "fatslash" "math-insert \fatslash"
		Item "fatbslash" "math-insert \fatbslash"
		Item "ldotp" "math-insert \ldotp"
		Item "cdotp" "math-insert \cdotp"
		Item "colon" "math-insert \colon"
		Item "dblcolon" "math-insert \dblcolon"
		Item "vcentcolon" "math-insert \vcentcolon"
		Item "colonapprox" "math-insert \colonapprox"
		Item "Colonapprox" "math-insert \Colonapprox"
		Item "coloneq" "math-insert \coloneq"
		Item "Coloneq" "math-insert \Coloneq"
		Item "coloneqq" "math-insert \coloneqq"
		Item "Coloneqq" "math-insert \Coloneqq"
		Item "colonsim" "math-insert \colonsim"
		Item "Colonsim" "math-insert \Colonsim"
		Item "eqcolon" "math-insert \eqcolon"
		Item "Eqcolon" "math-insert \Eqcolon"
		Item "eqqcolon" "math-insert \eqqcolon"
		Item "Eqqcolon" "math-insert \Eqqcolon"
		Item "wasypropto" "math-insert \wasypropto"
		Item "logof" "math-insert \logof"
		Item "Join" "math-insert \Join"
	End

	Toolbar "latex_ams_nrel" "Negative Relations (extended)"
		Item "nless" "math-insert \nless"
		Item "ngtr" "math-insert \ngtr"
		Item "nleq" "math-insert \nleq"
		Item "ngeq" "math-insert \ngeq"
		Item "nleqslant" "math-insert \nleqslant"
		Item "ngeqslant" "math-insert \ngeqslant"
		Item "nleqq" "math-insert \nleqq"
		Item "ngeqq" "math-insert \ngeqq"
		Item "lneq" "math-insert \lneq"
		Item "gneq" "math-insert \gneq"
		Item "lneqq" "math-insert \lneqq"
		Item "gneqq" "math-insert \gneqq"
		Item "lvertneqq" "math-insert \lvertneqq"
		Item "gvertneqq" "math-insert \gvertneqq"
		Item "lnsim" "math-insert \lnsim"
		Item "gnsim" "math-insert \gnsim"
		Item "lnapprox" "math-insert \lnapprox"
		Item "gnapprox" "math-insert \gnapprox"
		Item "nprec" "math-insert \nprec"
		Item "nsucc" "math-insert \nsucc"
		Item "npreceq" "math-insert \npreceq"
		Item "nsucceq" "math-insert \nsucceq"
		Item "precneqq" "math-insert \precneqq"
		Item "succneqq" "math-insert \succneqq"
		Item "precnsim" "math-insert \precnsim"
		Item "succnsim" "math-insert \succnsim"
		Item "precnapprox" "math-insert \precnapprox"
		Item "succnapprox" "math-insert \succnapprox"
		Item "subsetneq" "math-insert \subsetneq"
		Item "supsetneq" "math-insert \supsetneq"
		Item "subsetneqq" "math-insert \subsetneqq"
		Item "supsetneqq" "math-insert \supsetneqq"
		Item "nsubseteq" "math-insert \nsubseteq"
		Item "nsubseteqq" "math-insert \nsubseteqq"
		Item "nsupseteq" "math-insert \nsupseteq"
		Item "nsupseteqq" "math-insert \nsupseteqq"
		Item "nvdash" "math-insert \nvdash"
		Item "nvDash" "math-insert \nvDash"
		Item "nVDash" "math-insert \nVDash"
		Item "nVdash" "math-insert \nVdash"
		Item "varsubsetneq" "math-insert \varsubsetneq"
		Item "varsupsetneq" "math-insert \varsupsetneq"
		Item "varsubsetneqq" "math-insert \varsubsetneqq"
		Item "varsupsetneqq" "math-insert \varsupsetneqq"
		Item "ntriangleleft" "math-insert \ntriangleleft"
		Item "ntriangleright" "math-insert \ntriangleright"
		Item "ntrianglelefteq" "math-insert \ntrianglelefteq"
		Item "ntrianglerighteq" "math-insert \ntrianglerighteq"
		Item "ncong" "math-insert \ncong"
		Item "nsim" "math-insert \nsim"
		Item "nmid" "math-insert \nmid"
		Item "nshortmid" "math-insert \nshortmid"
		Item "nparallel" "math-insert \nparallel"
		Item "nshortparallel" "math-insert \nshortparallel"
		Item "ntrianglelefteqslant" "math-insert \ntrianglelefteqslant"
		Item "ntrianglerighteqslant" "math-insert \ntrianglerighteqslant"
	End

	Toolbar "latex_ams_ops" "Operators (extended)"
		Item "dotplus" "math-insert \dotplus"
		Item "smallsetminus" "math-insert \smallsetminus"
		Item "Cap" "math-insert \Cap"
#		Item "doublecap" "math-insert \doublecap" # same as Cap
		Item "Cup" "math-insert \Cup"
#		Item "doublecup" "math-insert \doublecup" # same as Cup
		Item "barwedge" "math-insert \barwedge"
		Item "veebar" "math-insert \veebar"
		Item "doublebarwedge" "math-insert \doublebarwedge"
		Item "boxminus" "math-insert \boxminus"
		Item "boxtimes" "math-insert \boxtimes"
		Item "boxdot" "math-insert \boxdot"
		Item "boxplus" "math-insert \boxplus"
		Item "boxast" "math-insert \boxast"
		Item "boxbar" "math-insert \boxbar"
		Item "boxslash" "math-insert \boxslash"
		Item "boxbslash" "math-insert \boxbslash"
		Item "boxcircle" "math-insert \boxcircle"
		Item "boxbox" "math-insert \boxbox"
		Item "boxempty" "math-insert \boxempty"
		Item "divideontimes" "math-insert \divideontimes"
		Item "ltimes" "math-insert \ltimes"
		Item "rtimes" "math-insert \rtimes"
		Item "leftthreetimes" "math-insert \leftthreetimes"
		Item "rightthreetimes" "math-insert \rightthreetimes"
		Item "curlywedge" "math-insert \curlywedge"
		Item "curlyvee" "math-insert \curlyvee"
		Item "circleddash" "math-insert \circleddash"
		Item "circledast" "math-insert \circledast"
		Item "circledcirc" "math-insert \circledcirc"
		Item "centerdot" "math-insert \centerdot"
		Item "intercal" "math-insert \intercal"
		Item "implies" "math-insert \implies"
		Item "impliedby" "math-insert \impliedby"
		Item "bigcurlyvee" "math-insert \bigcurlyvee"
		Item "bigcurlywedge" "math-insert \bigcurlywedge"
		Item "bigsqcap" "math-insert \bigsqcap"
		Item "bigbox" "math-insert \bigbox"
		Item "bigparallel" "math-insert \bigparallel"
		Item "biginterleave" "math-insert \biginterleave"
		Item "bignplus" "math-insert \bignplus"
		Item "nplus" "math-insert \nplus"
		Item "Yup" "math-insert \Yup"
		Item "Ydown" "math-insert \Ydown"
		Item "Yleft" "math-insert \Yleft"
		Item "Yright" "math-insert \Yright"
		Item "obar" "math-insert \obar"
		Item "obslash" "math-insert \obslash"
		Item "ocircle" "math-insert \ocircle"
		Item "olessthan" "math-insert \olessthan"
		Item "ogreaterthan" "math-insert \ogreaterthan"
		Item "ovee" "math-insert \ovee"
		Item "owedge" "math-insert \owedge"
		Item "varcurlyvee" "math-insert \varcurlyvee"
		Item "varcurlywedge" "math-insert \varcurlywedge"
		Item "vartimes" "math-insert \vartimes"
		Item "varotimes" "math-insert \varotimes"
		Item "varoast" "math-insert \varoast"
		Item "varobar" "math-insert \varobar"
		Item "varodot" "math-insert \varodot"
		Item "varoslash" "math-insert \varoslash"
		Item "varobslash" "math-insert \varobslash"
		Item "varocircle" "math-insert \varocircle"
		Item "varoplus" "math-insert \varoplus"
		Item "varominus" "math-insert \varominus"
		Item "varovee" "math-insert \varovee"
		Item "varowedge" "math-insert \varowedge"
		Item "varolessthan" "math-insert \varolessthan"
		Item "varogreaterthan" "math-insert \varogreaterthan"
		Item "varbigcirc" "math-insert \varbigcirc"
	End

	Toolbar "latex_delim" "Delimiters (fixed size)"
#		Item "vert" "math-insert \vert" # same as |
		Item "brokenvert" "math-insert \brokenvert"
#		Item "lbrace" "math-insert \lbrace" # same as {
#		Item "rbrace" "math-insert \rbrace" # same as }
		Item "lfloor" "math-insert \lfloor"
		Item "rfloor" "math-insert \rfloor"
		Item "lceil" "math-insert \lceil"
		Item "rceil" "math-insert \rceil"
#		Item "backslash" "math-insert \backslash" # same as \
#		Item "slash" "math-insert \slash" # same as /
#		Item "langle" "math-insert \langle" # same as <
#		Item "rangle" "math-insert \rangle" # same as >
		Item "llbracket" "math-insert \llbracket"
		Item "rrbracket" "math-insert \rrbracket"
		Item "llfloor" "math-insert \llfloor"
		Item "rrfloor" "math-insert \rrfloor"
		Item "llceil" "math-insert \llceil"
		Item "rrceil" "math-insert \rrceil"
		Item "Lbag" "math-insert \Lbag"
		Item "Rbag" "math-insert \Rbag"
		Item "llparenthesis" "math-insert \llparenthesis"
		Item "rrparenthesis" "math-insert \rrparenthesis"
		Item "binampersand" "math-insert \binampersand"
		Item "bindnasrepma" "math-insert \bindnasrepma"
	End

	Toolbar "ipa_pulmonic" "IPA Pulmonic Consonants"
		Item "Voiceless bilabial plosive" "unicode-insert 0x0070"
		Item "Voiced bilabial plosive" "unicode-insert 0x0062"
		Item "Voiceless alveolar plosive" "unicode-insert 0x0074"
		Item "Voiced alveolar plosive" "unicode-insert 0x0064"
		Item "Voiceless retroflex plosive" "unicode-insert 0x0288"
		Item "Voiced retroflex plosive" "unicode-insert 0x0256"
		Item "Voiceless palatal plosive" "unicode-insert 0x0063"
		Item "Voiced palatal plosive" "unicode-insert 0x025f"
		Item "Voiceless velar plosive" "unicode-insert 0x006b"
		Item "Voiced velar plosive" "unicode-insert 0x0261"
		Item "Voiceless uvular plosive" "unicode-insert 0x0071"
		Item "Voiced uvular plosive" "unicode-insert 0x0262"
		Item "Glottal plosive" "unicode-insert 0x0294"
		Item "Voiced bilabial nasal" "unicode-insert 0x006d"
		Item "Voiced labiodental nasal" "unicode-insert 0x0271"
		Item "Voiced alveolar nasal" "unicode-insert 0x006e"
		Item "Voiced retroflex nasal" "unicode-insert 0x0273"
		Item "Voiced palatal nasal" "unicode-insert 0x0272"
		Item "Voiced velar nasal" "unicode-insert 0x014b"
		Item "Voiced uvular nasal" "unicode-insert 0x0274"
		Item "Voiced bilabial trill" "unicode-insert 0x0299"
		Item "Voiced alveolar trill" "unicode-insert 0x0072"
		Item "Voiced uvular trill" "unicode-insert 0x0280"
#		Item "Voiced labiodental flap" "unicode-insert 0x2c71" // Not yet covered by TIPA
		Item "Voiced alveolar tap" "unicode-insert 0x027e"
		Item "Voiced retroflex flap" "unicode-insert 0x027d"
		Item "Voiceless bilabial fricative" "unicode-insert 0x0278"
		Item "Voiced bilabial fricative" "unicode-insert 0x03b2"
		Item "Voiceless labiodental fricative" "unicode-insert 0x0066"
		Item "Voiced labiodental fricative" "unicode-insert 0x0076"
		Item "Voiceless dental fricative" "unicode-insert 0x03b8"
		Item "Voiced dental fricative" "unicode-insert 0x00f0"
		Item "Voiceless alveolar fricative" "unicode-insert 0x0073"
		Item "Voiced alveolar fricative" "unicode-insert 0x007a"
		Item "Voiceless postalveolar fricative" "unicode-insert 0x0283"
		Item "Voiced postalveolar fricative" "unicode-insert 0x0292"
		Item "Voiceless retroflex fricative" "unicode-insert 0x0282"
		Item "Voiced retroflex fricative" "unicode-insert 0x0290"
		Item "Voiceless palatal fricative" "unicode-insert 0x00e7"
		Item "Voiced palatal fricative" "unicode-insert 0x029d"
		Item "Voiceless velar fricative" "unicode-insert 0x0078"
		Item "Voiced velar fricative" "unicode-insert 0x0263"
		Item "Voiceless uvular fricative" "unicode-insert 0x03c7"
		Item "Voiced uvular fricative" "unicode-insert 0x0281"
		Item "Voiceless pharyngeal fricative" "unicode-insert 0x0127"
		Item "Voiced pharyngeal fricative" "unicode-insert 0x0295"
		Item "Voiceless glottal fricative" "unicode-insert 0x0068"
		Item "Voiced glottal fricative" "unicode-insert 0x0266"
		Item "Voiceless alveolar lateral fricative" "unicode-insert 0x026c"
		Item "Voiced alveolar lateral fricative" "unicode-insert 0x026e"
		Item "Voiced labiodental approximant" "unicode-insert 0x028b"
		Item "Voiced alveolar approximant" "unicode-insert 0x0279"
		Item "Voiced retroflex approximant" "unicode-insert 0x027b"
		Item "Voiced palatal approximant" "unicode-insert 0x006a"
		Item "Voiced velar approximant" "unicode-insert 0x0270"
		Item "Voiced alveolar lateral approximant" "unicode-insert 0x006c"
		Item "Voiced retroflex lateral approximant" "unicode-insert 0x026d"
		Item "Voiced palatal lateral approximant" "unicode-insert 0x028e"
		Item "Voiced velar lateral approximant" "unicode-insert 0x029f"
	End

	Toolbar "ipa_nonpulmonic" "IPA Non-Pulmonic Consonants"
		Item "Bilabial click" "unicode-insert 0x0298"
		Item "Dental click" "unicode-insert 0x01c0"
		Item "(Post)alveolar click" "unicode-insert 0x01c3"
		Item "Palatoalveolar click" "unicode-insert 0x01c2"
		Item "Alveolar lateral click" "unicode-insert 0x01c1"
		Item "Voiced bilabial implosive" "unicode-insert 0x0253"
		Item "Voiced dental/alveolar implosive" "unicode-insert 0x0257"
		Item "Voiced palatal implosive" "unicode-insert 0x0284"
		Item "Voiced velar implosive" "unicode-insert 0x0260"
		Item "Voiced uvular implosive" "unicode-insert 0x029b"
		Item "Ejective mark" "unicode-insert 0x02bc"
	End

	Toolbar "ipa_vowels" "IPA Vowels"
		Item "Close front unrounded vowel" "unicode-insert 0x0069"
		Item "Close front rounded vowel" "unicode-insert 0x0079"
		Item "Close central unrounded vowel" "unicode-insert 0x0268"
		Item "Close central rounded vowel" "unicode-insert 0x0289"
		Item "Close back unrounded vowel" "unicode-insert 0x026f"
		Item "Close back rounded vowel" "unicode-insert 0x0075"
		Item "Near-close near-front unrounded vowel" "unicode-insert 0x026a"
		Item "Near-close near-front rounded vowel" "unicode-insert 0x028f"
		Item "Near-close near-back rounded vowel" "unicode-insert 0x028a"
		Item "Close-mid front unrounded vowel" "unicode-insert 0x0065"
		Item "Close-mid front rounded vowel" "unicode-insert 0x00f8"
		Item "Close-mid central unrounded vowel" "unicode-insert 0x0258"
		Item "Close-mid central rounded vowel" "unicode-insert 0x0275"
		Item "Close-mid back unrounded vowel" "unicode-insert 0x0264"
		Item "Close-mid back rounded vowel" "unicode-insert 0x006f"
		Item "Mid-central vowel (Schwa)" "unicode-insert 0x0259"
		Item "Open-mid front unrounded vowel" "unicode-insert 0x025b"
		Item "Open-mid front rounded vowel" "unicode-insert 0x0153"
		Item "Open-mid central unrounded vowel" "unicode-insert 0x025c"
		Item "Open-mid central rounded vowel" "unicode-insert 0x025e"
		Item "Open-mid back unrounded vowel" "unicode-insert 0x028c"
		Item "Open-mid back rounded vowel" "unicode-insert 0x0254"
		Item "Near-open front unrounded vowel" "unicode-insert 0x00e6"
		Item "Near-open vowel" "unicode-insert 0x0250"
		Item "Open front unrounded vowel" "unicode-insert 0x0061"
		Item "Open front rounded vowel" "unicode-insert 0x0276"
		Item "Open back unrounded vowel" "unicode-insert 0x0251"
		Item "Open back rounded vowel" "unicode-insert 0x0252"
	End

	Toolbar "ipa_others" "IPA Other Symbols"
		Item "Voiceless labial-velar fricative" "unicode-insert 0x028d"
		Item "Voiced labial-velar approximant" "unicode-insert 0x0077"
		Item "Voiced labial-palatal approximant" "unicode-insert 0x0265"
		Item "Voiceless epiglottal fricative" "unicode-insert 0x029c"
		Item "Voiced epiglottal fricative" "unicode-insert 0x02a2"
		Item "Epiglottal plosive" "unicode-insert 0x02a1"
		Item "Voiceless alveolo-palatal fricative" "unicode-insert 0x0255"
		Item "Voiced alveolo-palatal fricative" "unicode-insert 0x0291"
		Item "Voiced alveolar lateral flap" "unicode-insert 0x027a"
		Item "Simultaneous voiceless postalveolar and velar fricative" "unicode-insert 0x0267"
		Item "Top tie bar" "ipamacro-insert deco toptiebar"
		Item "Bottom tie bar" "ipamacro-insert deco bottomtiebar"
	End

	Toolbar "ipa_suprasegmentals" "IPA Suprasegmentals"
		Item "Long" "unicode-insert 0x02d0"
		Item "Half-long" "unicode-insert 0x02d1"
		Item "Extra short" "unicode-insert 0x0306"
		Item "Primary stress" "unicode-insert 0x02c8"
		Item "Secondary stress" "unicode-insert 0x02cc"
		Item "Minor (foot) group" "unicode-insert 0x007c"
		Item "Major (intonation) group" "unicode-insert 0x2016"
		Item "Syllable break" "unicode-insert 0x002e"
		Item "Linking (absence of a break)" "unicode-insert 0x203f"
	End

	Toolbar "ipa_diacritics" "IPA Diacritics"
		Item "Voiceless" "unicode-insert 0x0325"
		Item "Voiceless (above)" "unicode-insert 0x030a"
		Item "Voiced" "unicode-insert 0x032c"
		Item "Breathy voiced" "unicode-insert 0x0324"
		Item "Creaky voiced" "unicode-insert 0x0330"
		Item "Linguolabial" "unicode-insert 0x033c"
		Item "Dental" "unicode-insert 0x032a"
		Item "Apical" "unicode-insert 0x033a"
		Item "Laminal" "unicode-insert 0x033b"
		Item "Aspirated" "unicode-insert 0x02b0"
		Item "More rounded" "unicode-insert 0x0339"
		Item "Less rounded" "unicode-insert 0x031c"
		Item "Advanced" "unicode-insert 0x031f"
		Item "Retracted" "unicode-insert 0x0320"
		Item "Centralized" "unicode-insert 0x0308"
		Item "Mid-centralized" "unicode-insert 0x033d"
		Item "Syllabic" "unicode-insert 0x0329"
		Item "Non-syllabic" "unicode-insert 0x032f"
		Item "Rhoticity" "unicode-insert 0x02de"
		Item "Labialized" "unicode-insert 0x02b7"
		Item "Palatized" "unicode-insert 0x02b2"
		Item "Velarized" "unicode-insert 0x02e0"
		Item "Pharyngialized" "unicode-insert 0x02e4"
		Item "Velarized or pharyngialized" "unicode-insert 0x0334"
		Item "Raised" "unicode-insert 0x031d"
		Item "Lowered" "unicode-insert 0x031e"
		Item "Advanced tongue root" "unicode-insert 0x0318"
		Item "Retracted tongue root" "unicode-insert 0x0319"
		Item "Nasalized" "unicode-insert 0x0303"
		Item "Nasal release" "unicode-insert 0x207f"
		Item "Lateral release" "unicode-insert 0x02e1"
		Item "No audible release" "unicode-insert 0x02fa"
	End

	Toolbar "ipa_accents" "IPA Tones and Word Accents"
		Item "Extra high (accent)" "unicode-insert 0x030b"
		Item "Extra high (tone letter)" "unicode-insert 0x02e5"
		Item "High (accent)" "unicode-insert 0x0300"
		Item "High (tone letter)" "unicode-insert 0x02e6"
		Item "Mid (accent)" "unicode-insert 0x0304"
		Item "Mid (tone letter)" "unicode-insert 0x02e7"
		Item "Low (accent)" "unicode-insert 0x0301"
		Item "Low (tone letter)" "unicode-insert 0x02e8"
		Item "Extra low (accent)" "unicode-insert 0x030f"
		Item "Extra low (tone letter)" "unicode-insert 0x02e9"
		Item "Downstep" "unicode-insert 0xa71c"
		Item "Upstep" "unicode-insert 0xa71b"
		Item "Rising (accent)" "unicode-insert 0x030c"
		Item "Rising (tone letter)" "ipamacro-insert tone-rising"
		Item "Falling (accent)" "unicode-insert 0x0302"
		Item "Falling (tone letter)" "ipamacro-insert tone-falling"
		Item "High rising (accent)" "unicode-insert 0x1dc4"
		Item "High rising (tone letter)" "ipamacro-insert tone-high-rising"
		Item "Low rising (accent)" "unicode-insert 0x1dc5"
		Item "Low rising (tone letter)" "ipamacro-insert tone-low-rising"
		Item "Rising-falling (accent)" "unicode-insert 0x1dc8"
		Item "Rising-falling (tone letter)" "ipamacro-insert tone-high-rising-falling"
		Item "Global rise" "unicode-insert 0x2197"
		Item "Global fall" "unicode-insert 0x2198"
	End

End
