/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.SafeDoubleParser;

public class RubyUtils {
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss Z").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter UTC_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss 'UTC'").withLocale(Locale.ENGLISH);

    public static RubyObject rubyObject(Ruby ruby, Object node) {
        return (RubyObject)JavaUtil.convertJavaToRuby((Ruby)ruby, (Object)node);
    }

    public static RubyString rubyString(Ruby ruby, String node) {
        return RubyString.newUnicodeString((Ruby)ruby, (String)node);
    }

    public static RubyString rubyString(Ruby ruby, byte[] node) {
        return RubyString.newString((Ruby)ruby, (byte[])node);
    }

    public static RubyString rubyString(Ruby ruby, CharSequence node) {
        return RubyString.newUnicodeString((Ruby)ruby, (CharSequence)node);
    }

    public static RubySymbol rubySymbol(Ruby ruby, String node) {
        return RubySymbol.newSymbol((Ruby)ruby, (String)node);
    }

    public static RubyArray rubyArray(Ruby ruby, Object[] arg) {
        return (RubyArray)JavaUtil.convertJavaToRuby((Ruby)ruby, (Object)arg);
    }

    public static RubyArray rubyArray(Ruby ruby, List arg) {
        return (RubyArray)JavaUtil.convertJavaToRuby((Ruby)ruby, (Object)arg);
    }

    public static RubyHash rubyHash(Ruby ruby, Map arg) {
        return (RubyHash)JavaUtil.convertJavaToRuby((Ruby)ruby, (Object)arg);
    }

    public static RubyFixnum rubyFixnum(Ruby ruby, int arg) {
        return ruby.newFixnum(arg);
    }

    public static RubyFixnum rubyFixnum(Ruby ruby, long arg) {
        return ruby.newFixnum(arg);
    }

    public static RubyBignum rubyBignum(Ruby ruby, BigInteger arg) {
        return RubyBignum.newBignum((Ruby)ruby, (BigInteger)arg);
    }

    public static RubyFloat rubyFloat(Ruby ruby, double arg) {
        return ruby.newFloat(arg);
    }

    public static RubyFloat rubyFloat(Ruby ruby, String arg) {
        double d = SafeDoubleParser.parseDouble((String)arg);
        return ruby.newFloat(d);
    }

    public static RubyBigDecimal rubyBigDecimal(Ruby ruby, BigDecimal arg) {
        return new RubyBigDecimal(ruby, arg);
    }

    public static RubyBoolean rubyBoolean(Ruby ruby, Boolean arg) {
        return ruby.newBoolean(arg.booleanValue());
    }

    public static RubyHash rubyHash(Ruby ruby, IRubyObject key, IRubyObject value) {
        RubyHash hash = RubyHash.newHash((Ruby)ruby);
        hash.fastASet(key, value);
        return hash;
    }

    public static RubyHash rubyHash(Ruby ruby, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2) {
        RubyHash hash = RubyUtils.rubyHash(ruby, key1, value1);
        hash.fastASet(key2, value2);
        return hash;
    }

    public static boolean isBasicObjectOrSubclass(IRubyObject object) {
        List list = object.getMetaClass().getAncestorList();
        for (IRubyObject entry : list) {
            if (!"Kernel".equalsIgnoreCase(entry.toString())) continue;
            return false;
        }
        return true;
    }

    public static String jodaTimeString(DateTime dt) {
        DateTimeFormatter simpleDateFormat = dt.getZone() == DateTimeZone.UTC ? UTC_FORMATTER : FORMATTER;
        return simpleDateFormat.print((ReadableInstant)dt);
    }

    public static void writeBytes(IRubyObject value, JsonGenerator jgen) throws IOException {
        RubyString s = (RubyString)value;
        ByteList b = s.getByteList();
        jgen.writeUTF8String(b.unsafeBytes(), b.begin(), b.length());
    }
}

