/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport.tls;

import java.io.Serializable;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.snmp4j.TransportStateReference;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.TLSTM;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;

public class TLSTMExtendedTrustManager
extends X509ExtendedTrustManager {
    private static final LogAdapter logger = LogFactory.getLogger(TLSTMExtendedTrustManager.class);
    X509TrustManager trustManager;
    private boolean useClientMode;
    private TransportStateReference tmStateReference;
    private TLSTM tlstm;

    public TLSTMExtendedTrustManager(TLSTM tlstm, X509TrustManager trustManager, boolean useClientMode, TransportStateReference tmStateReference) {
        this.tlstm = tlstm;
        this.trustManager = trustManager;
        this.useClientMode = useClientMode;
        this.tmStateReference = tmStateReference;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        if (this.checkClientTrustedIntern(x509Certificates)) {
            return;
        }
        try {
            this.trustManager.checkClientTrusted(x509Certificates, s);
        }
        catch (CertificateException cex) {
            this.tlstm.getCounterSupport().fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
            this.tlstm.getCounterSupport().fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidClientCertificates));
            logger.warn((Serializable)((Object)("Client certificate validation failed for '" + x509Certificates[0] + "'")));
            throw cex;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        if (this.preCheckServerTrusted(x509Certificates)) {
            return;
        }
        try {
            this.trustManager.checkServerTrusted(x509Certificates, s);
        }
        catch (CertificateException cex) {
            this.tlstm.getCounterSupport().fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
            this.tlstm.getCounterSupport().fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionUnknownServerCertificate));
            logger.warn((Serializable)((Object)("Server certificate validation failed for '" + x509Certificates[0] + "'")));
            throw cex;
        }
        this.postCheckServerTrusted(x509Certificates);
    }

    private boolean isMatchingFingerprint(X509Certificate[] x509Certificates, OctetString fingerprint) {
        if (fingerprint != null && fingerprint.length() > 0) {
            for (X509Certificate cert : x509Certificates) {
                OctetString certFingerprint = null;
                certFingerprint = TLSTM.getFingerprint(cert);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Comparing certificate fingerprint " + certFingerprint + " with " + fingerprint)));
                }
                if (certFingerprint == null) {
                    logger.error((Serializable)((Object)("Failed to determine fingerprint for certificate " + cert + " and algorithm " + cert.getSigAlgName())));
                    continue;
                }
                if (!certFingerprint.equals(fingerprint)) continue;
                if (logger.isInfoEnabled()) {
                    logger.info("Peer is trusted by fingerprint '" + fingerprint + "' of certificate: '" + cert + "'");
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        TlsTmSecurityCallback<X509Certificate> callback = this.tlstm.getSecurityCallback();
        X509Certificate[] accepted = this.trustManager.getAcceptedIssuers();
        if (accepted != null && callback != null) {
            ArrayList<X509Certificate> acceptedIssuers = new ArrayList<X509Certificate>(accepted.length);
            for (X509Certificate cert : accepted) {
                if (!callback.isAcceptedIssuer(cert)) continue;
                acceptedIssuers.add(cert);
            }
            return acceptedIssuers.toArray(new X509Certificate[acceptedIssuers.size()]);
        }
        return accepted;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        logger.debug((Serializable)((Object)"checkClientTrusted with socket"));
        if (this.checkClientTrustedIntern(x509Certificates)) {
            return;
        }
        try {
            if (this.trustManager instanceof X509ExtendedTrustManager) {
                logger.debug((Serializable)((Object)"extended checkClientTrusted with socket"));
                ((X509ExtendedTrustManager)this.trustManager).checkClientTrusted(x509Certificates, s, socket);
            } else {
                this.trustManager.checkClientTrusted(x509Certificates, s);
            }
        }
        catch (CertificateException cex) {
            this.tlstm.getCounterSupport().fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
            this.tlstm.getCounterSupport().fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidClientCertificates));
            logger.warn((Serializable)((Object)("Client certificate validation failed for '" + x509Certificates[0] + "'")));
            throw cex;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        logger.debug((Serializable)((Object)"checkClientTrusted with socket"));
        if (this.preCheckServerTrusted(x509Certificates)) {
            return;
        }
        try {
            if (this.trustManager instanceof X509ExtendedTrustManager) {
                logger.debug((Serializable)((Object)"extended checkClientTrusted with socket"));
                ((X509ExtendedTrustManager)this.trustManager).checkServerTrusted(x509Certificates, s, socket);
            } else {
                this.trustManager.checkServerTrusted(x509Certificates, s);
            }
        }
        catch (CertificateException cex) {
            this.tlstm.getCounterSupport().fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
            this.tlstm.getCounterSupport().fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionUnknownServerCertificate));
            logger.warn((Serializable)((Object)("Server certificate validation failed for '" + x509Certificates[0] + "'")));
            throw cex;
        }
        this.postCheckServerTrusted(x509Certificates);
    }

    private void postCheckServerTrusted(X509Certificate[] x509Certificates) throws CertificateException {
        TlsTmSecurityCallback<X509Certificate> callback = this.tlstm.getSecurityCallback();
        if (this.useClientMode && callback != null && !callback.isServerCertificateAccepted(x509Certificates)) {
            logger.info("Server is NOT trusted with certificate '" + Arrays.asList(x509Certificates) + "'");
            throw new CertificateException("Server's certificate is not trusted by this application (although it was trusted by the JRE): " + Arrays.asList(x509Certificates));
        }
    }

    private boolean preCheckServerTrusted(X509Certificate[] x509Certificates) {
        X500Principal x500Principal;
        OctetString fingerprint;
        if (this.tmStateReference.getCertifiedIdentity() != null && this.isMatchingFingerprint(x509Certificates, fingerprint = this.tmStateReference.getCertifiedIdentity().getServerFingerprint())) {
            return true;
        }
        Object entry = null;
        try {
            entry = TLSTM.getSubjAltName(x509Certificates[0].getSubjectAlternativeNames(), 2);
        }
        catch (CertificateParsingException e) {
            logger.error((Serializable)((Object)("CertificateParsingException while verifying server certificate " + Arrays.asList(x509Certificates))));
        }
        if (entry == null && (x500Principal = x509Certificates[0].getSubjectX500Principal()) != null) {
            entry = x500Principal.getName();
        }
        if (entry != null) {
            String dNSName = ((String)entry).toLowerCase();
            String hostName = ((IpAddress)this.tmStateReference.getAddress()).getInetAddress().getCanonicalHostName();
            if (dNSName != null && dNSName.length() > 0) {
                if (dNSName.charAt(0) == '*') {
                    int pos = hostName.indexOf(46);
                    hostName = hostName.substring(pos);
                    dNSName = dNSName.substring(1);
                }
                if (hostName.equalsIgnoreCase(dNSName)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Peer hostname " + hostName + " matches dNSName " + dNSName);
                    }
                    return true;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Peer hostname " + hostName + " did not match dNSName " + dNSName)));
            }
        }
        return false;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        logger.debug((Serializable)((Object)"checkClientTrusted with sslEngine"));
        if (this.checkClientTrustedIntern(x509Certificates)) {
            return;
        }
        try {
            if (this.trustManager instanceof X509ExtendedTrustManager) {
                logger.debug((Serializable)((Object)"extended checkClientTrusted with sslEngine"));
                ((X509ExtendedTrustManager)this.trustManager).checkClientTrusted(x509Certificates, s, sslEngine);
            } else {
                this.trustManager.checkClientTrusted(x509Certificates, s);
            }
        }
        catch (CertificateException cex) {
            this.tlstm.getCounterSupport().fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
            this.tlstm.getCounterSupport().fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidClientCertificates));
            logger.warn((Serializable)((Object)("Client certificate validation failed for '" + x509Certificates[0] + "'")));
            throw cex;
        }
    }

    private boolean checkClientTrustedIntern(X509Certificate[] x509Certificates) {
        OctetString fingerprint;
        if (this.tmStateReference != null && this.tmStateReference.getCertifiedIdentity() != null && this.isMatchingFingerprint(x509Certificates, fingerprint = this.tmStateReference.getCertifiedIdentity().getClientFingerprint())) {
            return true;
        }
        TlsTmSecurityCallback<X509Certificate> callback = this.tlstm.getSecurityCallback();
        if (!this.useClientMode && callback != null && callback.isClientCertificateAccepted(x509Certificates[0])) {
            if (logger.isInfoEnabled()) {
                logger.info("Client is trusted with certificate '" + x509Certificates[0] + "'");
            }
            return true;
        }
        return false;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        logger.debug((Serializable)((Object)"checkServerTrusted with sslEngine"));
        if (this.preCheckServerTrusted(x509Certificates)) {
            return;
        }
        try {
            if (this.trustManager instanceof X509ExtendedTrustManager) {
                logger.debug((Serializable)((Object)"extended checkServerTrusted with sslEngine"));
                ((X509ExtendedTrustManager)this.trustManager).checkServerTrusted(x509Certificates, s, sslEngine);
            } else {
                this.trustManager.checkServerTrusted(x509Certificates, s);
            }
        }
        catch (CertificateException cex) {
            this.tlstm.getCounterSupport().fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
            this.tlstm.getCounterSupport().fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionUnknownServerCertificate));
            logger.warn((Serializable)((Object)("Server certificate validation failed for '" + x509Certificates[0] + "'")));
            throw cex;
        }
        this.postCheckServerTrusted(x509Certificates);
    }
}

