/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"HooksRegistry"})
public final class HooksRegistryExt
extends RubyObject {
    private ConcurrentHashMap<IRubyObject, IRubyObject> registeredEmitters;
    private ConcurrentHashMap<IRubyObject, List<IRubyObject>> registeredHooks;

    public HooksRegistryExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context) {
        this.registeredEmitters = new ConcurrentHashMap();
        this.registeredHooks = new ConcurrentHashMap();
        return this;
    }

    @JRubyMethod(name={"register_emitter"})
    public IRubyObject registerEmitter(ThreadContext context, IRubyObject emitterScope, IRubyObject dispatcher) {
        this.registeredEmitters.put(emitterScope, dispatcher);
        return this.syncHooks(context);
    }

    @JRubyMethod(name={"remove_emitter"})
    public IRubyObject removeEmitter(ThreadContext context, IRubyObject emitterScope) {
        return this.registeredEmitters.remove(emitterScope);
    }

    @JRubyMethod(name={"register_hooks"})
    public IRubyObject registerHooks(ThreadContext context, IRubyObject emitterScope, IRubyObject callback) {
        List callbacks = this.registeredHooks.computeIfAbsent(emitterScope, iRubyObject -> new CopyOnWriteArrayList());
        callbacks.add(callback);
        return this.syncHooks(context);
    }

    @JRubyMethod(name={"remove_hooks"})
    public IRubyObject remove_hooks(ThreadContext context, IRubyObject emitterScope, IRubyObject callback) {
        List<IRubyObject> callbacks = this.registeredHooks.get(emitterScope);
        if (callbacks == null) {
            return context.fals;
        }
        return callbacks.removeAll(Collections.singleton(callback)) ? context.tru : context.fals;
    }

    @JRubyMethod(name={"emitters_count"})
    public IRubyObject emittersCount(ThreadContext context) {
        return RubyFixnum.newFixnum((Ruby)context.runtime, (long)this.registeredEmitters.size());
    }

    @JRubyMethod(name={"hooks_count"}, optional=1)
    public IRubyObject hooksCount(ThreadContext context, IRubyObject[] args) {
        List<IRubyObject> callbacks;
        IRubyObject emitterScope;
        IRubyObject iRubyObject = emitterScope = args.length > 0 ? args[0] : context.nil;
        int hooksCount = emitterScope.isNil() ? this.registeredHooks.values().stream().mapToInt(List::size).sum() : ((callbacks = this.registeredHooks.get(emitterScope)) == null ? 0 : this.registeredHooks.get(emitterScope).size());
        return RubyFixnum.newFixnum((Ruby)context.runtime, (long)hooksCount);
    }

    @JRubyMethod(name={"registered_hook?"})
    public IRubyObject ifRegisteredHook(ThreadContext context, IRubyObject emitterScope, IRubyObject klass) {
        List<IRubyObject> callbacks = this.registeredHooks.get(emitterScope);
        if (callbacks == null) {
            return context.fals;
        }
        return callbacks.stream().map(IRubyObject::getMetaClass).anyMatch(clazz -> clazz.eql(klass)) ? context.tru : context.fals;
    }

    private IRubyObject syncHooks(ThreadContext context) {
        this.registeredEmitters.forEach((emitter, dispatcher) -> {
            List<IRubyObject> listeners = this.registeredHooks.get(emitter);
            if (listeners != null) {
                for (IRubyObject listener : listeners) {
                    dispatcher.callMethod(context, "add_listener", listener);
                }
            }
        });
        return context.nil;
    }
}

