/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zipwriter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultMimeRegistry;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipContentLocation;

public class ZipRepository
implements Repository {
    private ZipOutputStream zipOutputStream;
    private MimeRegistry mimeRegistry;
    private ZipContentLocation root;

    public ZipRepository(OutputStream out, int level, MimeRegistry mimeRegistry) {
        if (out == null) {
            throw new NullPointerException();
        }
        if (mimeRegistry == null) {
            throw new NullPointerException();
        }
        this.mimeRegistry = mimeRegistry;
        this.zipOutputStream = new ZipOutputStream(out);
        this.zipOutputStream.setLevel(level);
        this.root = new ZipContentLocation(this, null, "");
    }

    public ZipRepository(OutputStream out, int level) {
        this(out, level, new DefaultMimeRegistry());
    }

    public ZipRepository(OutputStream out) {
        this(out, -1, new DefaultMimeRegistry());
    }

    public ContentLocation getRoot() throws ContentIOException {
        return this.root;
    }

    public MimeRegistry getMimeRegistry() {
        return this.mimeRegistry;
    }

    public void close() throws IOException {
        this.zipOutputStream.finish();
        this.zipOutputStream.flush();
    }

    public void writeDirectory(ZipEntry entry) throws IOException {
        this.zipOutputStream.putNextEntry(entry);
    }

    public void writeContent(ZipEntry entry, InputStream in, int method, int compression) throws IOException {
        this.zipOutputStream.setMethod(method);
        this.zipOutputStream.setLevel(compression);
        this.zipOutputStream.putNextEntry(entry);
        IOUtils.getInstance().copyStreams(in, (OutputStream)this.zipOutputStream);
        this.zipOutputStream.closeEntry();
    }
}

