/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.api.ResourceFile;
import jadx.api.ResourcesLoader;
import jadx.core.codegen.CodeWriter;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.core.utils.files.ZipSecurity;
import jadx.core.xmlgen.ResContainer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesSaver
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesSaver.class);
    private final ResourceFile resourceFile;
    private File outDir;

    public ResourcesSaver(File outDir, ResourceFile resourceFile) {
        this.resourceFile = resourceFile;
        this.outDir = outDir;
    }

    @Override
    public void run() {
        this.saveResources(this.resourceFile.loadContent());
    }

    private void saveResources(ResContainer rc) {
        if (rc == null) {
            return;
        }
        if (rc.getDataType() == ResContainer.DataType.RES_TABLE) {
            this.saveToFile(rc, new File(this.outDir, "res/values/public.xml"));
            for (ResContainer subFile : rc.getSubFiles()) {
                this.saveResources(subFile);
            }
        } else {
            this.save(rc, this.outDir);
        }
    }

    private void save(ResContainer rc, File outDir) {
        File outFile = new File(outDir, rc.getFileName());
        if (!ZipSecurity.isInSubDirectory(outDir, outFile)) {
            LOG.error("Path traversal attack detected, invalid resource name: {}", (Object)outFile.getPath());
            return;
        }
        this.saveToFile(rc, outFile);
    }

    private void saveToFile(ResContainer rc, File outFile) {
        switch (rc.getDataType()) {
            case TEXT: 
            case RES_TABLE: {
                CodeWriter cw = rc.getText();
                cw.save(outFile);
                return;
            }
            case DECODED_DATA: {
                byte[] data = rc.getDecodedData();
                FileUtils.makeDirsForFile(outFile);
                try {
                    Files.write(outFile.toPath(), data, new OpenOption[0]);
                }
                catch (Exception e) {
                    LOG.warn("Resource '{}' not saved, got exception", (Object)rc.getName(), (Object)e);
                }
                return;
            }
            case RES_LINK: {
                ResourceFile resFile = rc.getResLink();
                FileUtils.makeDirsForFile(outFile);
                try {
                    this.saveResourceFile(resFile, outFile);
                }
                catch (Exception e) {
                    LOG.warn("Resource '{}' not saved, got exception", (Object)rc.getName(), (Object)e);
                }
                return;
            }
        }
        LOG.warn("Resource '{}' not saved, unknown type", (Object)rc.getName());
    }

    private void saveResourceFile(ResourceFile resFile, File outFile) throws JadxException {
        ResourcesLoader.decodeStream(resFile, (size, is) -> {
            try (FileOutputStream fileStream = new FileOutputStream(outFile);){
                IOUtils.copy((InputStream)is, (OutputStream)fileStream);
            }
            catch (Exception e) {
                throw new JadxRuntimeException("Resource file save error", e);
            }
            return null;
        });
    }
}

