/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.codegen.TypeGen;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.nodes.EnumClassAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.CodeShrinker;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@JadxVisitor(name="EnumVisitor", desc="Restore enum classes", runAfter={CodeShrinker.class, ModVisitor.class})
public class EnumVisitor
extends AbstractVisitor {
    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        if (!cls.isEnum()) {
            return true;
        }
        MethodNode staticMethod = null;
        for (MethodNode mth : cls.getMethods()) {
            MethodInfo mi = mth.getMethodInfo();
            if (!mi.isClassInit()) continue;
            staticMethod = mth;
            break;
        }
        if (staticMethod == null) {
            ErrorsCounter.classWarn(cls, "Enum class init method not found");
            return true;
        }
        ArgType clsType = cls.getClassInfo().getType();
        String enumConstructor = "<init>(Ljava/lang/String;I)V";
        String valuesOfMethod = "valueOf(Ljava/lang/String;)" + TypeGen.signature(clsType);
        String valuesMethod = "values()" + TypeGen.signature(ArgType.array(clsType));
        ArrayList<FieldNode> enumFields = new ArrayList<FieldNode>();
        for (FieldNode f : cls.getFields()) {
            if (f.getAccessFlags().isEnum()) {
                enumFields.add(f);
                f.add(AFlag.DONT_GENERATE);
                continue;
            }
            if (!f.getAccessFlags().isSynthetic()) continue;
            f.add(AFlag.DONT_GENERATE);
        }
        for (MethodNode mth : cls.getMethods()) {
            MethodInfo mi = mth.getMethodInfo();
            if (mi.isClassInit()) continue;
            String shortId = mi.getShortId();
            boolean isSynthetic = mth.getAccessFlags().isSynthetic();
            if (mi.isConstructor() && !isSynthetic) {
                if (!shortId.equals(enumConstructor)) continue;
                mth.add(AFlag.DONT_GENERATE);
                continue;
            }
            if (!isSynthetic && !shortId.equals(valuesMethod) && !shortId.equals(valuesOfMethod)) continue;
            mth.add(AFlag.DONT_GENERATE);
        }
        EnumClassAttr attr = new EnumClassAttr(enumFields.size());
        cls.addAttr(attr);
        attr.setStaticMethod(staticMethod);
        ClassInfo classInfo = cls.getClassInfo();
        BlockNode staticBlock = staticMethod.getBasicBlocks().get(0);
        ArrayList<InsnNode> enumPutInsns = new ArrayList<InsnNode>();
        List<InsnNode> list = staticBlock.getInstructions();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            FieldInfo f;
            InsnNode insn = list.get(i);
            if (insn.getType() != InsnType.SPUT || !(f = (FieldInfo)((IndexInsnNode)insn).getIndex()).getDeclClass().equals(classInfo)) continue;
            FieldNode fieldNode = cls.searchField(f);
            if (fieldNode != null && this.isEnumArrayField(classInfo, fieldNode)) {
                if (i == size - 1) {
                    staticMethod.add(AFlag.DONT_GENERATE);
                    break;
                }
                list.subList(0, i + 1).clear();
                break;
            }
            enumPutInsns.add(insn);
        }
        for (InsnNode putInsn : enumPutInsns) {
            ConstructorInsn co = this.getConstructorInsn(putInsn);
            if (co == null || co.getArgsCount() < 2) continue;
            ClassInfo clsInfo = co.getClassType();
            ClassNode constrCls = cls.dex().resolveClass(clsInfo);
            if (constrCls == null || !clsInfo.equals(classInfo) && !constrCls.getAccessFlags().isEnum()) continue;
            FieldInfo fieldInfo = (FieldInfo)((IndexInsnNode)putInsn).getIndex();
            String name = this.getConstString(cls.dex(), co.getArg(0));
            if (name != null && !fieldInfo.getAlias().equals(name) && NameMapper.isValidIdentifier(name)) {
                fieldInfo.setAlias(name);
            }
            EnumClassAttr.EnumField field = new EnumClassAttr.EnumField(fieldInfo, co, 2);
            attr.getFields().add(field);
            if (co.getClassType().equals(classInfo)) continue;
            for (ClassNode innerCls : cls.getInnerClasses()) {
                EnumVisitor.processEnumInnerCls(co, field, innerCls);
            }
        }
        return false;
    }

    private static void processEnumInnerCls(ConstructorInsn co, EnumClassAttr.EnumField field, ClassNode innerCls) {
        if (!innerCls.getClassInfo().equals(co.getClassType())) {
            return;
        }
        for (MethodNode innerMth : innerCls.getMethods()) {
            if (!innerMth.getAccessFlags().isConstructor()) continue;
            innerMth.add(AFlag.DONT_GENERATE);
        }
        field.setCls(innerCls);
        innerCls.add(AFlag.DONT_GENERATE);
    }

    private boolean isEnumArrayField(ClassInfo classInfo, FieldNode fieldNode) {
        if (fieldNode.getAccessFlags().isSynthetic()) {
            ArgType fType = fieldNode.getType();
            return fType.isArray() && fType.getArrayRootElement().equals(classInfo.getType());
        }
        return false;
    }

    private ConstructorInsn getConstructorInsn(InsnNode putInsn) {
        if (putInsn.getArgsCount() != 1) {
            return null;
        }
        InsnArg arg = putInsn.getArg(0);
        if (arg.isInsnWrap()) {
            return this.castConstructorInsn(((InsnWrapArg)arg).getWrapInsn());
        }
        if (arg.isRegister()) {
            return this.castConstructorInsn(((RegisterArg)arg).getAssignInsn());
        }
        return null;
    }

    @Nullable
    private ConstructorInsn castConstructorInsn(InsnNode coCandidate) {
        if (coCandidate != null && coCandidate.getType() == InsnType.CONSTRUCTOR) {
            return (ConstructorInsn)coCandidate;
        }
        return null;
    }

    private String getConstString(DexNode dex, InsnArg arg) {
        InsnNode constInsn;
        Object constValue;
        if (arg.isInsnWrap() && (constValue = InsnUtils.getConstValueByInsn(dex, constInsn = ((InsnWrapArg)arg).getWrapInsn())) instanceof String) {
            return (String)constValue;
        }
        return null;
    }
}

