/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings;

import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsAdapter;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.EditorTheme;
import jadx.gui.utils.LangLocale;
import jadx.gui.utils.NLS;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import say.swing.JFontChooser;

public class JadxSettingsWindow
extends JDialog {
    private static final long serialVersionUID = -1804570470377354148L;
    private static final Logger LOG = LoggerFactory.getLogger(JadxSettingsWindow.class);
    private final transient MainWindow mainWindow;
    private final transient JadxSettings settings;
    private final transient String startSettings;
    private final transient LangLocale prevLang;
    private transient boolean needReload = false;

    public JadxSettingsWindow(MainWindow mainWindow, JadxSettings settings) {
        this.mainWindow = mainWindow;
        this.settings = settings;
        this.startSettings = JadxSettingsAdapter.makeString(settings);
        this.prevLang = settings.getLangLocale();
        this.initUI();
        this.setTitle(NLS.str("preferences.title"));
        this.setSize(400, 550);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void initUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.makeDeobfuscationGroup());
        panel.add(this.makeDecompilationGroup());
        panel.add(this.makeEditorGroup());
        panel.add(this.makeOtherGroup());
        JButton saveBtn = new JButton(NLS.str("preferences.save"));
        saveBtn.addActionListener(event -> {
            this.settings.sync();
            if (this.needReload) {
                this.mainWindow.reOpenFile();
            }
            if (!this.settings.getLangLocale().equals(this.prevLang)) {
                JOptionPane.showMessageDialog(this, NLS.str("msg.language_changed", this.settings.getLangLocale()), NLS.str("msg.language_changed_title", this.settings.getLangLocale()), 1);
            }
            this.dispose();
        });
        JButton cancelButton = new JButton(NLS.str("preferences.cancel"));
        cancelButton.addActionListener(event -> {
            JadxSettingsAdapter.fill(this.settings, this.startSettings);
            this.dispose();
        });
        JButton resetBtn = new JButton(NLS.str("preferences.reset"));
        resetBtn.addActionListener(event -> {
            int res = JOptionPane.showConfirmDialog(this, NLS.str("preferences.reset_message"), NLS.str("preferences.reset_title"), 0);
            if (res == 0) {
                String defaults = JadxSettingsAdapter.makeString(JadxSettings.makeDefault());
                JadxSettingsAdapter.fill(this.settings, defaults);
                this.getContentPane().removeAll();
                this.initUI();
                this.pack();
                this.repaint();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(resetBtn);
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(saveBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)panel, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.getRootPane().setDefaultButton(saveBtn);
    }

    private SettingsGroup makeDeobfuscationGroup() {
        JCheckBox deobfOn = new JCheckBox();
        deobfOn.setSelected(this.settings.isDeobfuscationOn());
        deobfOn.addItemListener(e -> {
            this.settings.setDeobfuscationOn(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox deobfForce = new JCheckBox();
        deobfForce.setSelected(this.settings.isDeobfuscationForceSave());
        deobfForce.addItemListener(e -> {
            this.settings.setDeobfuscationForceSave(e.getStateChange() == 1);
            this.needReload();
        });
        SpinnerNumberModel minLenModel = new SpinnerNumberModel(this.settings.getDeobfuscationMinLength(), 0, Integer.MAX_VALUE, 1);
        JSpinner minLenSpinner = new JSpinner(minLenModel);
        minLenSpinner.addChangeListener(e -> {
            this.settings.setDeobfuscationMinLength((Integer)minLenSpinner.getValue());
            this.needReload();
        });
        SpinnerNumberModel maxLenModel = new SpinnerNumberModel(this.settings.getDeobfuscationMaxLength(), 0, Integer.MAX_VALUE, 1);
        JSpinner maxLenSpinner = new JSpinner(maxLenModel);
        maxLenSpinner.addChangeListener(e -> {
            this.settings.setDeobfuscationMaxLength((Integer)maxLenSpinner.getValue());
            this.needReload();
        });
        JCheckBox deobfSourceAlias = new JCheckBox();
        deobfSourceAlias.setSelected(this.settings.isDeobfuscationUseSourceNameAsAlias());
        deobfSourceAlias.addItemListener(e -> {
            this.settings.setDeobfuscationUseSourceNameAsAlias(e.getStateChange() == 1);
            this.needReload();
        });
        SettingsGroup deobfGroup = new SettingsGroup(NLS.str("preferences.deobfuscation"));
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_on"), deobfOn);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_force"), deobfForce);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_min_len"), minLenSpinner);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_max_len"), maxLenSpinner);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_source_alias"), deobfSourceAlias);
        deobfGroup.end();
        List<JComponent> connectedComponents = Arrays.asList(deobfForce, minLenSpinner, maxLenSpinner, deobfSourceAlias);
        deobfOn.addItemListener(e -> this.enableComponentList(connectedComponents, e.getStateChange() == 1));
        this.enableComponentList(connectedComponents, this.settings.isDeobfuscationOn());
        return deobfGroup;
    }

    private void enableComponentList(Collection<JComponent> connectedComponents, boolean enabled) {
        connectedComponents.forEach(comp -> comp.setEnabled(enabled));
    }

    private SettingsGroup makeEditorGroup() {
        JButton fontBtn = new JButton(NLS.str("preferences.select_font"));
        fontBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JFontChooser fontChooser = new JFontChooser();
                fontChooser.setSelectedFont(JadxSettingsWindow.this.settings.getFont());
                int result = fontChooser.showDialog(JadxSettingsWindow.this);
                if (result == 0) {
                    Font font = fontChooser.getSelectedFont();
                    LOG.debug("Selected Font: {}", (Object)font);
                    JadxSettingsWindow.this.settings.setFont(font);
                    JadxSettingsWindow.this.mainWindow.updateFont(font);
                    JadxSettingsWindow.this.mainWindow.loadSettings();
                }
            }
        });
        EditorTheme[] editorThemes = EditorTheme.getAllThemes();
        JComboBox<EditorTheme> themesCbx = new JComboBox<EditorTheme>(editorThemes);
        for (EditorTheme theme : editorThemes) {
            if (!theme.getPath().equals(this.settings.getEditorThemePath())) continue;
            themesCbx.setSelectedItem(theme);
            break;
        }
        themesCbx.addActionListener(e -> {
            int i = themesCbx.getSelectedIndex();
            EditorTheme editorTheme = editorThemes[i];
            this.settings.setEditorThemePath(editorTheme.getPath());
            this.mainWindow.loadSettings();
        });
        SettingsGroup other = new SettingsGroup(NLS.str("preferences.editor"));
        other.addRow(NLS.str("preferences.font"), fontBtn);
        other.addRow(NLS.str("preferences.theme"), themesCbx);
        return other;
    }

    private SettingsGroup makeDecompilationGroup() {
        JCheckBox fallback = new JCheckBox();
        fallback.setSelected(this.settings.isFallbackMode());
        fallback.addItemListener(e -> {
            this.settings.setFallbackMode(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox showInconsistentCode = new JCheckBox();
        showInconsistentCode.setSelected(this.settings.isShowInconsistentCode());
        showInconsistentCode.addItemListener(e -> {
            this.settings.setShowInconsistentCode(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox resourceDecode = new JCheckBox();
        resourceDecode.setSelected(this.settings.isSkipResources());
        resourceDecode.addItemListener(e -> {
            this.settings.setSkipResources(e.getStateChange() == 1);
            this.needReload();
        });
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(this.settings.getThreadsCount(), 1, Runtime.getRuntime().availableProcessors() * 2, 1);
        JSpinner threadsCount = new JSpinner(spinnerModel);
        threadsCount.addChangeListener(e -> {
            this.settings.setThreadsCount((Integer)threadsCount.getValue());
            this.needReload();
        });
        JButton editExcludedPackages = new JButton(NLS.str("preferences.excludedPackages.button"));
        editExcludedPackages.addActionListener(event -> {
            String result = JOptionPane.showInputDialog(this, NLS.str("preferences.excludedPackages.editDialog"), this.settings.getExcludedPackages());
            if (result != null) {
                this.settings.setExcludedPackages(result);
            }
        });
        JCheckBox autoStartJobs = new JCheckBox();
        autoStartJobs.setSelected(this.settings.isAutoStartJobs());
        autoStartJobs.addItemListener(e -> this.settings.setAutoStartJobs(e.getStateChange() == 1));
        JCheckBox escapeUnicode = new JCheckBox();
        escapeUnicode.setSelected(this.settings.escapeUnicode());
        escapeUnicode.addItemListener(e -> {
            this.settings.setEscapeUnicode(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox replaceConsts = new JCheckBox();
        replaceConsts.setSelected(this.settings.isReplaceConsts());
        replaceConsts.addItemListener(e -> {
            this.settings.setReplaceConsts(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox respectBytecodeAccessModifiers = new JCheckBox();
        respectBytecodeAccessModifiers.setSelected(this.settings.isRespectBytecodeAccessModifiers());
        respectBytecodeAccessModifiers.addItemListener(e -> {
            this.settings.setRespectBytecodeAccessModifiers(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox useImports = new JCheckBox();
        useImports.setSelected(this.settings.isUseImports());
        useImports.addItemListener(e -> {
            this.settings.setUseImports(e.getStateChange() == 1);
            this.needReload();
        });
        SettingsGroup other = new SettingsGroup(NLS.str("preferences.decompile"));
        other.addRow(NLS.str("preferences.threads"), threadsCount);
        other.addRow(NLS.str("preferences.excludedPackages"), NLS.str("preferences.excludedPackages.tooltip"), editExcludedPackages);
        other.addRow(NLS.str("preferences.start_jobs"), autoStartJobs);
        other.addRow(NLS.str("preferences.showInconsistentCode"), showInconsistentCode);
        other.addRow(NLS.str("preferences.escapeUnicode"), escapeUnicode);
        other.addRow(NLS.str("preferences.replaceConsts"), replaceConsts);
        other.addRow(NLS.str("preferences.respectBytecodeAccessModifiers"), respectBytecodeAccessModifiers);
        other.addRow(NLS.str("preferences.useImports"), useImports);
        other.addRow(NLS.str("preferences.fallback"), fallback);
        other.addRow(NLS.str("preferences.skipResourcesDecode"), resourceDecode);
        return other;
    }

    private SettingsGroup makeOtherGroup() {
        JComboBox<LangLocale> languageCbx = new JComboBox<LangLocale>(NLS.getI18nLocales());
        for (LangLocale locale : NLS.getI18nLocales()) {
            if (!locale.equals(this.settings.getLangLocale())) continue;
            languageCbx.setSelectedItem(locale);
            break;
        }
        languageCbx.addActionListener(e -> this.settings.setLangLocale((LangLocale)languageCbx.getSelectedItem()));
        JCheckBox update = new JCheckBox();
        update.setSelected(this.settings.isCheckForUpdates());
        update.addItemListener(e -> this.settings.setCheckForUpdates(e.getStateChange() == 1));
        JCheckBox cfg = new JCheckBox();
        cfg.setSelected(this.settings.isCfgOutput());
        cfg.addItemListener(e -> {
            this.settings.setCfgOutput(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox rawCfg = new JCheckBox();
        rawCfg.setSelected(this.settings.isRawCfgOutput());
        rawCfg.addItemListener(e -> {
            this.settings.setRawCfgOutput(e.getStateChange() == 1);
            this.needReload();
        });
        SettingsGroup other = new SettingsGroup(NLS.str("preferences.other"));
        other.addRow(NLS.str("preferences.language"), languageCbx);
        other.addRow(NLS.str("preferences.check_for_updates"), update);
        other.addRow(NLS.str("preferences.cfg"), cfg);
        other.addRow(NLS.str("preferences.raw_cfg"), rawCfg);
        return other;
    }

    private void needReload() {
        this.needReload = true;
    }

    private static class SettingsGroup
    extends JPanel {
        private static final long serialVersionUID = -6487309975896192544L;
        private final GridBagConstraints c;
        private int row;

        public SettingsGroup(String title) {
            this.setBorder(BorderFactory.createTitledBorder(title));
            this.setLayout(new GridBagLayout());
            this.c = new GridBagConstraints();
            this.c.insets = new Insets(5, 5, 5, 5);
            this.c.weighty = 1.0;
        }

        public void addRow(String label, JComponent comp) {
            this.addRow(label, null, comp);
        }

        public void addRow(String label, String tooltip, JComponent comp) {
            this.c.gridy = this.row++;
            JLabel jLabel = new JLabel(label);
            jLabel.setLabelFor(comp);
            jLabel.setHorizontalAlignment(2);
            this.c.gridx = 0;
            this.c.gridwidth = 1;
            this.c.anchor = 21;
            this.c.weightx = 0.8;
            this.c.fill = 0;
            this.add((Component)jLabel, this.c);
            this.c.gridx = 1;
            this.c.gridwidth = 0;
            this.c.anchor = 10;
            this.c.weightx = 0.2;
            this.c.fill = 2;
            if (tooltip != null) {
                jLabel.setToolTipText(tooltip);
                comp.setToolTipText(tooltip);
            }
            this.add((Component)comp, this.c);
            comp.addPropertyChangeListener("enabled", evt -> jLabel.setEnabled((Boolean)evt.getNewValue()));
        }

        public void end() {
            this.add(Box.createVerticalGlue());
        }
    }
}

