/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.javah;

import gnu.classpath.tools.javah.ClassWrapper;
import gnu.classpath.tools.javah.JniHelper;
import gnu.classpath.tools.javah.JniPrintStream;
import gnu.classpath.tools.javah.Main;
import gnu.classpath.tools.javah.Printer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class JniStubPrinter
extends Printer {
    protected JniStubPrinter(Main classpath, File outFile, boolean isDir, boolean force) {
        super(classpath, outFile, isDir, force);
    }

    protected void writePreambleImpl(PrintStream out) {
        out.println("/* This file is intended to give you a head start on implementing native");
        out.println("   methods using JNI.");
        out.println("   Be aware: running gcjh or compatible tool with '-stubs' option once more");
        out.println("   for the same input may overwrite any edits you have made to this file.  */");
    }

    protected PrintStream getPrintStreamImpl(FileOutputStream fos, ClassWrapper klass) {
        return new JniPrintStream(this.classpath, fos, klass);
    }

    public void printClass(File filename, ClassWrapper klass) throws IOException {
        if (!klass.hasNativeMethod()) {
            return;
        }
        String xname = JniHelper.mangle(klass.name);
        JniPrintStream out = (JniPrintStream)this.getPrintStream(String.valueOf(klass.name.replace('/', '_')) + ".c", klass);
        if (out == null) {
            return;
        }
        out.println();
        out.print("#include <");
        out.print(klass.name.replace('/', '_'));
        out.println(".h>");
        for (MethodNode method : klass.methods) {
            if (!Modifier.isNative(method.access)) continue;
            out.println();
            out.print(Type.getReturnType(method.desc));
            out.println();
            out.print(method, xname);
            out.println();
            out.println("{");
            out.print("  (*env)->FatalError (env, \"");
            out.print(method, xname);
            out.println(" not implemented\");");
            out.println("}");
        }
        out.close();
    }
}

