/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc.expr;

import gnu.classpath.tools.gjdoc.expr.ConstantByte;
import gnu.classpath.tools.gjdoc.expr.ConstantChar;
import gnu.classpath.tools.gjdoc.expr.ConstantDouble;
import gnu.classpath.tools.gjdoc.expr.ConstantExpression;
import gnu.classpath.tools.gjdoc.expr.ConstantFloat;
import gnu.classpath.tools.gjdoc.expr.ConstantInteger;
import gnu.classpath.tools.gjdoc.expr.ConstantLong;
import gnu.classpath.tools.gjdoc.expr.ConstantShort;
import gnu.classpath.tools.gjdoc.expr.Context;
import gnu.classpath.tools.gjdoc.expr.Expression;
import gnu.classpath.tools.gjdoc.expr.IllegalExpressionException;
import gnu.classpath.tools.gjdoc.expr.Type;
import gnu.classpath.tools.gjdoc.expr.UnaryExpression;

class TypeCastExpression
extends UnaryExpression {
    private Type type;

    public TypeCastExpression(Type type, Expression expr) {
        super(expr);
        this.type = type;
    }

    public ConstantExpression evaluate(Context context) throws IllegalExpressionException {
        ConstantExpression value = this.expr.evaluate(context);
        if (Type.BYTE == this.type) {
            return new ConstantByte(value.asNumber().byteValue());
        }
        if (Type.SHORT == this.type) {
            return new ConstantShort(value.asNumber().shortValue());
        }
        if (Type.INTEGER == this.type) {
            return new ConstantInteger(value.asNumber().intValue());
        }
        if (Type.LONG == this.type) {
            return new ConstantLong(value.asNumber().longValue());
        }
        if (Type.CHAR == this.type) {
            return new ConstantChar((char)value.asNumber().intValue());
        }
        if (Type.FLOAT == this.type) {
            return new ConstantFloat(value.asNumber().intValue());
        }
        if (Type.DOUBLE == this.type) {
            return new ConstantDouble(value.asNumber().intValue());
        }
        if (Type.BOOLEAN == this.type && Type.BOOLEAN == value.getType()) {
            return value;
        }
        if (Type.STRING == this.type && Type.STRING == value.getType()) {
            return value;
        }
        throw new IllegalExpressionException("Cannot cast " + value.getType() + " to " + this.type);
    }
}

