/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc.expr;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.sun.javadoc.FieldDoc;
import gnu.classpath.tools.gjdoc.expr.ConstantExpression;
import gnu.classpath.tools.gjdoc.expr.Context;
import gnu.classpath.tools.gjdoc.expr.EvaluatorEnvironment;
import gnu.classpath.tools.gjdoc.expr.Expression;
import gnu.classpath.tools.gjdoc.expr.IllegalExpressionException;
import gnu.classpath.tools.gjdoc.expr.JavaLexer;
import gnu.classpath.tools.gjdoc.expr.JavaRecognizer;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Evaluator {
    public static Object evaluate(String expression, Set<FieldDoc> visitedFields, EvaluatorEnvironment environment) throws IllegalExpressionException {
        try {
            JavaLexer lexer = new JavaLexer(new StringReader(expression));
            JavaRecognizer recognizer = new JavaRecognizer(lexer);
            Expression e = recognizer.expression();
            ConstantExpression value = e.evaluate(new Context(environment, visitedFields));
            return value.asObject();
        }
        catch (RecognitionException e) {
            throw new IllegalExpressionException(e);
        }
        catch (TokenStreamException e) {
            throw new IllegalExpressionException(e);
        }
    }

    static int parseInt(String stringValue) {
        int base = 10;
        if (stringValue.startsWith("0x")) {
            base = 16;
            stringValue = stringValue.substring(2);
        } else if (stringValue.length() > 1 && stringValue.startsWith("0")) {
            base = 8;
            stringValue = stringValue.substring(1);
        }
        while (stringValue.length() > 1 && stringValue.startsWith("0")) {
            stringValue = stringValue.substring(1);
        }
        if (10 == base) {
            return Integer.parseInt(stringValue);
        }
        long result = Long.parseLong(stringValue, base);
        if (result > Integer.MAX_VALUE) {
            result -= 0x100000000L;
        }
        if (result > Integer.MAX_VALUE) {
            throw new NumberFormatException(String.valueOf(result) + " > " + Integer.MAX_VALUE);
        }
        if (result < Integer.MIN_VALUE) {
            throw new NumberFormatException(String.valueOf(result) + " < " + Integer.MIN_VALUE);
        }
        return (int)result;
    }

    static long parseLong(String stringValue) {
        int base = 10;
        if (stringValue.startsWith("0x")) {
            base = 16;
            stringValue = stringValue.substring(2);
        } else if (stringValue.length() > 1 && stringValue.startsWith("0")) {
            base = 8;
            stringValue = stringValue.substring(1);
        }
        while (stringValue.length() > 1 && stringValue.startsWith("0")) {
            stringValue = stringValue.substring(1);
        }
        BigInteger bigInt = new BigInteger(stringValue, base);
        long result = bigInt.longValue();
        return result;
    }
}

