/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LayoutQueue;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class AsyncBoxView
extends View {
    private int majorAxis;
    private float topInset;
    private float bottomInset;
    private float leftInset;
    private boolean estimatedMajorSpan;
    private float rightInset;
    private ArrayList childStates;
    ChildState changing;
    ChildState minReq;
    ChildState prefReq;
    private boolean majorChanged;
    boolean minorChanged;
    float majorSpan;
    float minorSpan;
    private Runnable flushTask;
    protected ChildLocator locator;

    public AsyncBoxView(Element elem, int axis) {
        super(elem);
        this.majorAxis = axis;
        this.childStates = new ArrayList();
        this.flushTask = new FlushTask();
        this.locator = new ChildLocator();
        this.minorSpan = 32767.0f;
    }

    public int getMajorAxis() {
        return this.majorAxis;
    }

    public int getMinorAxis() {
        return this.majorAxis == 0 ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View getView(int index) {
        View view = null;
        ArrayList arrayList = this.childStates;
        synchronized (arrayList) {
            if (index >= 0 && index < this.childStates.size()) {
                ChildState cs = (ChildState)this.childStates.get(index);
                view = cs.getChildView();
            }
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getViewCount() {
        ArrayList arrayList = this.childStates;
        synchronized (arrayList) {
            return this.childStates.size();
        }
    }

    public int getViewIndex(int pos, Position.Bias bias) {
        int numChildren;
        int retVal = -1;
        if (bias == Position.Bias.Backward) {
            pos = Math.max(0, pos - 1);
        }
        if ((numChildren = this.childStates.size()) > 0) {
            int i = 0;
            while (i < numChildren) {
                View child = ((ChildState)this.childStates.get(i)).getChildView();
                if (child.getStartOffset() <= pos && child.getEndOffset() > pos) {
                    retVal = i;
                    break;
                }
                ++i;
            }
        }
        return retVal;
    }

    public float getTopInset() {
        return this.topInset;
    }

    public void setTopInset(float top) {
        this.topInset = top;
    }

    public float getBottomInset() {
        return this.bottomInset;
    }

    public void setBottomInset(float bottom) {
        this.bottomInset = bottom;
    }

    public float getLeftInset() {
        return this.leftInset;
    }

    public void setLeftInset(float left) {
        this.leftInset = left;
    }

    public float getRightInset() {
        return this.rightInset;
    }

    public void setRightInset(float right) {
        this.rightInset = right;
    }

    protected void loadChildren(ViewFactory f) {
        Element e = this.getElement();
        int n = e.getElementCount();
        if (n > 0) {
            View[] added = new View[n];
            int i = 0;
            while (i < n) {
                added[i] = f.create(e.getElement(i));
                ++i;
            }
            this.replace(0, 0, added);
        }
    }

    protected float getInsetSpan(int axis) {
        float span = axis == 0 ? this.leftInset + this.rightInset : this.topInset + this.bottomInset;
        return span;
    }

    protected void setEstimatedMajorSpan(boolean estimated) {
        this.estimatedMajorSpan = estimated;
    }

    protected boolean getEstimatedMajorSpan() {
        return this.estimatedMajorSpan;
    }

    protected synchronized void minorRequirementChange(ChildState cs) {
        this.minorChanged = true;
    }

    protected void majorRequirementChange(ChildState cs, float delta) {
        if (!this.estimatedMajorSpan) {
            this.majorSpan += delta;
        }
        this.majorChanged = true;
    }

    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null && this.getViewCount() == 0) {
            ViewFactory f = this.getViewFactory();
            this.loadChildren(f);
        }
    }

    public void setSize(float width, float height) {
        float targetSpan = this.majorAxis == 0 ? height - this.getTopInset() - this.getBottomInset() : width - this.getLeftInset() - this.getRightInset();
        if (targetSpan != this.minorSpan) {
            this.minorSpan = targetSpan;
            int n = this.getViewCount();
            LayoutQueue q = this.getLayoutQueue();
            int i = 0;
            while (i < n) {
                ChildState cs = this.getChildState(i);
                cs.childSizeValid = false;
                q.addTask(cs);
                ++i;
            }
            q.addTask(this.flushTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int offset, int length, View[] views) {
        ArrayList arrayList = this.childStates;
        synchronized (arrayList) {
            LayoutQueue q = this.getLayoutQueue();
            int i = 0;
            while (i < length) {
                this.childStates.remove(offset);
                ++i;
            }
            i = views.length - 1;
            while (i >= 0) {
                this.childStates.add(offset, this.createChildState(views[i]));
                --i;
            }
            if (views.length != 0) {
                i = 0;
                while (i < views.length) {
                    ChildState cs = (ChildState)this.childStates.get(i + offset);
                    cs.getChildView().setParent(this);
                    q.addTask(cs);
                    ++i;
                }
                q.addTask(this.flushTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, Shape s) {
        ChildLocator childLocator = this.locator;
        synchronized (childLocator) {
            this.locator.setAllocation(s);
            this.locator.paintChildren(g);
        }
    }

    public float getPreferredSpan(int axis) {
        float retVal;
        if (this.majorAxis == axis) {
            retVal = this.majorSpan;
        } else if (this.prefReq != null) {
            View child = this.prefReq.getChildView();
            retVal = child.getPreferredSpan(axis);
        } else {
            retVal = axis == 0 ? this.getLeftInset() + this.getRightInset() + 30.0f : this.getTopInset() + this.getBottomInset() + 30.0f;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        ChildState cs;
        int index = this.getViewIndexAtPosition(pos, b);
        Shape ca = this.locator.getChildAllocation(index, a);
        ChildState childState = cs = this.getChildState(index);
        synchronized (childState) {
            View cv = cs.getChildView();
            Shape v = cv.modelToView(pos, ca, b);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
        int pos;
        ChildState cs;
        Shape ca;
        int index;
        ChildLocator childLocator = this.locator;
        synchronized (childLocator) {
            index = this.locator.getViewIndexAtPoint(x, y, a);
            ca = this.locator.getChildAllocation(index, a);
        }
        ChildState childState = cs = this.getChildState(index);
        synchronized (childState) {
            View v = cs.getChildView();
            pos = v.viewToModel(x, y, ca, b);
        }
        return pos;
    }

    public Shape getChildAllocation(int index, Shape a) {
        Shape ca = this.locator.getChildAllocation(index, a);
        return ca;
    }

    public float getMaximumSpan(int axis) {
        float max = axis == this.majorAxis ? this.getPreferredSpan(axis) : 32767.0f;
        return max;
    }

    public float getMinimumSpan(int axis) {
        float min;
        if (axis == this.majorAxis) {
            min = this.getPreferredSpan(axis);
        } else if (this.minReq != null) {
            View child = this.minReq.getChildView();
            min = child.getMinimumSpan(axis);
        } else {
            min = axis == 0 ? this.getLeftInset() + this.getRightInset() + 5.0f : this.getTopInset() + this.getBottomInset() + 5.0f;
        }
        return min;
    }

    public synchronized void preferenceChanged(View view, boolean width, boolean height) {
        if (view == null) {
            this.getParent().preferenceChanged(this, width, height);
        } else {
            View cv;
            if (this.changing != null && (cv = this.changing.getChildView()) == view) {
                this.changing.preferenceChanged(width, height);
                return;
            }
            int index = this.getViewIndexAtPosition(view.getStartOffset(), Position.Bias.Forward);
            ChildState cs = this.getChildState(index);
            cs.preferenceChanged(width, height);
            LayoutQueue q = this.getLayoutQueue();
            q.addTask(cs);
            q.addTask(this.flushTask);
        }
    }

    protected void updateLayout(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a) {
        if (ec != null) {
            int index = Math.max(ec.getIndex() - 1, 0);
            ChildState cs = this.getChildState(index);
            this.locator.childChanged(cs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChildState getChildState(int index) {
        ArrayList arrayList = this.childStates;
        synchronized (arrayList) {
            return (ChildState)this.childStates.get(index);
        }
    }

    protected LayoutQueue getLayoutQueue() {
        return LayoutQueue.getDefaultQueue();
    }

    protected synchronized int getViewIndexAtPosition(int pos, Position.Bias b) {
        if (b == Position.Bias.Backward) {
            pos = Math.max(0, pos - 1);
        }
        Element elem = this.getElement();
        return elem.getElementIndex(pos);
    }

    protected ChildState createChildState(View v) {
        return new ChildState(v);
    }

    protected synchronized void flushRequirementChanges() {
        View p;
        if ((this.majorChanged || this.minorChanged) && (p = this.getParent()) != null) {
            boolean vertical;
            boolean horizontal;
            if (this.majorAxis == 0) {
                horizontal = this.majorChanged;
                vertical = this.minorChanged;
            } else {
                vertical = this.majorChanged;
                horizontal = this.minorChanged;
            }
            p.preferenceChanged(this, horizontal, vertical);
            this.majorChanged = false;
            this.minorChanged = false;
            Container c = this.getContainer();
            if (c != null) {
                c.repaint();
            }
        }
    }

    public class ChildLocator {
        protected ChildState lastValidOffset;
        protected Rectangle lastAlloc = new Rectangle();
        protected Rectangle childAlloc = new Rectangle();

        public synchronized void childChanged(ChildState cs) {
            if (this.lastValidOffset == null || cs.getChildView().getStartOffset() < this.lastValidOffset.getChildView().getStartOffset()) {
                this.lastValidOffset = cs;
            }
        }

        public int getViewIndexAtPoint(float x, float y, Shape a) {
            this.setAllocation(a);
            float targetOffset = AsyncBoxView.this.getMajorAxis() == 0 ? x - (float)this.lastAlloc.x : y - (float)this.lastAlloc.y;
            int index = this.getViewIndexAtVisualOffset(targetOffset);
            return index;
        }

        public synchronized Shape getChildAllocation(int index, Shape a) {
            if (a == null) {
                return null;
            }
            this.setAllocation(a);
            ChildState cs = AsyncBoxView.this.getChildState(index);
            if (cs.getChildView().getStartOffset() > this.lastValidOffset.getChildView().getStartOffset()) {
                this.updateChildOffsetsToIndex(index);
            }
            Shape ca = this.getChildAllocation(index);
            return ca;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void paintChildren(Graphics g) {
            Rectangle clip = g.getClipBounds();
            float targetOffset = AsyncBoxView.this.getMajorAxis() == 0 ? clip.x - this.lastAlloc.x : clip.y - this.lastAlloc.y;
            int index = this.getViewIndexAtVisualOffset(targetOffset);
            int n = AsyncBoxView.this.getViewCount();
            float offs = AsyncBoxView.this.getChildState(index).getMajorOffset();
            int i = index;
            while (i < n) {
                ChildState cs = AsyncBoxView.this.getChildState(i);
                cs.setMajorOffset(offs);
                Shape ca = this.getChildAllocation(i);
                if (!ca.intersects(clip)) break;
                ChildState childState = cs;
                synchronized (childState) {
                    View v = cs.getChildView();
                    v.paint(g, ca);
                }
                offs += cs.getMajorSpan();
                ++i;
            }
        }

        protected Shape getChildAllocation(int index) {
            ChildState cs = AsyncBoxView.this.getChildState(index);
            if (!cs.isLayoutValid()) {
                cs.run();
            }
            if (AsyncBoxView.this.getMajorAxis() == 0) {
                this.childAlloc.x = this.lastAlloc.x + (int)cs.getMajorOffset();
                this.childAlloc.y = this.lastAlloc.y + (int)cs.getMinorOffset();
                this.childAlloc.width = (int)cs.getMajorSpan();
                this.childAlloc.height = (int)cs.getMinorSpan();
            } else {
                this.childAlloc.y = this.lastAlloc.y + (int)cs.getMajorOffset();
                this.childAlloc.x = this.lastAlloc.x + (int)cs.getMinorOffset();
                this.childAlloc.height = (int)cs.getMajorSpan();
                this.childAlloc.width = (int)cs.getMinorSpan();
            }
            return this.childAlloc;
        }

        protected void setAllocation(Shape a) {
            if (a instanceof Rectangle) {
                this.lastAlloc.setBounds((Rectangle)a);
            } else {
                this.lastAlloc.setBounds(a.getBounds());
            }
            AsyncBoxView.this.setSize(this.lastAlloc.width, this.lastAlloc.height);
        }

        protected int getViewIndexAtVisualOffset(float targetOffset) {
            int n = AsyncBoxView.this.getViewCount();
            if (n > 0) {
                if (this.lastValidOffset == null) {
                    this.lastValidOffset = AsyncBoxView.this.getChildState(0);
                }
                if (targetOffset > AsyncBoxView.this.majorSpan) {
                    return 0;
                }
                if (targetOffset > this.lastValidOffset.getMajorOffset()) {
                    return this.updateChildOffsets(targetOffset);
                }
                float offs = 0.0f;
                int i = 0;
                while (i < n) {
                    ChildState cs = AsyncBoxView.this.getChildState(i);
                    float nextOffs = offs + cs.getMajorSpan();
                    if (targetOffset < nextOffs) {
                        return i;
                    }
                    offs = nextOffs;
                    ++i;
                }
            }
            return n - 1;
        }

        private int updateChildOffsets(float targetOffset) {
            float start;
            int n = AsyncBoxView.this.getViewCount();
            int targetIndex = n - 1;
            int pos = this.lastValidOffset.getChildView().getStartOffset();
            int startIndex = AsyncBoxView.this.getViewIndexAtPosition(pos, Position.Bias.Forward);
            float lastOffset = start = this.lastValidOffset.getMajorOffset();
            int i = startIndex;
            while (i < n) {
                ChildState cs = AsyncBoxView.this.getChildState(i);
                cs.setMajorOffset(lastOffset);
                lastOffset += cs.getMajorSpan();
                if (targetOffset < lastOffset) {
                    targetIndex = i;
                    this.lastValidOffset = cs;
                    break;
                }
                ++i;
            }
            return targetIndex;
        }

        private void updateChildOffsetsToIndex(int index) {
            int pos = this.lastValidOffset.getChildView().getStartOffset();
            int startIndex = AsyncBoxView.this.getViewIndexAtPosition(pos, Position.Bias.Forward);
            float lastOffset = this.lastValidOffset.getMajorOffset();
            int i = startIndex;
            while (i <= index) {
                ChildState cs = AsyncBoxView.this.getChildState(i);
                cs.setMajorOffset(lastOffset);
                lastOffset += cs.getMajorSpan();
                ++i;
            }
        }
    }

    public class ChildState
    implements Runnable {
        private View childView;
        private boolean minorValid;
        private boolean majorValid;
        boolean childSizeValid;
        float minimum;
        float preferred;
        private float majorSpan;
        private float majorOffset;
        private float minorSpan;
        private float minorOffset;
        private float maximum;

        public ChildState(View view) {
            this.childView = view;
        }

        public View getChildView() {
            return this.childView;
        }

        public boolean isLayoutValid() {
            return this.minorValid && this.majorValid && this.childSizeValid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block11: {
                Document doc = AsyncBoxView.this.getDocument();
                if (doc instanceof AbstractDocument) {
                    AbstractDocument abstractDoc = (AbstractDocument)doc;
                    abstractDoc.readLock();
                }
                try {
                    if (this.minorValid && this.majorValid && this.childSizeValid || this.childView.getParent() != AsyncBoxView.this) break block11;
                    AsyncBoxView asyncBoxView = AsyncBoxView.this;
                    synchronized (asyncBoxView) {
                        AsyncBoxView.this.changing = this;
                    }
                    this.update();
                    asyncBoxView = AsyncBoxView.this;
                    synchronized (asyncBoxView) {
                        AsyncBoxView.this.changing = null;
                    }
                    this.update();
                }
                finally {
                    if (doc instanceof AbstractDocument) {
                        AbstractDocument abstractDoc = (AbstractDocument)doc;
                        abstractDoc.readUnlock();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            int majorAxis = AsyncBoxView.this.getMajorAxis();
            boolean minorUpdated = false;
            ChildState childState = this;
            synchronized (childState) {
                if (!this.minorValid) {
                    int minorAxis = AsyncBoxView.this.getMinorAxis();
                    this.minimum = this.childView.getMinimumSpan(minorAxis);
                    this.preferred = this.childView.getPreferredSpan(minorAxis);
                    this.maximum = this.childView.getMaximumSpan(minorAxis);
                    this.minorValid = true;
                    minorUpdated = true;
                }
            }
            if (minorUpdated) {
                AsyncBoxView.this.minorRequirementChange(this);
            }
            boolean majorUpdated = false;
            float delta = 0.0f;
            ChildState childState2 = this;
            synchronized (childState2) {
                if (!this.majorValid) {
                    float oldSpan = this.majorSpan;
                    this.majorSpan = this.childView.getPreferredSpan(majorAxis);
                    delta = this.majorSpan - oldSpan;
                    this.majorValid = true;
                    majorUpdated = true;
                }
            }
            if (majorUpdated) {
                AsyncBoxView.this.majorRequirementChange(this, delta);
                AsyncBoxView.this.locator.childChanged(this);
            }
            childState2 = this;
            synchronized (childState2) {
                if (!this.childSizeValid) {
                    float h;
                    float w;
                    if (majorAxis == 0) {
                        w = this.majorSpan;
                        h = this.getMinorSpan();
                    } else {
                        w = this.getMinorSpan();
                        h = this.majorSpan;
                    }
                    this.childSizeValid = true;
                    this.childView.setSize(w, h);
                }
            }
        }

        public float getMinorSpan() {
            float retVal = this.maximum < this.minorSpan ? this.maximum : Math.max(this.minimum, this.minorSpan);
            return retVal;
        }

        public float getMinorOffset() {
            float retVal;
            if (this.maximum < this.minorSpan) {
                float align = this.childView.getAlignment(AsyncBoxView.this.getMinorAxis());
                retVal = (this.minorSpan - this.maximum) * align;
            } else {
                retVal = 0.0f;
            }
            return retVal;
        }

        public float getMajorSpan() {
            return this.majorSpan;
        }

        public float getMajorOffset() {
            return this.majorOffset;
        }

        public void setMajorOffset(float offset) {
            this.majorOffset = offset;
        }

        public void preferenceChanged(boolean width, boolean height) {
            if (AsyncBoxView.this.getMajorAxis() == 0) {
                if (width) {
                    this.majorValid = false;
                }
                if (height) {
                    this.minorValid = false;
                }
            } else {
                if (width) {
                    this.minorValid = false;
                }
                if (height) {
                    this.majorValid = false;
                }
            }
            this.childSizeValid = false;
        }
    }

    private class FlushTask
    implements Runnable {
        private FlushTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Document doc = AsyncBoxView.this.getDocument();
                if (doc instanceof AbstractDocument) {
                    AbstractDocument abstractDoc = (AbstractDocument)doc;
                    abstractDoc.readLock();
                }
                int n = AsyncBoxView.this.getViewCount();
                if (AsyncBoxView.this.minorChanged && n > 0) {
                    AsyncBoxView.this.getLayoutQueue();
                    ChildState min = AsyncBoxView.this.getChildState(0);
                    ChildState pref = AsyncBoxView.this.getChildState(0);
                    int i = 1;
                    while (i < n) {
                        ChildState cs = AsyncBoxView.this.getChildState(i);
                        if (cs.minimum > min.minimum) {
                            min = cs;
                        }
                        if (cs.preferred > pref.preferred) {
                            pref = cs;
                        }
                        ++i;
                    }
                    AsyncBoxView asyncBoxView = AsyncBoxView.this;
                    synchronized (asyncBoxView) {
                        AsyncBoxView.this.minReq = min;
                        AsyncBoxView.this.prefReq = pref;
                    }
                }
                AsyncBoxView.this.flushRequirementChanges();
            }
            finally {
                Document doc = AsyncBoxView.this.getDocument();
                if (doc instanceof AbstractDocument) {
                    AbstractDocument abstractDoc = (AbstractDocument)doc;
                    abstractDoc.readUnlock();
                }
            }
        }
    }
}

