/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuiteList;
import gnu.javax.net.ssl.provider.CompressionMethodList;
import gnu.javax.net.ssl.provider.ExtensionList;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ClientHello
implements Handshake.Body {
    protected static final int RANDOM_OFFSET = 2;
    protected static final int SESSID_OFFSET = 34;
    protected static final int SESSID_OFFSET2 = 35;
    protected ByteBuffer buffer;
    protected boolean disableExtensions;

    public ClientHello(ByteBuffer buffer) {
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        this.disableExtensions = false;
    }

    public int length() {
        int len = 35 + this.buffer.get(34);
        len += (this.buffer.getShort(len) & 0xFFFF) + 2;
        len += (this.buffer.get(len) & 0xFF) + 1;
        if (!this.disableExtensions && len + 1 < this.buffer.capacity()) {
            len += (this.buffer.getShort(len) & 0xFFFF) + 2;
        }
        return len;
    }

    public ProtocolVersion version() {
        return ProtocolVersion.getInstance(this.buffer.getShort(0));
    }

    public Random random() {
        ByteBuffer randomBuf = ((ByteBuffer)this.buffer.duplicate().position(2).limit(34)).slice();
        return new Random(randomBuf);
    }

    public byte[] sessionId() {
        int idlen = this.buffer.get(34) & 0xFF;
        byte[] sessionId = new byte[idlen];
        this.buffer.position(35);
        this.buffer.get(sessionId);
        return sessionId;
    }

    public CipherSuiteList cipherSuites() {
        int offset = this.getCipherSuitesOffset();
        ByteBuffer listBuf = ((ByteBuffer)this.buffer.duplicate().position(offset).limit(this.buffer.capacity())).slice();
        return new CipherSuiteList(listBuf, this.version());
    }

    public CompressionMethodList compressionMethods() {
        int offset = this.getCompressionMethodsOffset();
        ByteBuffer listBuf = ((ByteBuffer)this.buffer.duplicate().position(offset).limit(this.buffer.capacity())).slice();
        return new CompressionMethodList(listBuf);
    }

    public boolean hasExtensions() {
        int offset = this.getExtensionsOffset();
        return offset + 1 < this.buffer.limit();
    }

    public ExtensionList extensions() {
        int offset = this.getExtensionsOffset();
        if (offset + 1 >= this.buffer.limit()) {
            return null;
        }
        int len = this.buffer.getShort(offset) & 0xFFFF;
        if (len == 0) {
            len = this.buffer.limit() - offset - 2;
        }
        ByteBuffer ebuf = ((ByteBuffer)this.buffer.duplicate().position(offset).limit(offset + len + 2)).slice();
        return new ExtensionList(ebuf);
    }

    public int extensionsLength() {
        if (this.hasExtensions()) {
            return 0;
        }
        return this.buffer.getShort(this.getExtensionsOffset()) & 0xFFFF;
    }

    protected int getCipherSuitesOffset() {
        return 35 + (this.buffer.get(34) & 0xFF);
    }

    protected int getCompressionMethodsOffset() {
        int csOffset = this.getCipherSuitesOffset();
        int csLen = this.buffer.getShort(csOffset) & 0xFFFF;
        return csOffset + csLen + 2;
    }

    protected int getExtensionsOffset() {
        int cmOffset = this.getCompressionMethodsOffset();
        return (this.buffer.get(cmOffset) & 0xFF) + cmOffset + 1;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        String subprefix = "  ";
        if (prefix != null) {
            subprefix = String.valueOf(subprefix) + prefix;
        }
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  version: ");
        out.print(this.version());
        out.println(";");
        out.print(subprefix);
        out.println("random:");
        out.print(this.random().toString(subprefix));
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  sessionId: ");
        out.print(Util.toHexString(this.sessionId(), ':'));
        out.println(";");
        out.print(subprefix);
        out.println("cipher_suites:");
        out.println(this.cipherSuites().toString(subprefix));
        out.print(subprefix);
        out.println("compression_methods:");
        out.println(this.compressionMethods().toString(subprefix));
        out.print(subprefix);
        out.print("extensions: ");
        ExtensionList el = this.extensions();
        out.println(el != null ? el.toString(String.valueOf(subprefix) + "  ") : "(nil)");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} ClientHello;");
        return str.toString();
    }
}

