/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.Util;
import gnu.java.security.x509.ext.Extension;
import gnu.java.security.x509.ext.GeneralNames;
import java.io.IOException;
import java.math.BigInteger;

public class AuthorityKeyIdentifier
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.35");
    private final byte[] keyIdentifier;
    private final GeneralNames authorityCertIssuer;
    private final BigInteger authorityCertSerialNumber;

    public AuthorityKeyIdentifier(byte[] encoded) throws IOException {
        super(encoded);
        DERReader der = new DERReader(encoded);
        DERValue val = der.read();
        if (!val.isConstructed()) {
            throw new IOException("malformed AuthorityKeyIdentifier");
        }
        if (val.getLength() > 0) {
            val = der.read();
        }
        if (val.getTagClass() == 64 && val.getTag() == 0) {
            this.keyIdentifier = (byte[])val.getValue();
            val = der.read();
        } else {
            this.keyIdentifier = null;
        }
        if (val.getTagClass() == 64 && val.getTag() == 1) {
            byte[] b = val.getEncoded();
            b[0] = 48;
            this.authorityCertIssuer = new GeneralNames(b);
            der.skip(val.getLength());
            val = der.read();
        } else {
            this.authorityCertIssuer = null;
        }
        this.authorityCertSerialNumber = val.getTagClass() == 64 && val.getTag() == 2 ? new BigInteger((byte[])val.getValue()) : null;
    }

    public byte[] getKeyIdentifier() {
        return this.keyIdentifier != null ? (byte[])this.keyIdentifier.clone() : null;
    }

    public GeneralNames getAuthorityCertIssuer() {
        return this.authorityCertIssuer;
    }

    public BigInteger getAuthorityCertSerialNumber() {
        return this.authorityCertSerialNumber;
    }

    public String toString() {
        return String.valueOf(AuthorityKeyIdentifier.class.getName()) + " [ keyId=" + (this.keyIdentifier != null ? Util.toHexString(this.keyIdentifier, ':') : "nil") + " authorityCertIssuer=" + this.authorityCertIssuer + " authorityCertSerialNumbe=" + this.authorityCertSerialNumber + " ]";
    }
}

