/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.JavaDateMathParser;

class JavaDateFormatter
implements DateFormatter {
    private static final Map<TemporalField, Long> ROUND_UP_BASE_FIELDS = new HashMap<TemporalField, Long>(6);
    private final String format;
    private final DateTimeFormatter printer;
    private final DateTimeFormatter[] parsers;

    JavaDateFormatter(String format, DateTimeFormatter printer, DateTimeFormatter ... parsers) {
        ROUND_UP_BASE_FIELDS.put(ChronoField.MONTH_OF_YEAR, 1L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.DAY_OF_MONTH, 1L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.HOUR_OF_DAY, 23L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.MINUTE_OF_HOUR, 59L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.SECOND_OF_MINUTE, 59L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.MILLI_OF_SECOND, 999L);
        if (printer == null) {
            throw new IllegalArgumentException("printer may not be null");
        }
        long distinctZones = Arrays.stream(parsers).map(DateTimeFormatter::getZone).distinct().count();
        if (distinctZones > 1L) {
            throw new IllegalArgumentException("formatters must have the same time zone");
        }
        long distinctLocales = Arrays.stream(parsers).map(DateTimeFormatter::getLocale).distinct().count();
        if (distinctLocales > 1L) {
            throw new IllegalArgumentException("formatters must have the same locale");
        }
        this.parsers = parsers.length == 0 ? new DateTimeFormatter[]{printer} : parsers;
        this.format = format;
        this.printer = printer;
    }

    @Override
    public TemporalAccessor parse(String input) {
        DateTimeParseException failure = null;
        for (int i = 0; i < this.parsers.length; ++i) {
            try {
                return this.parsers[i].parse(input);
            }
            catch (DateTimeParseException e) {
                if (failure == null) {
                    failure = e;
                    continue;
                }
                failure.addSuppressed(e);
                continue;
            }
        }
        throw failure;
    }

    @Override
    public DateFormatter withZone(ZoneId zoneId) {
        if (zoneId.equals(this.parsers[0].getZone())) {
            return this;
        }
        DateTimeFormatter[] parsersWithZone = new DateTimeFormatter[this.parsers.length];
        for (int i = 0; i < this.parsers.length; ++i) {
            parsersWithZone[i] = this.parsers[i].withZone(zoneId);
        }
        return new JavaDateFormatter(this.format, this.printer.withZone(zoneId), parsersWithZone);
    }

    @Override
    public DateFormatter withLocale(Locale locale) {
        if (locale.equals(this.parsers[0].getLocale())) {
            return this;
        }
        DateTimeFormatter[] parsersWithZone = new DateTimeFormatter[this.parsers.length];
        for (int i = 0; i < this.parsers.length; ++i) {
            parsersWithZone[i] = this.parsers[i].withLocale(locale);
        }
        return new JavaDateFormatter(this.format, this.printer.withLocale(locale), parsersWithZone);
    }

    @Override
    public String format(TemporalAccessor accessor) {
        return this.printer.format(accessor);
    }

    @Override
    public String pattern() {
        return this.format;
    }

    JavaDateFormatter parseDefaulting(Map<TemporalField, Long> fields) {
        DateTimeFormatterBuilder parseDefaultingBuilder = new DateTimeFormatterBuilder().append(this.printer);
        fields.forEach(parseDefaultingBuilder::parseDefaulting);
        if (this.parsers.length == 1 && this.parsers[0].equals(this.printer)) {
            return new JavaDateFormatter(this.format, parseDefaultingBuilder.toFormatter(Locale.ROOT), new DateTimeFormatter[0]);
        }
        DateTimeFormatter[] parsersWithDefaulting = new DateTimeFormatter[this.parsers.length];
        for (int i = 0; i < this.parsers.length; ++i) {
            DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().append(this.parsers[i]);
            fields.forEach(builder::parseDefaulting);
            parsersWithDefaulting[i] = builder.toFormatter(Locale.ROOT);
        }
        return new JavaDateFormatter(this.format, parseDefaultingBuilder.toFormatter(Locale.ROOT), parsersWithDefaulting);
    }

    @Override
    public Locale locale() {
        return this.printer.getLocale();
    }

    @Override
    public ZoneId zone() {
        return this.printer.getZone();
    }

    @Override
    public DateMathParser toDateMathParser() {
        return new JavaDateMathParser(this, this.parseDefaulting(ROUND_UP_BASE_FIELDS));
    }

    public int hashCode() {
        return Objects.hash(this.locale(), this.printer.getZone(), this.format);
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        JavaDateFormatter other = (JavaDateFormatter)obj;
        return Objects.equals(this.format, other.format) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.printer.getZone(), other.printer.getZone());
    }

    public String toString() {
        return String.format(Locale.ROOT, "format[%s] locale[%s]", this.format, this.locale());
    }
}

