Drush is a command line shell and Unix scripting interface for Drupal. Drush core ships with lots of useful commands for interacting with code like modules/themes/profiles. Similarly, it runs update.php, executes sql queries and DB migrations, and misc utilities like run cron or clear cache. Drush can be extended by [3rd party commandfiles](https://www.drupal.org/project/project_module?f[2]=im_vid_3%3A4654).

[![Latest Stable Version](https://poser.pugx.org/drush/drush/v/stable.png)](https://packagist.org/packages/drush/drush) [![Total Downloads](https://poser.pugx.org/drush/drush/downloads.png)](https://packagist.org/packages/drush/drush) [![Latest Unstable Version](https://poser.pugx.org/drush/drush/v/unstable.png)](https://packagist.org/packages/drush/drush) [![License](https://poser.pugx.org/drush/drush/license.png)](https://packagist.org/packages/drush/drush)[![Documentation Status](https://readthedocs.org/projects/drush/badge/?version=master)](https://readthedocs.org/projects/drush/?badge=master)

Resources
-----------
* [Installing (and Upgrading)](http://docs.drush.org/en/master/install/)
* [General Documentation](http://docs.drush.org)
* [API Documentation](http://api.drush.org)
* [Drush Commands](http://drushcommands.com)
* Subscribe [this atom feed](https://github.com/drush-ops/drush/releases.atom) to receive notification on new releases. Also, [Version eye](https://www.versioneye.com/).
* [Drush packages available via Composer](http://packages.drush.org)
* [A list of modules that include Drush integration](https://www.drupal.org/project/project_module?f[2]=im_vid_3%3A4654&solrsort=ds_project_latest_release+desc)
* Drush comes with a [full test suite](https://github.com/drush-ops/drush/blob/master/tests/README.md) powered by [PHPUnit](https://github.com/sebastianbergmann/phpunit). Each commit gets tested by the awesome [Travis.ci continuous integration service](https://travis-ci.org/drush-ops/drush).

Support
-----------
* Post support requests to [Drupal Answers](http://drupal.stackexchange.com/questions/tagged/drush).
* Report bugs and request features in the [GitHub Drush Issue Queue](https://github.com/drush-ops/drush/issues).
* Use pull requests (PRs) to contribute to Drush.

FAQ
------

>  Q: What does "drush" stand for?<br>
>  A: The Drupal Shell.
>
>  Q: How do I pronounce Drush?<br>
>  A: Some people pronounce the *dru* with a long 'u' like Dr*u*pal. Fidelity points
>     go to them, but they are in the minority. Most pronounce Drush so that it
>     rhymes with hush, rush, flush, etc. This is the preferred pronunciation.
>
>  Q: Does Drush have unit tests?<br>
>  A: Drush has an excellent suite of unit tests. See 
> [tests/README.md](https://github.com/drush-ops/drush/blob/master/tests/README.md) for more information.


Credits
-----------

* Originally developed by [Arto Bendiken](http://bendiken.net) for Drupal 4.7.
* Redesigned by [Franz Heinzmann](http://unbiskant.org) in May 2007 for Drupal 5.
* Maintained by [Moshe Weitzman](http://drupal.org/moshe) with much help from
  the folks listed at https://github.com/orgs/drush-ops/people.

![Drush Logo](drush_logo-black.png)
