/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.Meta;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RtfInfoElement
extends RtfElement {
    private static final byte[] INFO_AUTHOR = "\\author".getBytes();
    private static final byte[] INFO_SUBJECT = "\\subject".getBytes();
    private static final byte[] INFO_KEYWORDS = "\\keywords".getBytes();
    private static final byte[] INFO_TITLE = "\\title".getBytes();
    private static final byte[] INFO_PRODUCER = "\\operator".getBytes();
    private static final byte[] INFO_CREATION_DATE = "\\creationdate".getBytes();
    private int infoType = -1;
    private String content = "";

    public RtfInfoElement(RtfDocument rtfDocument, Meta meta) {
        super(rtfDocument);
        this.infoType = meta.type();
        this.content = meta.getContent();
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeContent(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write(OPEN_GROUP);
        switch (this.infoType) {
            case 4: {
                outputStream.write(INFO_AUTHOR);
                break;
            }
            case 2: {
                outputStream.write(INFO_SUBJECT);
                break;
            }
            case 3: {
                outputStream.write(INFO_KEYWORDS);
                break;
            }
            case 1: {
                outputStream.write(INFO_TITLE);
                break;
            }
            case 5: {
                outputStream.write(INFO_PRODUCER);
                break;
            }
            case 6: {
                outputStream.write(INFO_CREATION_DATE);
                break;
            }
            default: {
                outputStream.write(INFO_AUTHOR);
            }
        }
        outputStream.write(DELIMITER);
        if (this.infoType == 6) {
            outputStream.write(this.convertDate(this.content).getBytes());
        } else {
            outputStream.write(this.content.getBytes());
        }
        outputStream.write(CLOSE_GROUP);
    }

    private String convertDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        try {
            Date date = simpleDateFormat.parse(string);
            simpleDateFormat = new SimpleDateFormat("\\'yr'yyyy\\'mo'MM\\'dy'dd\\'hr'HH\\'min'mm\\'sec'ss");
            return simpleDateFormat.format(date);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return "";
        }
    }
}

