/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.pkg;

import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.trans.TransMeta;

public class KettleDependencies {
    public static final String[] generalLibs = new String[]{"log4j-1.2.8.jar", "js.jar", "pentaho-1.2.0.jar", "simple-jndi-0.11.1.jar", "commons-logging.jar", "commons-pool-1.3.jar", "commons-dbcp-1.2.1.jar", "edtftpj-1.5.3.jar", "activation.jar", "mail.jar", "jsch-0.1.24.jar"};
    private String[] libraryFiles;

    public KettleDependencies(TransMeta transMeta) {
        this.extractLibraries(transMeta);
    }

    private void extractLibraries(TransMeta transMeta) {
        ArrayList<String> libraries = new ArrayList<String>();
        libraries.add("lib/kettle-engine-3.0.jar");
        for (int i = 0; i < generalLibs.length; ++i) {
            libraries.add("libext/" + generalLibs[i]);
        }
        for (int s = 0; s < transMeta.nrSteps(); ++s) {
            String[] stepLibs = transMeta.getStep(s).getStepMetaInterface().getUsedLibraries();
            if (stepLibs != null) {
                for (int i = 0; i < stepLibs.length; ++i) {
                    libraries.add("libext/" + stepLibs[i]);
                }
            }
            DatabaseMeta[] usedDatabaseConnections = transMeta.getStep(s).getStepMetaInterface().getUsedDatabaseConnections();
            for (int c = 0; c < usedDatabaseConnections.length; ++c) {
                String[] dbLibs = usedDatabaseConnections[c].getDatabaseInterface().getUsedLibraries();
                if (dbLibs == null) continue;
                for (int i = 0; i < dbLibs.length; ++i) {
                    libraries.add("libext/" + dbLibs[i]);
                }
            }
        }
        this.libraryFiles = Const.getDistinctStrings((String[])libraries.toArray(new String[libraries.size()]));
    }

    public String[] getLibraryFiles() {
        return this.libraryFiles;
    }

    public void setLibraryFiles(String[] libraryFiles) {
        this.libraryFiles = libraryFiles;
    }
}

