/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database.map;

import java.util.Hashtable;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConnectionMap {
    private Map<String, Database> map = new Hashtable<String, Database>();
    private static DatabaseConnectionMap connectionMap;

    public static final synchronized DatabaseConnectionMap getInstance() {
        if (connectionMap != null) {
            return connectionMap;
        }
        connectionMap = new DatabaseConnectionMap();
        return connectionMap;
    }

    private DatabaseConnectionMap() {
    }

    public synchronized void storeDatabase(String connectionGroup, String partitionID, Database database) {
        String key = DatabaseConnectionMap.createEntryKey(connectionGroup, partitionID, database);
        this.map.put(key, database);
    }

    public synchronized void removeConnection(String connectionGroup, String partitionID, Database database) {
        String key = DatabaseConnectionMap.createEntryKey(connectionGroup, partitionID, database);
        this.map.remove(key);
    }

    public synchronized Database getDatabase(String connectionGroup, String partitionID, Database database) {
        String key = DatabaseConnectionMap.createEntryKey(connectionGroup, partitionID, database);
        return this.map.get(key);
    }

    public static final String createEntryKey(String connectionGroup, String partitionID, Database database) {
        StringBuffer key = new StringBuffer(connectionGroup);
        key.append(':').append(database.getDatabaseMeta().getName());
        if (!Const.isEmpty((String)partitionID)) {
            key.append(':').append(partitionID);
        }
        return key.toString();
    }

    public Map<String, Database> getMap() {
        return this.map;
    }
}

