/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource.internal;

import org.linkedin.util.io.PathUtils;
import org.linkedin.util.io.ram.RAMDirectory;
import org.linkedin.util.io.ram.RAMEntry;
import org.linkedin.util.io.resource.RAMResource;
import org.linkedin.util.io.resource.ResourceFilter;
import org.linkedin.util.io.resource.internal.InternalResource;
import org.linkedin.util.io.resource.internal.InternalResourceProvider;
import org.linkedin.util.io.resource.internal.PathBasedResourceProvider;

public class RAMResourceProvider
extends PathBasedResourceProvider {
    private final RAMDirectory _root;

    public RAMResourceProvider(RAMDirectory root) {
        this(root, "/");
    }

    public RAMResourceProvider(RAMDirectory root, String rootPath) {
        super(rootPath);
        this._root = root;
    }

    @Override
    public InternalResource doBuildResource(String path) {
        return new RAMResource(this, this.getFullPath(path), path);
    }

    @Override
    public InternalResourceProvider doCreateResourceProvider(String rootPath) {
        return new RAMResourceProvider(this._root, this.getFullPath(rootPath));
    }

    @Override
    public boolean doList(String path, ResourceFilter filter) {
        if (this._root == null) {
            return false;
        }
        RAMEntry entry = this._root.getEntryByPath(path);
        if (entry instanceof RAMDirectory) {
            RAMDirectory ramDirectory = (RAMDirectory)entry;
            for (RAMEntry ramEntry : ramDirectory.ls()) {
                String resourcePath = PathUtils.addPaths(path, ramEntry.name());
                filter.accept(new RAMResource(this, this.getFullPath(resourcePath), resourcePath));
            }
            return true;
        }
        return false;
    }

    public RAMEntry getRAMEntry(String fullpath) {
        return this._root.getEntryByPath(fullpath);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RAMResourceProvider that = (RAMResourceProvider)o;
        return !(this._root != null ? !this._root.equals(that._root) : that._root != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this._root != null ? this._root.hashCode() : 0);
        return result;
    }
}

