/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.BindyType;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="dataformat,transformation,csv", title="Bindy")
@XmlRootElement(name="bindy")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BindyDataFormat
extends DataFormatDefinition {
    @XmlAttribute(required=true)
    private BindyType type;
    @XmlAttribute
    private String classType;
    @XmlAttribute
    private String locale;
    @XmlTransient
    private Class<?> clazz;

    public BindyDataFormat() {
        super("bindy");
    }

    public BindyType getType() {
        return this.type;
    }

    public void setType(BindyType type) {
        this.type = type;
    }

    public String getClassType() {
        return this.classType;
    }

    public void setClassType(String classType) {
        this.classType = classType;
    }

    public void setClassType(Class<?> classType) {
        this.clazz = classType;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.classType == null && this.clazz == null) {
            throw new IllegalArgumentException("Either packages or classType must be specified");
        }
        if (this.type == BindyType.Csv) {
            this.setDataFormatName("bindy-csv");
        } else if (this.type == BindyType.Fixed) {
            this.setDataFormatName("bindy-fixed");
        } else {
            this.setDataFormatName("bindy-kvp");
        }
        if (this.clazz == null && this.classType != null) {
            try {
                this.clazz = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.classType);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return super.createDataFormat(routeContext);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        this.setProperty(camelContext, dataFormat, "locale", this.locale);
        this.setProperty(camelContext, dataFormat, "classType", this.clazz);
    }
}

