/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.util.Locale;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.log.LogEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.processor.DefaultExchangeFormatter;
import org.apache.camel.spi.ExchangeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(LogComponent.class);
    private ExchangeFormatter exchangeFormatter;

    public LogComponent() {
        super(LogEndpoint.class);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        LoggingLevel level = this.getLoggingLevel(parameters);
        Logger providedLogger = this.getLogger(parameters);
        if (providedLogger == null) {
            Map<String, Logger> availableLoggers = this.getCamelContext().getRegistry().findByTypeWithName(Logger.class);
            if (availableLoggers.size() == 1) {
                providedLogger = availableLoggers.values().iterator().next();
                LOG.info("Using custom Logger: {}", (Object)providedLogger);
            } else if (availableLoggers.size() > 1) {
                LOG.info("More than one {} instance found in the registry. Falling back to creating logger from URI {}.", (Object)Logger.class.getName(), (Object)uri);
            }
        }
        LogEndpoint endpoint = new LogEndpoint(uri, this);
        endpoint.setLevel(level.name());
        this.setProperties(endpoint, parameters);
        if (providedLogger == null) {
            endpoint.setLoggerName(remaining);
        } else {
            endpoint.setProvidedLogger(providedLogger);
        }
        ExchangeFormatter localFormatter = this.getCamelContext().getRegistry().lookupByNameAndType("logFormatter", ExchangeFormatter.class);
        if (localFormatter != null) {
            this.setProperties(localFormatter, parameters);
        } else if (localFormatter == null && this.exchangeFormatter != null) {
            localFormatter = this.exchangeFormatter;
        } else {
            localFormatter = new DefaultExchangeFormatter();
            this.setProperties(localFormatter, parameters);
        }
        endpoint.setLocalFormatter(localFormatter);
        return endpoint;
    }

    protected LoggingLevel getLoggingLevel(Map<String, Object> parameters) {
        String levelText = this.getAndRemoveParameter(parameters, "level", String.class, "INFO");
        return LoggingLevel.valueOf(levelText.toUpperCase(Locale.ENGLISH));
    }

    protected Logger getLogger(Map<String, Object> parameters) {
        return this.getAndRemoveOrResolveReferenceParameter(parameters, "logger", Logger.class);
    }

    public ExchangeFormatter getExchangeFormatter() {
        return this.exchangeFormatter;
    }

    public void setExchangeFormatter(ExchangeFormatter exchangeFormatter) {
        this.exchangeFormatter = exchangeFormatter;
    }
}

