(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/os/fcntl#fcntl__0
    (lambda (_raw143614_ _cmd143615_)
      (let ((_r143617_
             (std/os/fcntl#_fcntl0 (std/os/fd#fd-e _raw143614_) _cmd143615_)))
        (if (not (##fxnegative? _r143617_))
            _r143617_
            (std/os/error#raise-os-error
             (##fx- _r143617_)
             std/os/fcntl#fcntl
             _raw143614_
             _cmd143615_)))))
  (define std/os/fcntl#fcntl__1
    (lambda (_raw143620_ _cmd143621_ _arg143622_)
      (let ((_r143624_
             (std/os/fcntl#_fcntl1
              (std/os/fd#fd-e _raw143620_)
              _cmd143621_
              _arg143622_)))
        (if (not (##fxnegative? _r143624_))
            _r143624_
            (std/os/error#raise-os-error
             (##fx- _r143624_)
             std/os/fcntl#fcntl
             _raw143620_
             _cmd143621_
             _arg143622_)))))
  (define std/os/fcntl#fcntl
    (lambda _g143627_
      (let ((_g143626_ (length _g143627_)))
        (cond ((##fx= _g143626_ 2) (apply std/os/fcntl#fcntl__0 _g143627_))
              ((##fx= _g143626_ 3) (apply std/os/fcntl#fcntl__1 _g143627_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/fcntl#fcntl
                _g143627_))))))
  (define std/os/fcntl#fd-getfl
    (lambda (_raw143612_)
      (std/os/fcntl#fcntl__0 _raw143612_ std/os/fcntl#F_GETFL)))
  (define std/os/fcntl#fd-setfl
    (lambda (_raw143604_ _xflags143605_)
      (let* ((_flags143607_
              (std/os/fcntl#fcntl__0 _raw143604_ std/os/fcntl#F_GETFL))
             (_flags143609_ (##fxior _flags143607_ _xflags143605_)))
        (std/os/fcntl#fcntl__1
         _raw143604_
         std/os/fcntl#F_SETFL
         _flags143609_))))
  (define std/os/fcntl#fd-setfl!
    (lambda (_raw143601_ _flags143602_)
      (std/os/fcntl#fcntl__1 _raw143601_ std/os/fcntl#F_SETFL _flags143602_)))
  (define std/os/fcntl#fd-getfd
    (lambda (_raw143599_)
      (std/os/fcntl#fcntl__0 _raw143599_ std/os/fcntl#F_GETFD)))
  (define std/os/fcntl#fd-setfd
    (lambda (_raw143591_ _xflags143592_)
      (let* ((_flags143594_
              (std/os/fcntl#fcntl__0 _raw143591_ std/os/fcntl#F_GETFD))
             (_flags143596_ (##fxior _flags143594_ _xflags143592_)))
        (std/os/fcntl#fcntl__1
         _raw143591_
         std/os/fcntl#F_SETFD
         _flags143596_))))
  (define std/os/fcntl#fd-setfd!
    (lambda (_raw143588_ _flags143589_)
      (std/os/fcntl#fcntl__1 _raw143588_ std/os/fcntl#F_SETFD _flags143589_)))
  (define std/os/fcntl#fd-set-nonblock
    (lambda (_raw143586_)
      (std/os/fcntl#fd-setfl _raw143586_ std/os/fcntl#O_NONBLOCK)))
  (define std/os/fcntl#fd-set-closeonexec
    (lambda (_raw143584_)
      (std/os/fcntl#fd-setfd _raw143584_ std/os/fcntl#FD_CLOEXEC)))
  (define std/os/fcntl#fd-set-nonblock/closeonexec
    (lambda (_raw143582_)
      (std/os/fcntl#fd-setfl _raw143582_ std/os/fcntl#O_NONBLOCK)
      (std/os/fcntl#fd-setfd _raw143582_ std/os/fcntl#FD_CLOEXEC)))
  (define-macro (define-guard guard defn)
    (if (eval `(cond-expand (,guard #t) (else #f)))
        '(begin)
        (begin (eval `(define-cond-expand-feature ,guard)) defn)))
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-macro (define-const symbol)
    (let* ((str (symbol->string symbol))
           (ref (string-append "___return (" str ");")))
      `(define ,symbol ((c-lambda () int ,ref)))))
  (define-macro (define-const* symbol)
    (let* ((str (symbol->string symbol))
           (code (string-append
                  "#ifdef "
                  str
                  "\n"
                  "___return (___FIX ("
                  str
                  "));\n"
                  "#else \n"
                  "___return (___FAL);\n"
                  "#endif")))
      `(define ,symbol ((c-lambda () scheme-object ,code)))))
  (c-declare "#include <stdlib.h>")
  (c-declare "static ___SCMOBJ ffi_free (void *ptr);")
  (c-declare
   "#ifndef ___HAVE_FFI_U8VECTOR\n#define ___HAVE_FFI_U8VECTOR\n#define U8_DATA(obj) ___CAST (___U8*, ___BODY_AS (obj, ___tSUBTYPED))\n#define U8_LEN(obj) ___HD_BYTES (___HEADER (obj))\n#endif")
  (namespace
   ("std/os/fcntl#"
    F_DUPFD
    F_GETFD
    F_SETFD
    F_GETFL
    F_SETFL
    FD_CLOEXEC
    O_CREAT
    O_EXCL
    O_NOCTTY
    O_TRUNC
    O_APPEND
    O_NONBLOCK
    O_SYNC
    O_ACCMODE
    O_RDONLY
    O_RDWR
    O_WRONLY
    O_CLOEXEC
    O_DIRECT
    O_DSYNC
    O_NOATIME
    O_NOFOLLOW
    O_TMPFILE
    _fcntl0
    _fcntl1))
  (c-declare "#include <errno.h>")
  (c-declare "#include <unistd.h>")
  (c-declare "#include <sys/types.h>")
  (c-declare "#include <sys/stat.h>")
  (c-declare "#include <fcntl.h>")
  (namespace ("std/os/fcntl#" __fcntl0 __fcntl1 __errno))
  (define-macro (define-with-errno symbol ffi-symbol args)
    `(define (,symbol ,@args)
       (declare (not interrupts-enabled))
       (let ((r (,ffi-symbol ,@args))) (if (##fx< r 0) (##fx- (__errno)) r))))
  (define-const F_DUPFD)
  (define-const F_GETFD)
  (define-const F_SETFD)
  (define-const F_GETFL)
  (define-const F_SETFL)
  (define-const FD_CLOEXEC)
  (define-const O_CREAT)
  (define-const O_EXCL)
  (define-const O_NOCTTY)
  (define-const O_TRUNC)
  (define-const O_APPEND)
  (define-const O_NONBLOCK)
  (define-const O_SYNC)
  (define-const O_ACCMODE)
  (define-const O_RDONLY)
  (define-const O_RDWR)
  (define-const O_WRONLY)
  (define-const* O_CLOEXEC)
  (define-const* O_DIRECT)
  (define-const* O_DSYNC)
  (define-const* O_EXCL)
  (define-const* O_NOATIME)
  (define-const* O_NOCTTY)
  (define-const* O_NOFOLLOW)
  (define-const* O_TMPFILE)
  (define-c-lambda __fcntl0 (int int) int "fcntl")
  (define-c-lambda __fcntl1 (int int int) int "fcntl")
  (define-c-lambda __errno () int "___return (errno);")
  (define-with-errno _fcntl0 __fcntl0 (fd cmd))
  (define-with-errno _fcntl1 __fcntl1 (fd cmd arg))
  (c-declare
   "#ifndef ___HAVE_FFI_FREE\n#define ___HAVE_FFI_FREE\n___SCMOBJ ffi_free (void *ptr)\n{\n free (ptr);\n return ___FIX (___NO_ERR);\n}\n#endif"))
