/***************************************************************************
                          cbytearray.h  -  description
                             -------------------
    begin                : Fri Mar 22 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _CBYTEARRAY_H_
#define _CBYTEARRAY_H_

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>
#include <dclib/core/cstring.h>

class DLL_EXPORT CByteArray : public CObject {
public:
	/** */
	CByteArray( unsigned long nSize = 0 );
	/** */
	virtual ~CByteArray();

	/** */
	void SetSize( unsigned long nNewSize );
	/** */
	void Append( const unsigned char * pchSrc, unsigned long nSize );
	/** */
	void Append( const char * pchSrc, unsigned long nSize ) { Append( (const unsigned char*)pchSrc, nSize ); };
	/** */
	unsigned char * Data();
	/** */
	unsigned long Size() const;
	
	/** */
	bool LoadFromFile( CString file );
	/** */
	bool SaveToFile( CString file );

private:
	/** */
	void Clear();

	/** */
	unsigned char * m_pchBuffer;
	/** */
	unsigned long m_nSize;
	/** */
	unsigned long m_nBufferSize;
};

/** */
inline unsigned char * CByteArray::Data()
{ return m_pchBuffer; }
/** */
inline unsigned long CByteArray::Size() const
{ return m_nSize; }

#endif

