/*	$OpenBSD: spleen12x24.h,v 1.2 2019/03/08 10:53:59 fcambus Exp $ */

/*
 * Copyright (c) 2018-2019 Frederic Cambus <fcambus@openbsd.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

static u_char spleen12x24_data[];

struct wsdisplay_font spleen12x24 = {
	"Spleen 12x24",			/* typeface name */
	0,				/* index */
	' ',				/* firstchar */
	256 - ' ',			/* numchars */
	WSDISPLAY_FONTENC_ISO,		/* encoding */
	12,				/* width */
	24,				/* height */
	2,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	NULL,				/* cookie */
	spleen12x24_data			/* data */
};

static u_char spleen12x24_data[] = {
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x7f, 0xe0, 	/* .**********..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x7f, 0xe0, 	/* .**********..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x1f, 0xe0, 	/* ...********..... */
	0x36, 0x00, 	/* ..**.**......... */
	0x66, 0x00, 	/* .**..**......... */
	0x66, 0x00, 	/* .**..**......... */
	0x66, 0x00, 	/* .**..**......... */
	0x66, 0x00, 	/* .**..**......... */
	0x36, 0x00, 	/* ..**.**......... */
	0x1f, 0x80, 	/* ...******....... */
	0x06, 0xc0, 	/* .....**.**...... */
	0x06, 0x60, 	/* .....**..**..... */
	0x06, 0x60, 	/* .....**..**..... */
	0x06, 0x60, 	/* .....**..**..... */
	0x06, 0x60, 	/* .....**..**..... */
	0x06, 0xc0, 	/* .....**.**...... */
	0x7f, 0x80, 	/* .********....... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0xc0, 	/* ........**...... */
	0x38, 0xc0, 	/* ..***...**...... */
	0x6d, 0x80, 	/* .**.**.**....... */
	0x6d, 0x80, 	/* .**.**.**....... */
	0x3b, 0x00, 	/* ..***.**........ */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0d, 0xc0, 	/* ....**.***...... */
	0x1b, 0x60, 	/* ...**.**.**..... */
	0x1b, 0x60, 	/* ...**.**.**..... */
	0x31, 0xc0, 	/* ..**...***...... */
	0x30, 0x00, 	/* ..**............ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x33, 0x00, 	/* ..**..**........ */
	0x61, 0xa0, 	/* .**....**.*..... */
	0x60, 0xe0, 	/* .**.....***..... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x31, 0xe0, 	/* ..**...****..... */
	0x1f, 0x30, 	/* ...*****..**.... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x70, 0x00, 	/* .***............ */
	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x70, 0x00, 	/* .***............ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0xc0, 	/* ..**....**...... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x06, 0x00, 	/* .....**......... */
	0x7f, 0xe0, 	/* .**********..... */
	0x06, 0x00, 	/* .....**......... */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x3f, 0xc0, 	/* ..********...... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xc0, 	/* ..********...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x30, 	/* ..........**.... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0xe0, 	/* .**.....***..... */
	0x61, 0xe0, 	/* .**....****..... */
	0x63, 0x60, 	/* .**...**.**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x6c, 0x60, 	/* .**.**...**..... */
	0x78, 0x60, 	/* .****....**..... */
	0x70, 0x60, 	/* .***.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0e, 0x00, 	/* ....***......... */
	0x1e, 0x00, 	/* ...****......... */
	0x36, 0x00, 	/* ..**.**......... */
	0x26, 0x00, 	/* ..*..**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x3f, 0xc0, 	/* ..********...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x60, 	/* .**......**..... */
	0x7f, 0xe0, 	/* .**********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x0f, 0x80, 	/* ....*****....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x7f, 0xe0, 	/* .**********..... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x7f, 0x80, 	/* .********....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xc0, 	/* ...*******...... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x3f, 0x80, 	/* ..*******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x30, 0x00, 	/* ..**............ */
	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0xe0, 	/* .**********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0xe0, 	/* .**********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0x00, 	/* ..**............ */
	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x30, 0x00, 	/* ..**............ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x67, 0x60, 	/* .**..***.**..... */
	0x67, 0x60, 	/* .**..***.**..... */
	0x67, 0x60, 	/* .**..***.**..... */
	0x67, 0x60, 	/* .**..***.**..... */
	0x67, 0x60, 	/* .**..***.**..... */
	0x67, 0x60, 	/* .**..***.**..... */
	0x67, 0xe0, 	/* .**..******..... */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xc0, 	/* ...*******...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x7f, 0x80, 	/* .********....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x7f, 0x80, 	/* .********....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x63, 0xe0, 	/* .**...*****..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xc0, 	/* ..********...... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x3f, 0xc0, 	/* ..********...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xc0, 	/* ..********...... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x0e, 0x00, 	/* ....***......... */
	0x7c, 0x00, 	/* .*****.......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x61, 0x80, 	/* .**....**....... */
	0x7f, 0x00, 	/* .*******........ */
	0x61, 0x80, 	/* .**....**....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x70, 0xe0, 	/* .***....***..... */
	0x79, 0xe0, 	/* .****..****..... */
	0x6f, 0x60, 	/* .**.****.**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x70, 0x60, 	/* .***.....**..... */
	0x70, 0x60, 	/* .***.....**..... */
	0x78, 0x60, 	/* .****....**..... */
	0x78, 0x60, 	/* .****....**..... */
	0x6c, 0x60, 	/* .**.**...**..... */
	0x6c, 0x60, 	/* .**.**...**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x63, 0x60, 	/* .**...**.**..... */
	0x63, 0x60, 	/* .**...**.**..... */
	0x61, 0xe0, 	/* .**....****..... */
	0x61, 0xe0, 	/* .**....****..... */
	0x60, 0xe0, 	/* .**.....***..... */
	0x60, 0xe0, 	/* .**.....***..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x63, 0x60, 	/* .**...**.**..... */
	0x33, 0xc0, 	/* ..**..****...... */
	0x1f, 0x80, 	/* ...******....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x7f, 0x80, 	/* .********....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0xe0, 	/* .**********..... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x6f, 0x60, 	/* .**.****.**..... */
	0x79, 0xe0, 	/* .****..****..... */
	0x70, 0xe0, 	/* .***....***..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xe0, 	/* ........***..... */
	0x7f, 0xc0, 	/* .*********...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0xe0, 	/* .**********..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x7f, 0xe0, 	/* .**********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0xc0, 0x00, 	/* **.............. */
	0xc0, 0x00, 	/* **.............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x7f, 0x80, 	/* .********....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x7f, 0x80, 	/* .********....... */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x04, 0x00, 	/* .....*.......... */
	0x0e, 0x00, 	/* ....***......... */
	0x1b, 0x00, 	/* ...**.**........ */
	0x31, 0x80, 	/* ..**...**....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0xc0, 0x60, 	/* **.......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0xe0, 	/* .**********..... */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0x80, 	/* ..*******....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x7f, 0x80, 	/* .********....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x07, 0xc0, 	/* .....*****...... */
	0x0e, 0x00, 	/* ....***......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x3f, 0x80, 	/* ..*******....... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xc0, 	/* ...*******...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x3f, 0x80, 	/* ..*******....... */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x78, 0x00, 	/* .****........... */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x63, 0x00, 	/* .**...**........ */
	0x66, 0x00, 	/* .**..**......... */
	0x7c, 0x00, 	/* .*****.......... */
	0x6c, 0x00, 	/* .**.**.......... */
	0x66, 0x00, 	/* .**..**......... */
	0x63, 0x00, 	/* .**...**........ */
	0x61, 0x80, 	/* .**....**....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0e, 0x00, 	/* ....***......... */
	0x07, 0xc0, 	/* .....*****...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x79, 0x80, 	/* .****..**....... */
	0x66, 0xc0, 	/* .**..**.**...... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xe0, 	/* ..*********..... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x3f, 0xc0, 	/* ..********...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x7f, 0xc0, 	/* .*********...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x3f, 0x80, 	/* ..*******....... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x0e, 0x00, 	/* ....***......... */
	0x07, 0xc0, 	/* .....*****...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x36, 0x60, 	/* ..**.**..**..... */
	0x19, 0xe0, 	/* ...**..****..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x7f, 0x80, 	/* .********....... */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0xe0, 	/* .**********..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x30, 0x00, 	/* ..**............ */
	0x7f, 0xe0, 	/* .**********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x01, 0xe0, 	/* .......****..... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x38, 0x00, 	/* ..***........... */
	0x38, 0x00, 	/* ..***........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x01, 0xe0, 	/* .......****..... */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x3c, 0x00, 	/* ..****.......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0xe0, 	/* ........***..... */
	0x00, 0xe0, 	/* ........***..... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x3c, 0x00, 	/* ..****.......... */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x38, 0x60, 	/* ..***....**..... */
	0x6c, 0x60, 	/* .**.**...**..... */
	0xc6, 0xc0, 	/* **...**.**...... */
	0xc3, 0x80, 	/* **....***....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x1f, 0xe0, 	/* ...********..... */
	0x33, 0x00, 	/* ..**..**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x33, 0x00, 	/* ..**..**........ */
	0x1f, 0xe0, 	/* ...********..... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x07, 0x00, 	/* .....***........ */
	0x0d, 0x80, 	/* ....**.**....... */
	0x18, 0xc0, 	/* ...**...**...... */
	0x18, 0xc0, 	/* ...**...**...... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x7f, 0x80, 	/* .********....... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x30, 0x00, 	/* ..**............ */
	0x30, 0x00, 	/* ..**............ */
	0x7f, 0xe0, 	/* .**********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0xc0, 	/* ..**....**...... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x19, 0x80, 	/* ...**..**....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x0f, 0x00, 	/* ....****........ */
	0x06, 0x00, 	/* .....**......... */
	0x3f, 0xc0, 	/* ..********...... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x3f, 0xc0, 	/* ..********...... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0x80, 	/* ....*****....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x31, 0x80, 	/* ..**...**....... */
	0x30, 0x00, 	/* ..**............ */
	0x18, 0x00, 	/* ...**........... */
	0x0e, 0x00, 	/* ....***......... */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x07, 0x00, 	/* .....***........ */
	0x01, 0x80, 	/* .......**....... */
	0x00, 0xc0, 	/* ........**...... */
	0x18, 0xc0, 	/* ...**...**...... */
	0x19, 0x80, 	/* ...**..**....... */
	0x1f, 0x00, 	/* ...*****........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x67, 0x60, 	/* .**..***.**..... */
	0x6c, 0x60, 	/* .**.**...**..... */
	0x6c, 0x60, 	/* .**.**...**..... */
	0x6c, 0x60, 	/* .**.**...**..... */
	0x6c, 0x60, 	/* .**.**...**..... */
	0x67, 0x60, 	/* .**..***.**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0x00, 	/* ....****........ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x0f, 0x80, 	/* ....*****....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x80, 	/* ....*****....... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x60, 	/* .....**..**..... */
	0x0c, 0xc0, 	/* ....**..**...... */
	0x19, 0x80, 	/* ...**..**....... */
	0x33, 0x00, 	/* ..**..**........ */
	0x66, 0x00, 	/* .**..**......... */
	0x33, 0x00, 	/* ..**..**........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x0c, 0xc0, 	/* ....**..**...... */
	0x06, 0x60, 	/* .....**..**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0xe0, 	/* .**********..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x6e, 0x60, 	/* .**.***..**..... */
	0x6d, 0x60, 	/* .**.**.*.**..... */
	0x6d, 0x60, 	/* .**.**.*.**..... */
	0x6e, 0x60, 	/* .**.***..**..... */
	0x6d, 0x60, 	/* .**.**.*.**..... */
	0x6d, 0x60, 	/* .**.**.*.**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x3f, 0xc0, 	/* ..********...... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xc0, 	/* ..********...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x19, 0x80, 	/* ...**..**....... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x01, 0x80, 	/* .......**....... */
	0x07, 0x00, 	/* .....***........ */
	0x01, 0x80, 	/* .......**....... */
	0x01, 0x80, 	/* .......**....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x73, 0xc0, 	/* .***..****...... */
	0x6e, 0x60, 	/* .**.***..**..... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x36, 0x60, 	/* ..**.**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x36, 0x60, 	/* ..**.**..**..... */
	0x1e, 0x60, 	/* ...****..**..... */
	0x06, 0x60, 	/* .....**..**..... */
	0x06, 0x60, 	/* .....**..**..... */
	0x06, 0x60, 	/* .....**..**..... */
	0x06, 0x60, 	/* .....**..**..... */
	0x06, 0x60, 	/* .....**..**..... */
	0x06, 0x60, 	/* .....**..**..... */
	0x06, 0x60, 	/* .....**..**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x0e, 0x00, 	/* ....***......... */
	0x1e, 0x00, 	/* ...****......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x0f, 0x00, 	/* ....****........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x66, 0x00, 	/* .**..**......... */
	0x33, 0x00, 	/* ..**..**........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x0c, 0xc0, 	/* ....**..**...... */
	0x06, 0x60, 	/* .....**..**..... */
	0x0c, 0xc0, 	/* ....**..**...... */
	0x19, 0x80, 	/* ...**..**....... */
	0x33, 0x00, 	/* ..**..**........ */
	0x66, 0x00, 	/* .**..**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x00, 	/* ...**........... */
	0x38, 0x00, 	/* ..***........... */
	0x78, 0x00, 	/* .****........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x60, 	/* ...**....**..... */
	0x18, 0xc0, 	/* ...**...**...... */
	0x3d, 0x80, 	/* ..****.**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x30, 0x00, 	/* ..**............ */
	0x66, 0x00, 	/* .**..**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0xc0, 	/* .....**.**...... */
	0x06, 0xc0, 	/* .....**.**...... */
	0x07, 0xe0, 	/* .....******..... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x00, 	/* ...**........... */
	0x38, 0x00, 	/* ..***........... */
	0x78, 0x00, 	/* .****........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x00, 	/* ...**........... */
	0x18, 0x60, 	/* ...**....**..... */
	0x18, 0xc0, 	/* ...**...**...... */
	0x3d, 0x80, 	/* ..****.**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x33, 0xc0, 	/* ..**..****...... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x60, 	/* .....**..**..... */
	0x07, 0xe0, 	/* .....******..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3c, 0x00, 	/* ..****.......... */
	0x66, 0x00, 	/* .**..**......... */
	0x06, 0x00, 	/* .....**......... */
	0x1c, 0x00, 	/* ...***.......... */
	0x06, 0x00, 	/* .....**......... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x3c, 0xc0, 	/* ..****..**...... */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x30, 0x00, 	/* ..**............ */
	0x66, 0x00, 	/* .**..**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0xc0, 	/* .....**.**...... */
	0x06, 0xc0, 	/* .....**.**...... */
	0x07, 0xe0, 	/* .....******..... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x18, 0x00, 	/* ...**........... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x1c, 0x60, 	/* ...***...**..... */
	0x3f, 0xc0, 	/* ..********...... */
	0x63, 0x80, 	/* .**...***....... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x33, 0x00, 	/* ..**..**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x7f, 0xc0, 	/* .*********...... */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0x00, 	/* .**...**........ */
	0x63, 0xe0, 	/* .**...*****..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */

	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x1c, 0x60, 	/* ...***...**..... */
	0x3f, 0xc0, 	/* ..********...... */
	0x63, 0x80, 	/* .**...***....... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xc0, 	/* ..********...... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x3f, 0xc0, 	/* ..********...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xc0, 	/* ..********...... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x3f, 0xc0, 	/* ..********...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xc0, 	/* ..********...... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x3f, 0xc0, 	/* ..********...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x1c, 0x60, 	/* ...***...**..... */
	0x3f, 0xc0, 	/* ..********...... */
	0x63, 0x80, 	/* .**...***....... */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xc0, 	/* ..********...... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x3f, 0xc0, 	/* ..********...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0xc0, 	/* .*********...... */
	0x60, 0xe0, 	/* .**.....***..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0xfc, 0x60, 	/* ******...**..... */
	0xfc, 0x60, 	/* ******...**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0xe0, 	/* .**.....***..... */
	0x7f, 0xc0, 	/* .*********...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x1c, 0x60, 	/* ...***...**..... */
	0x3f, 0xc0, 	/* ..********...... */
	0x63, 0x80, 	/* .**...***....... */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x70, 0x60, 	/* .***.....**..... */
	0x70, 0x60, 	/* .***.....**..... */
	0x78, 0x60, 	/* .****....**..... */
	0x78, 0x60, 	/* .****....**..... */
	0x6c, 0x60, 	/* .**.**...**..... */
	0x6c, 0x60, 	/* .**.**...**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x63, 0x60, 	/* .**...**.**..... */
	0x63, 0x60, 	/* .**...**.**..... */
	0x61, 0xe0, 	/* .**....****..... */
	0x61, 0xe0, 	/* .**....****..... */
	0x60, 0xe0, 	/* .**.....***..... */
	0x60, 0xe0, 	/* .**.....***..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x1c, 0x60, 	/* ...***...**..... */
	0x3f, 0xc0, 	/* ..********...... */
	0x63, 0x80, 	/* .**...***....... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x60, 	/* .........**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0xe0, 	/* .**.....***..... */
	0x61, 0xe0, 	/* .**....****..... */
	0x61, 0xe0, 	/* .**....****..... */
	0x63, 0x60, 	/* .**...**.**..... */
	0x63, 0x60, 	/* .**...**.**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x6c, 0x60, 	/* .**.**...**..... */
	0x6c, 0x60, 	/* .**.**...**..... */
	0x78, 0x60, 	/* .****....**..... */
	0x78, 0x60, 	/* .****....**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x3f, 0x80, 	/* ..*******....... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x1c, 0x60, 	/* ...***...**..... */
	0x3f, 0xc0, 	/* ..********...... */
	0x63, 0x80, 	/* .**...***....... */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xe0, 	/* ........***..... */
	0x7f, 0xc0, 	/* .*********...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1e, 0x00, 	/* ...****......... */
	0x33, 0x00, 	/* ..**..**........ */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x61, 0x80, 	/* .**....**....... */
	0x63, 0x00, 	/* .**...**........ */
	0x7f, 0x00, 	/* .*******........ */
	0x63, 0x80, 	/* .**...***....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x78, 0x60, 	/* .****....**..... */
	0x6c, 0xc0, 	/* .**.**..**...... */
	0x67, 0x80, 	/* .**..****....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0x80, 	/* ..*******....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0x80, 	/* ..*******....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0x80, 	/* ..*******....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x60, 	/* ...**....**..... */
	0x3c, 0x60, 	/* ..****...**..... */
	0x66, 0xc0, 	/* .**..**.**...... */
	0x63, 0x80, 	/* .**...***....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0x80, 	/* ..*******....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0x80, 	/* ..*******....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x19, 0x80, 	/* ...**..**....... */
	0x0f, 0x00, 	/* ....****........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0x80, 	/* ..*******....... */
	0x00, 0xc0, 	/* ........**...... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x39, 0xe0, 	/* ..***..****..... */
	0x0f, 0x60, 	/* ....****.**..... */
	0x06, 0x60, 	/* .....**..**..... */
	0x06, 0x60, 	/* .....**..**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x36, 0x00, 	/* ..**.**......... */
	0x66, 0x00, 	/* .**..**......... */
	0x66, 0x00, 	/* .**..**......... */
	0x66, 0x00, 	/* .**..**......... */
	0x37, 0x00, 	/* ..**.***........ */
	0x1d, 0xe0, 	/* ...***.****..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x00, 	/* ..**............ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0xe0, 	/* ...********..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x7f, 0xe0, 	/* .**********..... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x30, 0x00, 	/* ..**............ */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x66, 0x00, 	/* .**..**......... */
	0x3c, 0x00, 	/* ..****.......... */
	0x18, 0x00, 	/* ...**........... */
	0x3c, 0x00, 	/* ..****.......... */
	0x66, 0x00, 	/* .**..**......... */
	0x03, 0x00, 	/* ......**........ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x60, 	/* ...**....**..... */
	0x3c, 0x60, 	/* ..****...**..... */
	0x66, 0xc0, 	/* .**..**.**...... */
	0x63, 0x80, 	/* .**...***....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x60, 	/* ...**....**..... */
	0x3c, 0x60, 	/* ..****...**..... */
	0x66, 0xc0, 	/* .**..**.**...... */
	0x63, 0x80, 	/* .**...***....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x1f, 0x80, 	/* ...******....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x1f, 0x80, 	/* ...******....... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x3f, 0xc0, 	/* ..********...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x06, 0x00, 	/* .....**......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x10, 	/* ...........*.... */
	0x1f, 0xb0, 	/* ...******.**.... */
	0x30, 0xe0, 	/* ..**....***..... */
	0x60, 0xe0, 	/* .**.....***..... */
	0x61, 0xe0, 	/* .**....****..... */
	0x63, 0x60, 	/* .**...**.**..... */
	0x66, 0x60, 	/* .**..**..**..... */
	0x6c, 0x60, 	/* .**.**...**..... */
	0x78, 0x60, 	/* .****....**..... */
	0x70, 0x60, 	/* .***.....**..... */
	0x70, 0xc0, 	/* .***....**...... */
	0xdf, 0x80, 	/* **.******....... */
	0x80, 0x00, 	/* *............... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x18, 0x00, 	/* ...**........... */
	0x0c, 0x00, 	/* ....**.......... */
	0x06, 0x00, 	/* .....**......... */
	0x03, 0x00, 	/* ......**........ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x06, 0x00, 	/* .....**......... */
	0x0f, 0x00, 	/* ....****........ */
	0x19, 0x80, 	/* ...**..**....... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x01, 0x80, 	/* .......**....... */
	0x03, 0x00, 	/* ......**........ */
	0x06, 0x00, 	/* .....**......... */
	0x0c, 0x00, 	/* ....**.......... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x7f, 0x80, 	/* .********....... */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0xc0, 	/* .**.....**...... */
	0x7f, 0x80, 	/* .********....... */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */
	0x60, 0x00, 	/* .**............. */

	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x30, 0xc0, 	/* ..**....**...... */
	0x30, 0xc0, 	/* ..**....**...... */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x00, 0x00, 	/* ................ */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x60, 0x60, 	/* .**......**..... */
	0x30, 0x60, 	/* ..**.....**..... */
	0x1f, 0xe0, 	/* ...********..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0x60, 	/* .........**..... */
	0x00, 0xc0, 	/* ........**...... */
	0x7f, 0x80, 	/* .********....... */
};
