/*	$OpenBSD: octeon_pcibus_irq.h,v 1.1 2010/10/28 22:52:10 syuu Exp $	*/

/*
 * Copyright (c) 2009, 2010 Miodrag Vallat.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Octeon_Pcibus interrupt assignments
 */

#define	OCTEON_PCIBUS_INTRMASK_MBOX		0x0000000f
#define	OCTEON_PCIBUS_INTR_MBOX		0
#define	OCTEON_PCIBUS_INTRMASK_DMARDY		0x00000010
#define	OCTEON_PCIBUS_INTRMASK_DMAEMPTY	0x00000020
#define	OCTEON_PCIBUS_INTRMASK_COPYRDY		0x00000040
#define	OCTEON_PCIBUS_INTRMASK_COPYEMPTY	0x00000080
#define	OCTEON_PCIBUS_INTRMASK_COPYERR		0x00000100
#define	OCTEON_PCIBUS_INTRMASK_PCIIRQ		0x00000200
#define	OCTEON_PCIBUS_INTRMASK_MASTERERR	0x00000400
#define	OCTEON_PCIBUS_INTRMASK_SYSTEMERR	0x00000800
#define	OCTEON_PCIBUS_INTRMASK_DRAMPERR	0x00001000
#define	OCTEON_PCIBUS_INTRMASK_RETRYERR	0x00002000
#define	OCTEON_PCIBUS_INTRMASK_GPIO		0x01ff0000
#define	OCTEON_PCIBUS_INTR_GPIO		16
#define	OCTEON_PCIBUS_INTRMASK_GPIN		0x7e000000
#define	OCTEON_PCIBUS_INTR_GPIN		25

/*
 * Octeon_Pcibus interrupt handling recipes:
 */

#define	INTPRI_OCTEON_PCIBUS		(INTPRI_CLOCK + 1)
#define	INTPRI_ISA		(INTPRI_OCTEON_PCIBUS + 1)

#define	OCTEON_PCIBUS_NDIRECT		32
#define	OCTEON_PCIBUS_NISA		16
#define	OCTEON_PCIBUS_NINTS		(OCTEON_PCIBUS_NDIRECT + OCTEON_PCIBUS_NISA)
#define	OCTEON_PCIBUS_ISA_IRQ(i)	((i) + OCTEON_PCIBUS_NDIRECT)
#define	OCTEON_PCIBUS_DIRECT_IRQ(i)	(i)
#define	OCTEON_PCIBUS_IRQ_IS_ISA(i)	((i) >= OCTEON_PCIBUS_NDIRECT)
#define	OCTEON_PCIBUS_IRQ_TO_ISA(i)	((i) - OCTEON_PCIBUS_NDIRECT)

#define	OCTEON_PCIBUS_DIRECT_MASK(imask)	((imask) & ((1L << OCTEON_PCIBUS_NDIRECT) - 1))
#define	OCTEON_PCIBUS_ISA_MASK(imask)		((imask) >> OCTEON_PCIBUS_NDIRECT)

extern struct intrhand *octeon_pcibus_intrhand[OCTEON_PCIBUS_NINTS];
extern uint64_t octeon_pcibus_intem;
extern uint64_t octeon_pcibus_imask[NIPLS];
