/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.RE;
import gnu.java.util.regex.REMatch;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public final class Matcher
implements MatchResult {
    private Pattern pattern;
    private CharSequence input;
    private CharIndexed inputCharIndexed;
    private int position;
    private int appendPosition;
    private REMatch match;
    private int regionStart;
    private int regionEnd;
    private boolean transparentBounds;
    private int anchoringBounds;

    Matcher(Pattern pattern2, CharSequence input) {
        this.pattern = pattern2;
        this.input = input;
        this.inputCharIndexed = RE.makeCharIndexed(input, 0);
        this.regionStart = 0;
        this.regionEnd = input.length();
        this.transparentBounds = false;
        this.anchoringBounds = 0;
    }

    public Matcher usePattern(Pattern newPattern) {
        if (newPattern == null) {
            throw new IllegalArgumentException("The new pattern was null.");
        }
        this.pattern = newPattern;
        this.match = null;
        return this;
    }

    public Matcher appendReplacement(StringBuffer sb, String replacement) throws IllegalStateException {
        this.assertMatchOp();
        sb.append(this.input.subSequence(this.appendPosition, this.match.getStartIndex()).toString());
        sb.append(RE.getReplacement(replacement, this.match, 512));
        this.appendPosition = this.match.getEndIndex();
        return this;
    }

    public StringBuffer appendTail(StringBuffer sb) {
        sb.append(this.input.subSequence(this.appendPosition, this.input.length()).toString());
        return sb;
    }

    public int end() throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getEndIndex();
    }

    public int end(int group) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getEndIndex(group);
    }

    public boolean find() {
        boolean first = this.match == null;
        this.match = this.transparentBounds || this.regionStart == 0 && this.regionEnd == this.input.length() ? this.pattern.getRE().getMatch(this.inputCharIndexed, this.position, this.anchoringBounds) : this.pattern.getRE().getMatch(this.input.subSequence(this.regionStart, this.regionEnd), this.position, this.anchoringBounds);
        if (this.match != null) {
            int endIndex = this.match.getEndIndex();
            if (endIndex > this.input.length()) {
                this.match = null;
                return false;
            }
            if (!first && endIndex == this.position) {
                this.match = null;
                if (this.position < this.input.length() - 1) {
                    ++this.position;
                    return this.find(this.position);
                }
                return false;
            }
            this.position = endIndex;
            return true;
        }
        return false;
    }

    public boolean find(int start) {
        this.match = this.transparentBounds || this.regionStart == 0 && this.regionEnd == this.input.length() ? this.pattern.getRE().getMatch(this.inputCharIndexed, start, this.anchoringBounds) : this.pattern.getRE().getMatch(this.input.subSequence(this.regionStart, this.regionEnd), start, this.anchoringBounds);
        if (this.match != null) {
            this.position = this.match.getEndIndex();
            return true;
        }
        return false;
    }

    public String group() {
        this.assertMatchOp();
        return this.match.toString();
    }

    public String group(int group) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.toString(group);
    }

    public String replaceFirst(String replacement) {
        this.reset();
        return this.pattern.getRE().substitute(this.input, replacement, this.position, 512);
    }

    public String replaceAll(String replacement) {
        this.reset();
        return this.pattern.getRE().substituteAll(this.input, replacement, this.position, 512);
    }

    public int groupCount() {
        return this.pattern.getRE().getNumSubs();
    }

    public boolean lookingAt() {
        this.match = this.transparentBounds || this.regionStart == 0 && this.regionEnd == this.input.length() ? this.pattern.getRE().getMatch(this.inputCharIndexed, this.regionStart, this.anchoringBounds | 0x1000 | 0x40) : this.pattern.getRE().getMatch(this.input.subSequence(this.regionStart, this.regionEnd), 0, this.anchoringBounds | 0x1000);
        if (this.match != null) {
            if (this.match.getStartIndex() == 0) {
                this.position = this.match.getEndIndex();
                return true;
            }
            this.match = null;
        }
        return false;
    }

    public boolean matches() {
        this.match = this.transparentBounds || this.regionStart == 0 && this.regionEnd == this.input.length() ? this.pattern.getRE().getMatch(this.inputCharIndexed, this.regionStart, this.anchoringBounds | 0x100 | 0x1000 | 0x40) : this.pattern.getRE().getMatch(this.input.subSequence(this.regionStart, this.regionEnd), 0, this.anchoringBounds | 0x100 | 0x1000);
        if (this.match != null) {
            if (this.match.getStartIndex() == 0) {
                this.position = this.match.getEndIndex();
                if (this.position == this.input.length()) {
                    return true;
                }
            }
            this.match = null;
        }
        return false;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public Matcher reset() {
        this.position = 0;
        this.match = null;
        this.regionStart = 0;
        this.regionEnd = this.input.length();
        this.appendPosition = 0;
        return this;
    }

    public Matcher reset(CharSequence input) {
        this.input = input;
        this.inputCharIndexed = RE.makeCharIndexed(input, 0);
        return this.reset();
    }

    public int start() throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getStartIndex();
    }

    public int start(int group) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getStartIndex(group);
    }

    public boolean hitEnd() {
        return this.inputCharIndexed.hitEnd();
    }

    public String toString() {
        CPStringBuilder sb = new CPStringBuilder();
        sb.append(this.getClass().getName()).append("[pattern=").append(this.pattern.pattern()).append(" region=").append(this.regionStart).append(",").append(this.regionEnd).append(" anchoringBounds=").append(this.anchoringBounds == 0).append(" transparentBounds=").append(this.transparentBounds).append(" lastmatch=").append(this.match == null ? "" : this.match.toString()).append("]");
        return sb.toString();
    }

    private void assertMatchOp() {
        if (this.match == null) {
            throw new IllegalStateException();
        }
    }

    public Matcher region(int start, int end) {
        int length = this.input.length();
        if (start < 0) {
            throw new IndexOutOfBoundsException("The start position was less than zero.");
        }
        if (start >= length) {
            throw new IndexOutOfBoundsException("The start position is after the end of the input.");
        }
        if (end < 0) {
            throw new IndexOutOfBoundsException("The end position was less than zero.");
        }
        if (end > length) {
            throw new IndexOutOfBoundsException("The end position is after the end of the input.");
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("The start position is after the end position.");
        }
        this.reset();
        this.regionStart = start;
        this.regionEnd = end;
        return this;
    }

    public int regionStart() {
        return this.regionStart;
    }

    public int regionEnd() {
        return this.regionEnd;
    }

    public boolean hasTransparentBounds() {
        return this.transparentBounds;
    }

    public Matcher useTransparentBounds(boolean transparent) {
        this.transparentBounds = transparent;
        return this;
    }

    public boolean hasAnchoringBounds() {
        return this.anchoringBounds == 0;
    }

    public Matcher useAnchoringBounds(boolean useAnchors) {
        this.anchoringBounds = useAnchors ? 0 : 48;
        return this;
    }

    public MatchResult toMatchResult() {
        Matcher snapshot = new Matcher(this.pattern, this.input);
        if (this.match != null) {
            snapshot.match = (REMatch)this.match.clone();
        }
        return snapshot;
    }

    public static String quoteReplacement(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        CPStringBuilder sb = new CPStringBuilder();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '$' || ch == '\\') {
                sb.append('\\');
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }
}

