/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.cert.CertStoreParameters;

public class LDAPCertStoreParameters
implements CertStoreParameters {
    private static final int LDAP_PORT = 389;
    private final String serverName;
    private final int port;

    public LDAPCertStoreParameters() {
        this("localhost", 389);
    }

    public LDAPCertStoreParameters(String serverName) {
        this(serverName, 389);
    }

    public LDAPCertStoreParameters(String serverName, int port) {
        if (serverName == null) {
            throw new NullPointerException();
        }
        this.serverName = serverName;
        this.port = port;
    }

    public Object clone() {
        return new LDAPCertStoreParameters(this.serverName, this.port);
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "LDAPCertStoreParameters: [ serverName: " + this.serverName + "; port: " + this.port + " ]";
    }
}

