/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;

public final class FilePermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 7930732926638008763L;
    private static final String ALL_FILES = "<<ALL FILES>>";
    private boolean readPerm = false;
    private boolean writePerm = false;
    private boolean executePerm = false;
    private boolean deletePerm = false;
    private final String actionsString;

    private void checkPerms() throws IllegalArgumentException {
        String action;
        int i = this.actionsString.indexOf(44);
        int startI = 0;
        while (i != -1) {
            action = this.actionsString.substring(startI, i).trim().toLowerCase();
            if (action.equals("read")) {
                this.readPerm = true;
            } else if (action.equals("write")) {
                this.writePerm = true;
            } else if (action.equals("execute")) {
                this.executePerm = true;
            } else if (action.equals("delete")) {
                this.deletePerm = true;
            } else {
                throw new IllegalArgumentException("Unknown action: " + action);
            }
            startI = i + 1;
            i = this.actionsString.indexOf(44, startI);
        }
        action = this.actionsString.substring(startI).trim().toLowerCase();
        if (action.equals("read")) {
            this.readPerm = true;
        } else if (action.equals("write")) {
            this.writePerm = true;
        } else if (action.equals("execute")) {
            this.executePerm = true;
        } else if (action.equals("delete")) {
            this.deletePerm = true;
        } else {
            throw new IllegalArgumentException("Unknown action: " + action);
        }
    }

    public FilePermission(String pathExpression, String actionsString) {
        super(pathExpression);
        if (pathExpression == null) {
            throw new NullPointerException("pathExpression");
        }
        if (actionsString == null) {
            throw new IllegalArgumentException("actionsString");
        }
        this.actionsString = actionsString;
        this.checkPerms();
    }

    public String getActions() {
        return this.actionsString;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.actionsString.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FilePermission)) {
            return false;
        }
        FilePermission p = (FilePermission)o;
        String f1 = this.getName();
        String f2 = p.getName();
        if (f1.length() > 0 && f1.charAt(f1.length() - 1) == File.separatorChar ? (f2.length() > 0 && f2.charAt(f2.length() - 1) == File.separatorChar ? !f2.equals(f1) : !f2.equals(f1.substring(0, f1.length() - 1))) : (f2.length() > 0 && f2.charAt(f2.length() - 1) == File.separatorChar ? !f1.equals(f2.substring(0, f2.length() - 1)) : !f1.equals(f2))) {
            return false;
        }
        return this.readPerm == p.readPerm && this.writePerm == p.writePerm && this.executePerm == p.executePerm && this.deletePerm == p.deletePerm;
    }

    public boolean implies(Permission p) {
        if (!(p instanceof FilePermission)) {
            return false;
        }
        String f1 = this.getName();
        if (f1.equals(ALL_FILES)) {
            return true;
        }
        FilePermission fp = (FilePermission)p;
        String f2 = fp.getName();
        if (f2.equals(ALL_FILES)) {
            return false;
        }
        try {
            f1 = new File(f1).getCanonicalPath();
            f2 = new File(f2).getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        switch (f1.charAt(f1.length() - 1)) {
            case '*': {
                String sub1 = f1.substring(0, f1.length() - 1);
                if (f2.length() <= sub1.length()) {
                    return false;
                }
                if (f2.charAt(sub1.length() - 1) == File.separatorChar) {
                    if (!f2.substring(0, sub1.length()).equals(sub1)) {
                        return false;
                    }
                    if (f2.substring(sub1.length() + 1).indexOf(File.separatorChar) == -1) break;
                    return false;
                }
                return false;
            }
            case '-': {
                String sub1 = f1.substring(0, f1.length() - 2);
                if (f2.length() < sub1.length()) {
                    return false;
                }
                if (f2.length() > sub1.length() && f2.charAt(sub1.length()) != File.separatorChar) {
                    return false;
                }
                if (f2.substring(0, sub1.length()).equals(sub1)) break;
                return false;
            }
            default: {
                if (f1.equals(f2)) break;
                return false;
            }
        }
        if (fp.readPerm && !this.readPerm) {
            return false;
        }
        if (fp.writePerm && !this.writePerm) {
            return false;
        }
        if (fp.executePerm && !this.executePerm) {
            return false;
        }
        return !fp.deletePerm || this.deletePerm;
    }
}

