/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class BandCombineOp
implements RasterOp {
    private RenderingHints hints;
    private float[][] matrix;

    public BandCombineOp(float[][] matrix, RenderingHints hints) {
        this.matrix = new float[matrix.length][];
        int width = matrix[0].length;
        int i = 0;
        while (i < matrix.length) {
            this.matrix[i] = new float[width + 1];
            int j = 0;
            while (j < width) {
                this.matrix[i][j] = matrix[i][j];
                ++j;
            }
            this.matrix[i][width] = 0.0f;
            ++i;
        }
        this.hints = hints;
    }

    public WritableRaster filter(Raster src, WritableRaster dest) {
        if (dest == null) {
            dest = this.createCompatibleDestRaster(src);
        } else if (dest.getNumBands() != src.getNumBands() || dest.getTransferType() != src.getTransferType()) {
            throw new IllegalArgumentException("Destination raster is incompatible with source raster");
        }
        int[] spix = new int[this.matrix[0].length - 1];
        int[] spix2 = new int[this.matrix[0].length - 1];
        int[] dpix = new int[this.matrix.length];
        int y = src.getMinY();
        while (y < src.getHeight() + src.getMinY()) {
            int x = src.getMinX();
            while (x < src.getWidth() + src.getMinX()) {
                spix[spix.length - 1] = 1;
                src.getPixel(x, y, spix);
                if (!Arrays.equals(spix, spix2)) {
                    System.arraycopy(spix, 0, spix2, 0, spix.length);
                    int i = 0;
                    while (i < this.matrix.length) {
                        dpix[i] = 0;
                        int j = 0;
                        while (j < this.matrix[0].length - 1) {
                            int n = i;
                            dpix[n] = dpix[n] + spix[j] * (int)this.matrix[i][j];
                            ++j;
                        }
                        ++i;
                    }
                }
                dest.setPixel(x, y, dpix);
                ++x;
            }
            ++y;
        }
        return dest;
    }

    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        if (src.getNumBands() != this.matrix.length) {
            throw new IllegalArgumentException("Number of rows in matrix specifies an incompatible number of bands");
        }
        if (src.getNumBands() != this.matrix[0].length - 1 && src.getNumBands() != this.matrix[0].length - 2) {
            throw new IllegalArgumentException("Incompatible number of bands: the number of bands in the raster must equal the number of columns in the matrix, optionally minus one");
        }
        return src.createCompatibleWritableRaster();
    }

    public final Point2D getPoint2D(Point2D src, Point2D dst) {
        if (dst == null) {
            return (Point2D)src.clone();
        }
        dst.setLocation(src);
        return dst;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final float[][] getMatrix() {
        return this.matrix;
    }
}

